/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.underground_ambience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.underground_ambience.UndergroundSound;
import svenhjol.charmonium.module.underground_ambience.UndergroundSounds;

@ClientModule(mod="charmonium", description="Plays ambient background sound when the player is underground at different depths and light levels.")
public class UndergroundAmbience
extends CharmModule {
    public Handler handler;
    @Config(name="Volume scaling", description="Affects the volume of all underground ambient sounds. 1.0 is full volume.")
    public static float volumeScaling = 0.55f;
    @Config(name="Valid dimensions", description="Dimensions in which underground ambience will be played.")
    public static List<String> configDimensions = Arrays.asList("minecraft:overworld");
    @Config(name="Cave ambience", description="If true, the cave ambience will be played. Cave ambience is normally a low frequency drone.")
    public static boolean playCaveAmbience = true;
    @Config(name="Deepcave ambience", description="If true, the deepcave ambience will be played. This takes effect when the player is deep underground and at low light level.")
    public static boolean playDeepCaveAmbience = true;
    @Config(name="Cave depth", description="When the player is lower than this depth then cave background sound will be always be triggered.")
    public static int caveDepth = 48;
    @Config(name="Light level", description="When the light is lower than this level then cave and deepcave background sound will be triggered.")
    public static int lightLevel = 10;
    public static List<class_2960> validDimensions = new ArrayList<class_2960>();

    @Override
    public void runWhenEnabled() {
        configDimensions.forEach(dim -> validDimensions.add(new class_2960(dim)));
        ClientEntityEvents.ENTITY_LOAD.register(this::handleEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(this::handleEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
    }

    private void handleEntityLoad(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1657) {
            this.trySetupSoundHandler((class_1657)entity);
        }
    }

    private void handleEntityUnload(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    public void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(player);
        }
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<UndergroundSound> {
        public Handler(@NotNull class_1657 player) {
            super(player);
            UndergroundSounds.Cave.init(this);
            UndergroundSounds.DeepCave.init(this);
        }
    }
}

