/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.situational_ambience;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.situational_ambience.SituationalSound;
import svenhjol.charmonium.module.situational_ambience.sounds.AlienSound;
import svenhjol.charmonium.module.situational_ambience.sounds.BleakSound;
import svenhjol.charmonium.module.situational_ambience.sounds.CaveWaterSound;
import svenhjol.charmonium.module.situational_ambience.sounds.DeepslateSound;
import svenhjol.charmonium.module.situational_ambience.sounds.DrySound;
import svenhjol.charmonium.module.situational_ambience.sounds.GeodeSound;
import svenhjol.charmonium.module.situational_ambience.sounds.GravelSound;
import svenhjol.charmonium.module.situational_ambience.sounds.HighSound;
import svenhjol.charmonium.module.situational_ambience.sounds.MansionSound;
import svenhjol.charmonium.module.situational_ambience.sounds.MineshaftSound;
import svenhjol.charmonium.module.situational_ambience.sounds.NightPlainsSound;
import svenhjol.charmonium.module.situational_ambience.sounds.SnowstormSound;
import svenhjol.charmonium.module.situational_ambience.sounds.VillageSound;

@ClientModule(mod="charmonium", description="Plays specific ambient sound according to the situation or location.")
public class SituationalAmbience
extends CharmModule {
    public Handler handler;
    @Config(name="Volume scaling", description="Affects the volume of all situational ambient sounds. 1.0 is full volume.")
    public static float volumeScaling = 0.55f;
    @Config(name="Alien ambience", description="If true, plays ambient sounds while anywhere in the End.")
    public static boolean alien = true;
    @Config(name="Bleak ambience", description="If true, plays ambient sounds in cold and/or barren overworld environments.")
    public static boolean bleak = true;
    @Config(name="Cave water ambience", description="If true, plays water sounds from a nearby water source when underground.")
    public static boolean caveWater = true;
    @Config(name="Deepslate ambience", description="If true, plays ambient sounds when the player is underground and near deepslate blocks.")
    public static boolean deepslate = true;
    @Config(name="Dry ambience", description="If true, plays ambient sounds in dry and/or hot overworld environments.")
    public static boolean dry = true;
    @Config(name="Geode ambience", description="If true, plays ambient sounds from a nearby amethyst geode.")
    public static boolean geode = true;
    @Config(name="Gravel ambience", description="If true, plays ambient sounds when the player is underground and near gravel blocks.")
    public static boolean gravel = true;
    @Config(name="High ambience", description="If true, plays ambient sounds when high up in the overworld.")
    public static boolean high = true;
    @Config(name="Mansion ambience", description="If true, plays ambient sounds while inside a woodland mansion.")
    public static boolean mansion = true;
    @Config(name="Mineshaft ambience", description="If true, plays ambient sounds from a nearby mineshaft.")
    public static boolean mineshaft = true;
    @Config(name="Night plains ambience", description="If true, plays ambient sounds in plains environments at night.")
    public static boolean nightPlains = true;
    @Config(name="Snowstorm ambience", description="If true, plays ambient sounds when in a cold biome during a thunderstorm.")
    public static boolean snowstorm = true;
    @Config(name="Village ambience", description="If true, plays ambient sounds when a player is inside a village.")
    public static boolean village = true;

    @Override
    public void runWhenEnabled() {
        ClientEntityEvents.ENTITY_LOAD.register(this::handleEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(this::handleEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
    }

    private void handleEntityLoad(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1657) {
            this.trySetupSoundHandler((class_1657)entity);
        }
    }

    private void handleEntityUnload(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    public void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(player);
        }
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<SituationalSound> {
        public Handler(@NotNull class_1657 player) {
            super(player);
            if (alien) {
                AlienSound.init(this);
            }
            if (bleak) {
                BleakSound.init(this);
            }
            if (caveWater) {
                CaveWaterSound.init(this);
            }
            if (deepslate) {
                DeepslateSound.init(this);
            }
            if (dry) {
                DrySound.init(this);
            }
            if (geode) {
                GeodeSound.init(this);
            }
            if (gravel) {
                GravelSound.init(this);
            }
            if (high) {
                HighSound.init(this);
            }
            if (mansion) {
                MansionSound.init(this);
            }
            if (mineshaft) {
                MineshaftSound.init(this);
            }
            if (nightPlains) {
                NightPlainsSound.init(this);
            }
            if (snowstorm) {
                SnowstormSound.init(this);
            }
            if (village) {
                VillageSound.init(this);
            }
        }
    }
}

