/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.extra_music;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5195;
import svenhjol.charmonium.Charmonium;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.helper.DimensionHelper;
import svenhjol.charmonium.helper.RegistryHelper;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.player_state.PlayerState;

@ClientModule(mod="charmonium", description="Plays custom music tracks according to the location of the player.")
public class ExtraMusic
extends CharmModule {
    private static final List<MusicCondition> musicConditions = new ArrayList<MusicCondition>();
    public static boolean isEnabled;
    public static class_3414 MUSIC_OVERWORLD;
    public static class_3414 MUSIC_COLD;
    public static class_3414 MUSIC_NETHER;
    public static class_3414 MUSIC_RUIN;
    @Config(name="Play Creative music", description="If true, the six Creative music tracks may play in survival mode.")
    public static boolean playCreativeMusic;
    @Config(name="Play Overworld music", description="If true, custom overworld-themed tracks may play.")
    public static boolean playOverworldMusic;
    @Config(name="Play Nether music", description="If true, custom nether-themed tracks may play.")
    public static boolean playNetherMusic;
    @Config(name="Play Ruin music", description="If true, underground ruin-themed tracks may play.  This requires Charm on the server.")
    public static boolean playRuinMusic;

    @Override
    public void register() {
        MUSIC_OVERWORLD = RegistryHelper.sound("music.overworld");
        MUSIC_NETHER = RegistryHelper.sound("music.nether");
        MUSIC_COLD = RegistryHelper.sound("music.cold");
        MUSIC_RUIN = RegistryHelper.sound("music.ruin");
    }

    @Override
    public void runWhenEnabled() {
        isEnabled = Charmonium.LOADER.isEnabled("extra_music");
        if (playOverworldMusic) {
            ExtraMusic.getMusicConditions().add(new MusicCondition(MUSIC_OVERWORLD, 1200, 3600, mc -> mc.field_1724 != null && DimensionHelper.isOverworld(mc.field_1724.field_6002) && mc.field_1724.field_6002.field_9229.nextFloat() < 0.08f));
            ExtraMusic.getMusicConditions().add(new MusicCondition(MUSIC_COLD, 1200, 3600, mc -> mc.field_1724 != null && mc.field_1724.field_6002.method_23753(mc.field_1724.method_24515()).method_8688() == class_1959.class_1961.field_9362 && mc.field_1724.field_6002.field_9229.nextFloat() < 0.28f));
        }
        if (playNetherMusic) {
            ExtraMusic.getMusicConditions().add(new MusicCondition(MUSIC_NETHER, 1200, 3600, mc -> mc.field_1724 != null && DimensionHelper.isNether(mc.field_1724.field_6002) && mc.field_1724.method_24515().method_10264() < 48 && mc.field_1724.field_6002.field_9229.nextFloat() < 0.33f));
        }
        if (playRuinMusic) {
            ExtraMusic.getMusicConditions().add(new MusicCondition(MUSIC_RUIN, 1200, 3600, mc -> mc.field_1724 != null && PlayerState.insideOverworldRuin && mc.field_1724.field_6002.field_9229.nextFloat() < 0.33f));
        }
        if (playCreativeMusic) {
            ExtraMusic.getMusicConditions().add(new MusicCondition(class_3417.field_14995, 1200, 3600, mc -> {
                if (mc.field_1724 == null) return false;
                if (mc.field_1724.method_7337()) {
                    if (mc.field_1724.method_7325()) return false;
                }
                if (!DimensionHelper.isOverworld(mc.field_1724.field_6002)) return false;
                Random random = new Random();
                if (!(random.nextFloat() < 0.25f)) return false;
                return true;
            }));
        }
    }

    @Nullable
    public static class_5195 getMusic() {
        for (MusicCondition c : musicConditions) {
            if (!c.handle()) continue;
            return c.getMusic();
        }
        return null;
    }

    public static List<MusicCondition> getMusicConditions() {
        return musicConditions;
    }

    static {
        playCreativeMusic = true;
        playOverworldMusic = true;
        playNetherMusic = true;
        playRuinMusic = true;
    }

    public static class MusicCondition {
        private final class_3414 sound;
        private final int minDelay;
        private final int maxDelay;
        private Predicate<class_310> condition;

        public MusicCondition(class_3414 sound, int minDelay, int maxDelay, Predicate<class_310> condition) {
            this.sound = sound;
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.condition = condition;
        }

        public MusicCondition(class_5195 music) {
            this.sound = music.method_27279();
            this.minDelay = music.method_27280();
            this.maxDelay = music.method_27281();
        }

        public boolean handle() {
            if (this.condition == null) {
                return false;
            }
            return this.condition.test(class_310.method_1551());
        }

        public class_5195 getMusic() {
            return new class_5195(this.sound, this.minDelay, this.maxDelay, false);
        }

        public class_3414 getSound() {
            return this.sound;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }

        public int getMinDelay() {
            return this.minDelay;
        }
    }
}

