/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.biome_ambience.BiomeSound;
import svenhjol.charmonium.module.biome_ambience.BiomeSounds;

@ClientModule(mod="charmonium", description="Plays ambient background sound according to the biome and time of day.")
public class BiomeAmbience
extends CharmModule {
    public Handler handler;
    @Config(name="Volume scaling", description="Affects the volume of all biome ambient sounds. 1.0 is full volume.")
    public static float volumeScaling = 0.55f;
    @Config(name="Beach ambience", description="If true, plays ambient sounds in beach biomes.")
    public static boolean beach = true;
    @Config(name="Badlands ambience", description="If true, plays ambient sounds in badlands (mesa) biomes.")
    public static boolean badlands = true;
    @Config(name="Desert ambience", description="If true, plays ambient sounds in desert biomes.")
    public static boolean desert = true;
    @Config(name="Forest ambience", description="If true, plays ambient sounds in forest biomes.")
    public static boolean forest = true;
    @Config(name="Icy ambience", description="If true, plays ambient sounds in cold (tundra, snowy) biomes.")
    public static boolean icy = true;
    @Config(name="Jungle ambience", description="If true, plays ambient sounds in jungle biomes.")
    public static boolean jungle = true;
    @Config(name="Mountains ambience", description="If true, plays ambient sounds in mountain biomes.")
    public static boolean mountains = true;
    @Config(name="Ocean ambience", description="If true, plays ambient sounds in ocean biomes when above the water surface.")
    public static boolean ocean = true;
    @Config(name="Plains ambience", description="If true, plays ambient sounds in plains biomes.")
    public static boolean plains = true;
    @Config(name="Savanna ambience", description="If true, plays ambient sounds in savanna biomes.")
    public static boolean savanna = true;
    @Config(name="Swamp ambience", description="If true, plays ambient sounds in swamp biomes.")
    public static boolean swamp = true;
    @Config(name="Taiga ambience", description="If true, plays ambient sounds in taiga biomes.")
    public static boolean taiga = true;
    @Config(name="The End ambience", description="If true, plays ambient sounds in the End biomes.")
    public static boolean theEnd = true;

    @Override
    public void runWhenEnabled() {
        ClientEntityEvents.ENTITY_LOAD.register(this::handleEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(this::handleEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
    }

    private void handleEntityLoad(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1657) {
            this.trySetupSoundHandler((class_1657)entity);
        }
    }

    private void handleEntityUnload(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    public void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(player);
        }
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<BiomeSound> {
        private Handler(@NotNull class_1657 player) {
            super(player);
            if (beach) {
                BiomeSounds.Beach.init(this);
            }
            if (badlands) {
                BiomeSounds.Badlands.init(this);
            }
            if (desert) {
                BiomeSounds.Desert.init(this);
            }
            if (forest) {
                BiomeSounds.Forest.init(this);
            }
            if (icy) {
                BiomeSounds.Icy.init(this);
            }
            if (jungle) {
                BiomeSounds.Jungle.init(this);
            }
            if (mountains) {
                BiomeSounds.Mountains.init(this);
            }
            if (ocean) {
                BiomeSounds.Ocean.init(this);
            }
            if (plains) {
                BiomeSounds.Plains.init(this);
            }
            if (savanna) {
                BiomeSounds.Savanna.init(this);
            }
            if (swamp) {
                BiomeSounds.Swamp.init(this);
            }
            if (taiga) {
                BiomeSounds.Taiga.init(this);
            }
            if (theEnd) {
                BiomeSounds.TheEnd.init(this);
            }
        }
    }
}

