/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.loader;

import com.moandjiezana.toml.Toml;
import java.util.List;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.helper.ConfigHelper;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.loader.ModuleLoader;

public class ClientLoader<T extends CharmModule>
extends ModuleLoader<T> {
    public ClientLoader(String modId, String basePackage) {
        super(modId, basePackage);
    }

    @Override
    protected String getModuleAnnotation() {
        return "Lsvenhjol/charmonium/annotation/ClientModule;";
    }

    @Override
    protected void setupModuleAnnotations(Class<T> clazz, T module) throws IllegalStateException {
        if (!clazz.isAnnotationPresent(ClientModule.class)) {
            throw new RuntimeException("[ClientLoader] Missing annotation for client module `" + clazz + "`");
        }
        ClientModule annotation = clazz.getAnnotation(ClientModule.class);
        ((CharmModule)module).setModId(this.getModId());
        ((CharmModule)module).setPriority(annotation.priority());
        ((CharmModule)module).setAlwaysEnabled(annotation.alwaysEnabled());
        ((CharmModule)module).setDescription(annotation.description());
        ((CharmModule)module).setEnabledByDefault(annotation.enabledByDefault());
        ((CharmModule)module).setEnabled(((CharmModule)module).isEnabledByDefault());
    }

    @Override
    protected void setupModuleConfig(List<T> modules) {
        Toml toml = ConfigHelper.readConfig(this.getModId());
        ConfigHelper.applyConfig(toml, modules);
        modules.forEach(module -> module.setEnabled(!ConfigHelper.isModuleDisabled(toml, module.getName())));
        ConfigHelper.writeConfig(this.getModId(), modules);
    }
}

