/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util.pooled.cache;

import io.github.cadiboo.nocubes.util.pooled.cache.XYZCache;
import javax.annotation.Nonnull;

public final class SmoothableCache
extends XYZCache
implements AutoCloseable {
    private static final ThreadLocal<SmoothableCache> POOL = ThreadLocal.withInitial(() -> new SmoothableCache(0, 0, 0, 0, 0, 0));
    @Nonnull
    private boolean[] cache;
    private boolean inUse;

    private SmoothableCache(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        super(startPaddingX, startPaddingY, startPaddingZ, sizeX, sizeY, sizeZ);
        this.cache = new boolean[sizeX * sizeY * sizeZ];
        this.inUse = false;
    }

    @Nonnull
    public static SmoothableCache retain(int startPaddingX, int startPaddingY, int startPaddingZ, int sizeX, int sizeY, int sizeZ) {
        SmoothableCache pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("SmoothableCache is already in use!");
        }
        pooled.inUse = true;
        pooled.startPaddingX = startPaddingX;
        pooled.startPaddingY = startPaddingY;
        pooled.startPaddingZ = startPaddingZ;
        if (pooled.sizeX == sizeX && pooled.sizeY == sizeY && pooled.sizeZ == sizeZ) {
            return pooled;
        }
        pooled.sizeX = sizeX;
        pooled.sizeY = sizeY;
        pooled.sizeZ = sizeZ;
        int size = sizeX * sizeY * sizeZ;
        if (pooled.cache.length < size || (float)pooled.cache.length > (float)size * 1.25f) {
            pooled.cache = new boolean[size];
        }
        return pooled;
    }

    @Nonnull
    public boolean[] getSmoothableCache() {
        return this.cache;
    }

    @Override
    public void close() {
        this.inUse = false;
    }
}

