/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util.pooled;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public final class Vec3
implements AutoCloseable {
    private static final ArrayList<Vec3> POOL = new ArrayList();
    public double x;
    public double y;
    public double z;

    private Vec3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Vec3 retain(double x, double y, double z) {
        ArrayList<Vec3> arrayList = POOL;
        synchronized (arrayList) {
            Vec3 pooled;
            if (!POOL.isEmpty() && (pooled = POOL.remove(POOL.size() - 1)) != null) {
                pooled.x = x;
                pooled.y = y;
                pooled.z = z;
                return pooled;
            }
        }
        return new Vec3(x, y, z);
    }

    @Nonnull
    public static Vec3 retain(double[] vertexAsArray) {
        return Vec3.retain(vertexAsArray[0], vertexAsArray[1], vertexAsArray[2]);
    }

    @Nonnull
    public static Vec3 retain(float[] vertexAsArray) {
        return Vec3.retain(vertexAsArray[0], vertexAsArray[1], vertexAsArray[2]);
    }

    public Vec3 addOffset(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec3 copy() {
        return new Vec3(this.x, this.y, this.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Vec3> arrayList = POOL;
        synchronized (arrayList) {
            POOL.add(this);
        }
    }

    public Vec3 multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vec3 multiply(double d) {
        return this.multiply(d, d, d);
    }

    public Vec3 normalise() {
        double length = MathHelper.func_76133_a((double)(this.x * this.x + this.y * this.y + this.z * this.z));
        if (length < 1.0E-4) {
            return this;
        }
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public static Vec3 normal(Vec3 prevVecInFace, Vec3 vec, Vec3 nextVecInFace, Vec3 toUse) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        return Vec3.cross(prevVecInFace.x - x, prevVecInFace.y - y, prevVecInFace.z - z, nextVecInFace.x - x, nextVecInFace.y - y, nextVecInFace.z - z, toUse).normalise();
    }

    public static Vec3 cross(double x0, double y0, double z0, double x1, double y1, double z1, Vec3 toUse) {
        toUse.x = y0 * z1 - z0 * y1;
        toUse.y = z0 * x1 - x0 * z1;
        toUse.z = x0 * y1 - y0 * x1;
        return toUse;
    }
}

