/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.tempcore.NoCubesLoadingPlugin;
import io.github.cadiboo.nocubes.util.BadAutoUpdater;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.ModContainer;

public final class ModUtil {
    public static final EnumFacing[] DIRECTION_VALUES = EnumFacing.field_82609_l;
    public static final int DIRECTION_VALUES_LENGTH = DIRECTION_VALUES.length;
    public static final Random RANDOM = new Random();
    public static final int COMMAND_PERMISSION_LEVEL = 2;
    public static final String COMMAND_PERMISSION_NAME = "give";

    public static float getIndividualBlockDensity(boolean shouldSmooth, IBlockState state) {
        if (shouldSmooth) {
            if (state.func_177230_c() == Blocks.field_150431_aC) {
                int value = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                if (value == 1) {
                    return 1.0f;
                }
                return -((float)(value - 1) * 0.125f);
            }
            return state.func_177230_c() == Blocks.field_150357_h ? -1.0005f : -1.0f;
        }
        if (state.func_185915_l() || state.func_185898_k()) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static Vec3 offsetVertex(Vec3 vec3) {
        long rand = (long)(vec3.x * 3129871.0) ^ (long)vec3.z * 116129781L ^ (long)vec3.y;
        rand = rand * rand * 42317861L + rand * 11L;
        vec3.x += ((double)((float)(rand >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        vec3.y += ((double)((float)(rand >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        vec3.z += ((double)((float)(rand >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        return vec3;
    }

    public static void launchUpdateDaemon(@Nonnull ModContainer modContainer) {
        new Thread(() -> {
            block8: while (true) {
                ForgeVersion.CheckResult checkResult = ForgeVersion.getResult((ModContainer)modContainer);
                switch (checkResult.status) {
                    default: {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException var4) {
                            Thread.currentThread().interrupt();
                        }
                        continue block8;
                    }
                    case OUTDATED: {
                        try {
                            BadAutoUpdater.update(modContainer, checkResult.target.toString(), "Cadiboo");
                            break block8;
                        }
                        catch (Exception var3) {
                            throw new RuntimeException(var3);
                        }
                    }
                    case FAILED: 
                    case UP_TO_DATE: 
                    case AHEAD: 
                    case BETA: 
                    case BETA_OUTDATED: 
                }
                break;
            }
        }, modContainer.getName() + " Update Daemon").start();
    }

    public static boolean isDeveloperWorkspace() {
        return NoCubesLoadingPlugin.DEVELOPER_ENVIRONMENT;
    }

    public static byte getMeshSizeX(int initialSize, MeshGenerator meshGenerator) {
        return (byte)(initialSize + meshGenerator.getSizeXExtension());
    }

    public static byte getMeshSizeY(int initialSize, MeshGenerator meshGenerator) {
        return (byte)(initialSize + meshGenerator.getSizeYExtension());
    }

    public static byte getMeshSizeZ(int initialSize, MeshGenerator meshGenerator) {
        return (byte)(initialSize + meshGenerator.getSizeZExtension());
    }

    public static boolean isMaterialGrass(Material material) {
        return material == Material.field_151582_l || material == Material.field_151577_b;
    }

    public static boolean isMaterialLeaves(Material material) {
        return material == Material.field_151584_j;
    }

    public static byte getRelativePos(int chunkPos, int blockPos) {
        int blockPosChunkPos = blockPos >> 4 << 4;
        if (chunkPos == blockPosChunkPos) {
            return ModUtil.getRelativePos(blockPos);
        }
        return (byte)(blockPos - chunkPos);
    }

    public static byte getRelativePos(int blockPos) {
        return (byte)(blockPos & 0xF);
    }

    public static void preloadClass(@Nonnull String qualifiedName, @Nonnull String simpleName) {
        try {
            NoCubes.LOGGER.info("Loading class \"" + simpleName + "\"...");
            ClassLoader classLoader = NoCubes.class.getClassLoader();
            long startTime = System.nanoTime();
            Class.forName(qualifiedName, false, classLoader);
            NoCubes.LOGGER.info("Loaded class \"" + simpleName + "\" in " + (System.nanoTime() - startTime) + " nano seconds");
            NoCubes.LOGGER.info("Initialising class \"" + simpleName + "\"...");
            Class.forName(qualifiedName, true, classLoader);
            NoCubes.LOGGER.info("Initialised \"" + simpleName + "\"");
        }
        catch (ClassNotFoundException e) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)("Failed to load class \"" + simpleName + "\". This should not be possible!"));
            crashReport.func_85058_a("Loading class");
            throw new ReportedException(crashReport);
        }
    }
}

