/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.util.Profiler1122;
import java.util.HashMap;

public final class ModProfiler
extends Profiler1122
implements AutoCloseable {
    public static final HashMap<Thread, ModProfiler> PROFILERS = new HashMap();
    private static final ThreadLocal<ModProfiler> PROFILER = ThreadLocal.withInitial(() -> {
        ModProfiler profiler = new ModProfiler();
        PROFILERS.put(Thread.currentThread(), profiler);
        return profiler;
    });
    private int virtualSections = 0;
    private int startedSections = 0;

    public static synchronized void enableProfiling() {
        profilingEnabled = true;
    }

    public static synchronized void disableProfiling() {
        profilingEnabled = false;
    }

    public static ModProfiler get() {
        return PROFILER.get();
    }

    public ModProfiler start(String name) {
        if (this.startedSections == this.virtualSections++ && profilingEnabled) {
            ++this.startedSections;
            this.startSection(name);
        }
        return this;
    }

    public void end() {
        if (this.startedSections == this.virtualSections--) {
            --this.startedSections;
            this.endSection();
        }
    }

    @Override
    public void close() {
        this.end();
    }
}

