/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            FileUtils.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException var3) {
                if (var3 instanceof FileAlreadyExistsException) {
                    LOGGER.fatal("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.fatal("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)var3);
                }
                throw new RuntimeException("Problem creating directory", var3);
            }
            LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }

    public static String fileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int idx = fileName.lastIndexOf(46);
        return idx > -1 ? fileName.substring(idx + 1) : "";
    }
}

