/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.cache.DensityCache;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public final class CacheUtil {
    public static StateCache generateStateCache(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int startPaddingX, int startPaddingY, int startPaddingZ, @Nonnull World cache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int cacheSizeX = Math.abs(toX - fromX);
        int cacheSizeY = Math.abs(toY - fromY);
        int cacheSizeZ = Math.abs(toZ - fromZ);
        StateCache stateCache = StateCache.retain(startPaddingX, startPaddingY, startPaddingZ, cacheSizeX, cacheSizeY, cacheSizeZ);
        try {
            IBlockState[] blockStates = stateCache.getBlockStates();
            try (ModProfiler ignored = ModProfiler.get().start("fillStateCache");){
                CacheUtil.fillStateCache(fromX, fromY, fromZ, cacheSizeX, cacheSizeY, cacheSizeZ, cache, pooledMutableBlockPos, blockStates);
            }
            return stateCache;
        }
        catch (Exception e) {
            stateCache.close();
            throw e;
        }
    }

    private static void fillStateCache(int fromX, int fromY, int fromZ, int cacheSizeX, int cacheSizeY, int cacheSizeZ, @Nonnull World cache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos, IBlockState[] blockStates) {
        int cx = fromX >> 4;
        int cz = fromZ >> 4;
        Chunk currentChunk = cache.func_72964_e(cx, cz);
        int index = 0;
        for (int z = 0; z < cacheSizeZ; ++z) {
            for (int y = 0; y < cacheSizeY; ++y) {
                int x = 0;
                while (x < cacheSizeX) {
                    IBlockState blockState;
                    int checkX = fromX + x;
                    int checkZ = fromZ + z;
                    boolean changed = false;
                    if (cx != checkX >> 4) {
                        cx = checkX >> 4;
                        changed = true;
                    }
                    if (cz != checkZ >> 4) {
                        cz = checkZ >> 4;
                        changed = true;
                    }
                    if (changed) {
                        currentChunk = cache.func_72964_e(cx, cz);
                    }
                    pooledMutableBlockPos.func_181079_c(checkX, fromY + y, checkZ);
                    blockStates[index] = blockState = currentChunk.func_177435_g((BlockPos)pooledMutableBlockPos);
                    ++x;
                    ++index;
                }
            }
        }
    }

    public static SmoothableCache generateSmoothableCache(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int startPaddingX, int startPaddingY, int startPaddingZ, @Nonnull StateCache stateCache, @Nonnull IsSmoothable isStateSmoothable) {
        int cacheSizeX = Math.abs(toX - fromX);
        int cacheSizeY = Math.abs(toY - fromY);
        int cacheSizeZ = Math.abs(toZ - fromZ);
        try (ModProfiler ignored = ModProfiler.get().start("generate smoothableCache");){
            SmoothableCache smoothableCache = SmoothableCache.retain(startPaddingX, startPaddingY, startPaddingZ, cacheSizeX, cacheSizeY, cacheSizeZ);
            boolean[] smoothableCacheArray = smoothableCache.getSmoothableCache();
            int stateCacheSizeX = stateCache.sizeX;
            int stateCacheSizeY = stateCache.sizeY;
            int diffX = stateCache.startPaddingX - startPaddingX;
            int diffY = stateCache.startPaddingY - startPaddingY;
            int diffZ = stateCache.startPaddingZ - startPaddingZ;
            IBlockState[] blockStateArray = stateCache.getBlockStates();
            int smoothableIndex = 0;
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int y = 0; y < cacheSizeY; ++y) {
                    int x = 0;
                    while (x < cacheSizeX) {
                        smoothableCacheArray[smoothableIndex] = isStateSmoothable.test(blockStateArray[stateCache.getIndex(x + diffX, y + diffY, z + diffZ, stateCacheSizeX, stateCacheSizeY)]);
                        ++x;
                        ++smoothableIndex;
                    }
                }
            }
            SmoothableCache smoothableCache2 = smoothableCache;
            return smoothableCache2;
        }
    }

    public static DensityCache generateDensityCache(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int startPaddingX, int startPaddingY, int startPaddingZ, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache) {
        int cacheSizeX = Math.abs(toX - fromX);
        int cacheSizeY = Math.abs(toY - fromY);
        int cacheSizeZ = Math.abs(toZ - fromZ);
        try (ModProfiler ignored = ModProfiler.get().start("generate densityCache");){
            DensityCache densityCache = DensityCache.retain(startPaddingX, startPaddingY, startPaddingZ, cacheSizeX, cacheSizeY, cacheSizeZ);
            float[] densityCacheArray = densityCache.getDensityCache();
            int index = 0;
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int y = 0; y < cacheSizeY; ++y) {
                    int x = 0;
                    while (x < cacheSizeX) {
                        densityCacheArray[index] = CacheUtil.getBlockDensity(x, y, z, startPaddingX, startPaddingY, startPaddingZ, stateCache, smoothableCache);
                        ++x;
                        ++index;
                    }
                }
            }
            DensityCache densityCache2 = densityCache;
            return densityCache2;
        }
    }

    private static float getBlockDensity(int posX, int posY, int posZ, int densityCacheStartPaddingX, int densityCacheStartPaddingY, int densityCacheStartPaddingZ, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache) {
        int stateCacheDiffX = stateCache.startPaddingX - densityCacheStartPaddingX;
        int stateCacheDiffY = stateCache.startPaddingY - densityCacheStartPaddingY;
        int stateCacheDiffZ = stateCache.startPaddingZ - densityCacheStartPaddingZ;
        int stateCacheSizeX = stateCache.sizeX;
        int stateCacheSizeY = stateCache.sizeY;
        IBlockState[] stateCacheArray = stateCache.getBlockStates();
        int smoothableCacheSizeX = smoothableCache.sizeX;
        int smoothableCacheSizeY = smoothableCache.sizeY;
        boolean[] smoothableCacheArray = smoothableCache.getSmoothableCache();
        float density = 0.0f;
        for (int zOffset = 0; zOffset < 2; ++zOffset) {
            for (int yOffset = 0; yOffset < 2; ++yOffset) {
                for (int xOffset = 0; xOffset < 2; ++xOffset) {
                    density += ModUtil.getIndividualBlockDensity(smoothableCacheArray[smoothableCache.getIndex(posX + xOffset, posY + yOffset, posZ + zOffset, smoothableCacheSizeX, smoothableCacheSizeY)], stateCacheArray[stateCache.getIndex(posX + xOffset + stateCacheDiffX, posY + yOffset + stateCacheDiffY, posZ + zOffset + stateCacheDiffZ, stateCacheSizeX, stateCacheSizeY)]);
                }
            }
        }
        return density;
    }
}

