/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.tempcore.classwriter;

import io.github.cadiboo.nocubes.tempcore.NoCubesLoadingPlugin;
import io.github.cadiboo.nocubes.tempcore.classwriter.ObfHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLRemappingAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class MCWriter
extends ClassWriter {
    private static final boolean RECALC_FRAMES = Boolean.parseBoolean(System.getProperty("FORGE_FORCE_FRAME_RECALC", "false"));
    private static final int READER_FLAGS = RECALC_FRAMES ? 4 : 8;
    public static Map<String, ClassReader> offMemoryCache = new HashMap<String, ClassReader>(50);
    private LaunchClassLoader l = Launch.classLoader;

    public MCWriter(int flags) {
        super(flags);
    }

    public static ClassReader patchClass(ClassReader reader) {
        ClassWriter classWriter = new ClassWriter(1);
        FMLRemappingAdapter remapAdapter = new FMLRemappingAdapter((ClassVisitor)classWriter);
        reader.accept((ClassVisitor)remapAdapter, READER_FLAGS);
        return new ClassReader(classWriter.toByteArray());
    }

    private StringBuilder typeAncestors(String type, ClassReader info) throws Exception {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader info, String itf) throws Exception {
        while (!"java/lang/Object".equals(type)) {
            int i;
            String[] itfs = info.getInterfaces();
            for (i = 0; i < itfs.length; ++i) {
                if (!itfs[i].equals(itf)) continue;
                return true;
            }
            for (i = 0; i < itfs.length; ++i) {
                if (!this.typeImplements(itfs[i], this.typeInfo(itfs[i]), itf)) continue;
                return true;
            }
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader typeInfo(String t) throws Exception {
        String type = ObfHelper.toObfClassName(t);
        if (offMemoryCache.containsKey(type)) {
            return offMemoryCache.get(type);
        }
        try (InputStream is = this.l.getResourceAsStream(type + ".class");){
            ClassReader reader = new ClassReader(is);
            if (!NoCubesLoadingPlugin.DEVELOPER_ENVIRONMENT) {
                reader = MCWriter.patchClass(reader);
            }
            offMemoryCache.put(type, reader);
            ClassReader classReader = reader;
            return classReader;
        }
    }

    public byte[] toByteArray() {
        offMemoryCache.clear();
        return super.toByteArray();
    }

    protected String getCommonSuperClass(String t1, String t2) {
        try {
            String result;
            block7: {
                String type1 = ObfHelper.forceToDeobfClassName(t1);
                String type2 = ObfHelper.forceToDeobfClassName(t2);
                ClassReader info1 = this.typeInfo(type1);
                ClassReader info2 = this.typeInfo(type2);
                if ((info1.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type2, info2, type1)) {
                        return type1;
                    }
                    return "java/lang/Object";
                }
                if ((info2.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block7;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }
}

