/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.tempcore;

import io.github.cadiboo.nocubes.tempcore.NoCubesClassTransformer;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

final class WorldTransformer
implements Opcodes {
    private static final int ALOCALVARIABLE_this = 0;
    private static final int ALOCALVARIABLE_movingEntity = 1;
    private static final int ALOCALVARIABLE_area = 2;
    private static final int ALOCALVARIABLE_entityShape = 3;
    private static final int ILOCALVARIABLE_flag1 = 6;

    WorldTransformer() {
    }

    static void transform(ClassNode classNode) {
        List methods = classNode.methods;
        String targetMethodDesc = "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;)Z";
        String targetMethodName = NoCubesClassTransformer.mapMethod("net/minecraft/world/World", "func_191504_a", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;)Z");
        NoCubesClassTransformer.start("Find " + targetMethodName);
        for (MethodNode method : methods) {
            if (!method.name.equals(targetMethodName)) {
                NoCubesClassTransformer.log("Did not match method name " + targetMethodName + " - " + method.name);
                continue;
            }
            if (!method.desc.equals("(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;)Z")) {
                NoCubesClassTransformer.log("Did not match method desc (Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;)Z - " + method.desc);
                continue;
            }
            NoCubesClassTransformer.log("Matched method " + method.name + " " + method.desc);
            NoCubesClassTransformer.finish();
            NoCubesClassTransformer.start("Inject getCollisionBoxes hook");
            WorldTransformer.injectGetCollisionBoxesHook(method.instructions);
            NoCubesClassTransformer.finish();
            break;
        }
    }

    private static void injectGetCollisionBoxesHook(InsnList instructions) {
        FieldInsnNode instruction;
        String STONE_name = NoCubesClassTransformer.mapField("net/minecraft/init/Blocks", "field_150348_b");
        FieldInsnNode first_GETSTATIC_STONE = null;
        int arrayLength = instructions.size();
        for (int i = 0; i < arrayLength; ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getOpcode() != 178) continue;
            instruction = (FieldInsnNode)insn;
            if (!instruction.owner.equals("net/minecraft/init/Blocks") || !instruction.name.equals(STONE_name)) continue;
            first_GETSTATIC_STONE = instruction;
            NoCubesClassTransformer.log("Found injection point " + instruction);
            break;
        }
        if (first_GETSTATIC_STONE == null) {
            throw new RuntimeException("Error: Couldn't find injection point!");
        }
        FieldInsnNode firstLabelBefore_first_GETSTATIC_STONE = null;
        for (int i = instructions.indexOf(first_GETSTATIC_STONE); i >= 0; --i) {
            instruction = instructions.get(i);
            if (instruction.getType() != 8) continue;
            firstLabelBefore_first_GETSTATIC_STONE = instruction;
            NoCubesClassTransformer.log("Found label " + instruction);
            break;
        }
        if (firstLabelBefore_first_GETSTATIC_STONE == null) {
            throw new RuntimeException("Error: Couldn't find label!");
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 4));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 5));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 6));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 7));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 8));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 9));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 10));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 11));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 12));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 13));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "io/github/cadiboo/nocubes/hooks/Hooks", "getCollisionBoxes", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;IIIIIILnet/minecraft/world/border/WorldBorder;ZZ)Z", false));
        toInject.add((AbstractInsnNode)new InsnNode(172));
        instructions.insert((AbstractInsnNode)firstLabelBefore_first_GETSTATIC_STONE, toInject);
    }
}

