/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.tempcore;

import io.github.cadiboo.nocubes.tempcore.NoCubesClassTransformer;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

final class RenderChunkTransformer
implements Opcodes {
    private static boolean optifine;

    RenderChunkTransformer() {
    }

    static void transform(ClassNode classNode) {
        List methods = classNode.methods;
        String targetMethodDesc = "(FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V";
        String targetMethodName = NoCubesClassTransformer.mapMethod("net/minecraft/client/renderer/chunk/RenderChunk", "func_178581_b", "(FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V");
        NoCubesClassTransformer.start("Find " + targetMethodName);
        for (MethodNode method : methods) {
            if (!method.name.equals(targetMethodName)) {
                NoCubesClassTransformer.log("Did not match method name " + targetMethodName + " - " + method.name);
                continue;
            }
            if (!method.desc.equals("(FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V")) {
                NoCubesClassTransformer.log("Did not match method desc (FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V - " + method.desc);
                continue;
            }
            NoCubesClassTransformer.log("Matched method " + method.name + " " + method.desc);
            NoCubesClassTransformer.finish();
            NoCubesClassTransformer.start("Inject pre-iteration hook");
            RenderChunkTransformer.injectPreIterationHook(method.instructions);
            NoCubesClassTransformer.finish();
            NoCubesClassTransformer.start("Apply BlockRender hook");
            RenderChunkTransformer.injectBlockRenderHook(method.instructions);
            NoCubesClassTransformer.finish();
            break;
        }
    }

    private static void injectPreIterationHook(InsnList instructions) {
        MethodInsnNode instruction;
        String getAllInBoxMutable_name = NoCubesClassTransformer.mapMethod("net/minecraft/util/math/BlockPos", "func_177975_b", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Ljava/lang/Iterable;");
        optifine = false;
        MethodInsnNode first_INVOKESTATIC_getAllInBoxMutable = null;
        int arrayLength = instructions.size();
        for (int i = 0; i < arrayLength; ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getOpcode() != 184) continue;
            instruction = (MethodInsnNode)insn;
            if (!instruction.owner.equals("net/minecraft/util/math/BlockPos") && !instruction.owner.equals("net/optifine/BlockPosM") || !instruction.name.equals(getAllInBoxMutable_name) && !instruction.name.equals("getAllInBoxMutable") || !instruction.desc.equals("(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Ljava/lang/Iterable;") || instruction.itf) continue;
            first_INVOKESTATIC_getAllInBoxMutable = instruction;
            NoCubesClassTransformer.log("Found Injection Point");
            optifine = instruction.owner.equals("net/optifine/BlockPosM");
            NoCubesClassTransformer.log("OptiFine: " + optifine);
            break;
        }
        if (first_INVOKESTATIC_getAllInBoxMutable == null) {
            throw new RuntimeException("Error: Couldn't find injection point!");
        }
        MethodInsnNode firstLabelBefore_first_INVOKESTATIC_getAllInBoxMutable = null;
        for (int i = instructions.indexOf(first_INVOKESTATIC_getAllInBoxMutable); i >= 0; --i) {
            instruction = instructions.get(i);
            if (instruction.getType() != 8) continue;
            firstLabelBefore_first_INVOKESTATIC_getAllInBoxMutable = instruction;
            NoCubesClassTransformer.log("Found label " + instruction);
            break;
        }
        if (firstLabelBefore_first_INVOKESTATIC_getAllInBoxMutable == null) {
            throw new RuntimeException("Error: Couldn't find label!");
        }
        InsnList toInject = new InsnList();
        LabelNode originalInstructionsLabel = new LabelNode();
        String worldFieldName = NoCubesClassTransformer.mapField("net/minecraft/client/renderer/chunk/RenderChunk", "field_178588_d");
        if (!optifine) {
            String worldViewFieldName = NoCubesClassTransformer.mapField("net/minecraft/client/renderer/chunk/RenderChunk", "field_189564_r");
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 3));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 4));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 5));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 7));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 8));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/chunk/RenderChunk", worldFieldName, "Lnet/minecraft/world/World;"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/chunk/RenderChunk", worldViewFieldName, "Lnet/minecraft/world/ChunkCache;"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 9));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 10));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 11));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 12));
        } else {
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 3));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 4));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 5));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 7));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 8));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/chunk/RenderChunk", worldFieldName, "Lnet/minecraft/world/World;"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 11));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 9));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 10));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 12));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 13));
        }
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "io/github/cadiboo/nocubes/hooks/Hooks", "preIteration", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;Lnet/minecraft/client/renderer/chunk/CompiledChunk;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/World;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/chunk/VisGraph;Ljava/util/HashSet;[ZLnet/minecraft/client/renderer/BlockRendererDispatcher;)V", false));
        toInject.add((AbstractInsnNode)originalInstructionsLabel);
        instructions.insert((AbstractInsnNode)firstLabelBefore_first_INVOKESTATIC_getAllInBoxMutable, toInject);
    }

    static void injectBlockRenderHook(InsnList instructions) {
        MethodInsnNode instruction;
        LabelNode blockCannotRenderLabel = null;
        String getRenderType_name = NoCubesClassTransformer.mapMethod("net/minecraft/block/state/IBlockProperties", "func_185901_i", "()Lnet/minecraft/util/EnumBlockRenderType;");
        MethodInsnNode IBlockState_getRenderType = null;
        int arrayLength = instructions.size();
        for (int i = 0; i < arrayLength; ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getOpcode() != 185) continue;
            instruction = (MethodInsnNode)insn;
            if (!instruction.owner.equals("net/minecraft/block/state/IBlockState") || !instruction.name.equals(getRenderType_name) || !instruction.desc.equals("()Lnet/minecraft/util/EnumBlockRenderType;") || !instruction.itf) continue;
            IBlockState_getRenderType = instruction;
            NoCubesClassTransformer.log("Found injection point " + instruction);
            break;
        }
        if (IBlockState_getRenderType == null) {
            throw new RuntimeException("Error: Couldn't find injection point!");
        }
        MethodInsnNode firstLabelBefore_IBlockState_getRenderType = null;
        for (int i = instructions.indexOf(IBlockState_getRenderType); i >= 0; --i) {
            instruction = instructions.get(i);
            if (instruction.getType() != 8) continue;
            firstLabelBefore_IBlockState_getRenderType = instruction;
            NoCubesClassTransformer.log("Found label " + instruction);
            break;
        }
        if (firstLabelBefore_IBlockState_getRenderType == null) {
            throw new RuntimeException("Error: Couldn't find label!");
        }
        int lookStart = instructions.indexOf(IBlockState_getRenderType);
        int lookMax = lookStart + 10;
        for (int i = lookStart; i < lookMax; ++i) {
            AbstractInsnNode instruction2 = instructions.get(i);
            if (instruction2.getOpcode() != 153 && instruction2.getOpcode() != 154 && instruction2.getOpcode() != 165) continue;
            JumpInsnNode jumpInsn = (JumpInsnNode)instruction2;
            blockCannotRenderLabel = jumpInsn.label;
            NoCubesClassTransformer.log("Found blockCannotRenderLabel " + jumpInsn.label);
            break;
        }
        if (blockCannotRenderLabel == null) {
            throw new RuntimeException("Error: Couldn't find blockCannotRenderLabel!");
        }
        InsnList toInject = new InsnList();
        LabelNode originalInstructionsLabel = new LabelNode();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, optifine ? 18 : 15));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "io/github/cadiboo/nocubes/hooks/Hooks", "canBlockStateRender", "(Lnet/minecraft/block/state/IBlockState;)Z", false));
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, blockCannotRenderLabel));
        toInject.add((AbstractInsnNode)originalInstructionsLabel);
        instructions.insert((AbstractInsnNode)firstLabelBefore_IBlockState_getRenderType, toInject);
    }
}

