/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.tempcore;

import io.github.cadiboo.nocubes.tempcore.IBlockPropertiesTransformer;
import io.github.cadiboo.nocubes.tempcore.NoCubesLoadingPlugin;
import io.github.cadiboo.nocubes.tempcore.RenderChunkTransformer;
import io.github.cadiboo.nocubes.tempcore.RenderGlobalTransformer;
import io.github.cadiboo.nocubes.tempcore.StateImplementationTransformer;
import io.github.cadiboo.nocubes.tempcore.WorldTransformer;
import io.github.cadiboo.nocubes.tempcore.classwriter.MCWriter;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;

public final class NoCubesClassTransformer
implements IClassTransformer,
Opcodes {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String currentlyRunning;
    private static String transformerName;
    private static boolean DUMP_BYTECODE;

    static void start(String name) {
        NoCubesClassTransformer.log("Starting " + name);
        currentlyRunning = name;
    }

    static void finish() {
        String name = currentlyRunning;
        currentlyRunning = null;
        NoCubesClassTransformer.log("Finished " + name);
    }

    static void log(String msg) {
        if (currentlyRunning == null) {
            NoCubesClassTransformer.print("[" + transformerName + "]: " + msg);
        } else {
            NoCubesClassTransformer.print("[" + transformerName + "] [" + currentlyRunning + "]: " + msg);
        }
    }

    private static void print(String s) {
        LOGGER.info(s);
    }

    static String mapMethod(String internalClassName, String srgName, String desc) {
        return ObfuscationHelper.remapMethodName(internalClassName, srgName, desc);
    }

    static String mapField(String internalClassName, String srgName) {
        return ObfuscationHelper.remapFieldName(internalClassName, srgName);
    }

    public byte[] transform(String name, String transformedName, @Nullable byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.block.state.BlockStateContainer$StateImplementation": {
                return NoCubesLoadingPlugin.DEVELOPER_ENVIRONMENT && FMLLaunchHandler.side() != Side.CLIENT ? basicClass : this.transformClass(basicClass, transformedName, StateImplementationTransformer::transform);
            }
            case "net.minecraft.block.state.IBlockProperties": {
                return NoCubesLoadingPlugin.DEVELOPER_ENVIRONMENT && FMLLaunchHandler.side() != Side.CLIENT ? basicClass : this.transformClass(basicClass, transformedName, IBlockPropertiesTransformer::transform);
            }
            case "net.minecraft.client.renderer.chunk.RenderChunk": {
                return this.transformClass(basicClass, transformedName, RenderChunkTransformer::transform);
            }
            case "net.minecraft.world.World": {
                return this.transformClass(basicClass, transformedName, WorldTransformer::transform);
            }
            case "net.minecraft.client.renderer.RenderGlobal": {
                return this.transformClass(basicClass, transformedName, RenderGlobalTransformer::transform);
            }
        }
        return basicClass;
    }

    @SafeVarargs
    private final byte[] transformClass(byte[] basicClass, String transformedName, Consumer<ClassNode> ... classNodeAcceptors) {
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(basicClass);
        LOGGER.info("Starting transforming " + transformedName);
        if (DUMP_BYTECODE) {
            try {
                Path pathToFile = Paths.get(NoCubesLoadingPlugin.DUMP_BYTECODE_DIR + transformedName + "_before_hooks.txt", new String[0]);
                pathToFile.toFile().getParentFile().mkdirs();
                PrintWriter filePrinter = new PrintWriter(pathToFile.toFile());
                ClassReader reader = new ClassReader(basicClass);
                TraceClassVisitor tracingVisitor = new TraceClassVisitor(filePrinter);
                reader.accept((ClassVisitor)tracingVisitor, 0);
                pathToFile = Paths.get(NoCubesLoadingPlugin.DUMP_BYTECODE_DIR + transformedName + "_before_hooks.class", new String[0]);
                pathToFile.toFile().getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(pathToFile.toFile());
                fileOutputStream.write(basicClass);
                fileOutputStream.close();
            }
            catch (Exception e) {
                LogManager.getLogger().error("Failed to dump bytecode of classes before injecting hooks!", (Throwable)e);
            }
        }
        cr.accept((ClassVisitor)classNode, 4);
        for (Consumer<ClassNode> classNodeAcceptor : classNodeAcceptors) {
            transformerName = classNodeAcceptor.getClass().getSimpleName();
            classNodeAcceptor.accept(classNode);
        }
        LOGGER.info("Finished transforming " + transformedName);
        MCWriter out = new MCWriter(3);
        classNode.accept((ClassVisitor)out);
        if (DUMP_BYTECODE) {
            try {
                byte[] bytes = out.toByteArray();
                Path pathToFile = Paths.get(NoCubesLoadingPlugin.DUMP_BYTECODE_DIR + transformedName + "_after_hooks.txt", new String[0]);
                pathToFile.toFile().getParentFile().mkdirs();
                PrintWriter filePrinter = new PrintWriter(pathToFile.toFile());
                ClassReader reader = new ClassReader(bytes);
                TraceClassVisitor tracingVisitor = new TraceClassVisitor(filePrinter);
                reader.accept((ClassVisitor)tracingVisitor, 0);
                Path pathToClass = Paths.get(NoCubesLoadingPlugin.DUMP_BYTECODE_DIR + transformedName + "_after_hooks.class", new String[0]);
                pathToClass.toFile().getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(pathToClass.toFile());
                fileOutputStream.write(bytes);
                fileOutputStream.close();
            }
            catch (Exception e) {
                LogManager.getLogger().error("Failed to dump bytecode of classes after injecting hooks!", (Throwable)e);
            }
        }
        return out.toByteArray();
    }

    static {
        DUMP_BYTECODE = true;
        DUMP_BYTECODE &= NoCubesLoadingPlugin.MOD_LOCATION == null || !NoCubesLoadingPlugin.MOD_LOCATION.isFile() || !NoCubesLoadingPlugin.MOD_LOCATION.getName().endsWith(".jar");
    }

    static class ObfuscationHelper {
        ObfuscationHelper() {
        }

        static String remapMethodName(String internalClassName, String methodName, String desc) {
            String remappedName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, methodName, desc);
            LOGGER.info("Remapped method name " + methodName + " to " + remappedName);
            return remappedName;
        }

        static String remapFieldName(String internalClassName, String fieldName) {
            String remappedName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(internalClassName, fieldName, null);
            LOGGER.info("Remapped field name " + fieldName + " to " + remappedName);
            return remappedName;
        }
    }
}

