/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.config.ConfigTracker;
import io.github.cadiboo.nocubes.util.DistExecutor;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public final class S2CSyncConfig
implements IMessage,
IMessageHandler<S2CSyncConfig, IMessage> {
    private String fileName;
    private byte[] fileData;

    public S2CSyncConfig() {
    }

    public S2CSyncConfig(String fileName, byte[] fileData) {
        if (fileName.length() > 128) {
            throw new IllegalStateException();
        }
        this.fileName = fileName;
        this.fileData = fileData;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.fileName = packetBuffer.func_150789_c(128);
        this.fileData = packetBuffer.func_179251_a();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.func_180714_a(this.fileName);
        packetBuffer.func_179250_a(this.fileData);
    }

    public IMessage onMessage(S2CSyncConfig msg, MessageContext context) {
        DistExecutor.runWhenOn(Side.CLIENT, () -> () -> Minecraft.func_71410_x().func_152344_a(() -> ConfigTracker.INSTANCE.receiveSyncedConfig(msg)));
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getBytes() {
        return this.fileData;
    }
}

