/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.gui.toast.BlockStateToast;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.DistExecutor;
import io.github.cadiboo.nocubes.util.INoCubesBlockState;
import io.github.cadiboo.nocubes.util.StateHolder;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class S2CAddTerrainSmoothable
implements IMessage,
IMessageHandler<S2CAddTerrainSmoothable, IMessage> {
    private int blockStateId;

    public S2CAddTerrainSmoothable(int blockStateId) {
        this.blockStateId = blockStateId;
    }

    public S2CAddTerrainSmoothable() {
    }

    @SideOnly(value=Side.CLIENT)
    private static void handleOnClient(S2CAddTerrainSmoothable msg) {
        int blockStateId = msg.blockStateId;
        IBlockState blockState = Block.func_176220_d((int)blockStateId);
        if (blockState == StateHolder.AIR_DEFAULT) {
            NoCubes.LOGGER.error("Trying to add invalid terrain smoothable blockstate: " + blockStateId);
            return;
        }
        ((INoCubesBlockState)blockState).nocubes_setTerrainSmoothable(true);
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new BlockStateToast.AddTerrain(blockState, BlockPos.field_177992_a));
        if (Config.renderSmoothTerrain) {
            ClientUtil.tryReloadRenderers();
        }
    }

    public IMessage onMessage(S2CAddTerrainSmoothable msg, MessageContext context) {
        Minecraft.func_71410_x().func_152344_a(() -> DistExecutor.runWhenOn(Side.CLIENT, () -> () -> S2CAddTerrainSmoothable.handleOnClient(msg)));
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.blockStateId = new PacketBuffer(buf).readInt();
    }

    public void toBytes(ByteBuf buf) {
        new PacketBuffer(buf).writeInt(this.blockStateId);
    }
}

