/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh.generator;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public final class SurfaceNets
implements MeshGenerator {
    private static final int[] CUBE_EDGES = new int[24];
    private static final int[] EDGE_TABLE = new int[256];

    private static void generateCubeEdgesTable() {
        int cubeEdgesIndex = 0;
        for (int cubeCornerIndex = 0; cubeCornerIndex < 8; cubeCornerIndex = (int)((byte)(cubeCornerIndex + 1))) {
            for (int em = 1; em <= 4; em <<= 1) {
                int j = cubeCornerIndex ^ em;
                if (cubeCornerIndex > j) continue;
                SurfaceNets.CUBE_EDGES[cubeEdgesIndex++] = cubeCornerIndex;
                SurfaceNets.CUBE_EDGES[cubeEdgesIndex++] = j;
            }
        }
    }

    private static void generateIntersectionTable() {
        for (int edgeTableIndex = 0; edgeTableIndex < 256; edgeTableIndex = (int)((short)(edgeTableIndex + 1))) {
            int em = 0;
            for (int cubeEdgesIndex = 0; cubeEdgesIndex < 24; cubeEdgesIndex += 2) {
                boolean a = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex]) != 0;
                boolean b = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex + 1]) != 0;
                em = (short)(em | (a != b ? 1 << (cubeEdgesIndex >> 1) : 0));
            }
            SurfaceNets.EDGE_TABLE[edgeTableIndex] = em;
        }
    }

    @Override
    @Nonnull
    public HashMap<Vec3b, FaceList> generateChunk(@Nonnull float[] data, @Nonnull byte[] dims) {
        ArrayList<float[]> vertices = new ArrayList<float[]>(384);
        int n = 0;
        byte[] x = new byte[]{0, 0, 0};
        int[] R = new int[]{1, dims[0] + 1, (dims[0] + 1) * (dims[1] + 1)};
        float[] grid = new float[8];
        int buf_no = 1;
        int[] buffer = new int[R[2] * 2];
        HashMap<Vec3b, FaceList> posToFaces = new HashMap<Vec3b, FaceList>(384);
        x[2] = 0;
        while (x[2] < dims[2] - 1) {
            int m = 1 + (dims[0] + 1) * (1 + buf_no * (dims[1] + 1));
            x[1] = 0;
            while (x[1] < dims[1] - 1) {
                x[0] = 0;
                while (x[0] < dims[0] - 1) {
                    int mask = 0;
                    int g = 0;
                    int idx = n;
                    int k = 0;
                    while (k < 2) {
                        int j = 0;
                        while (j < 2) {
                            int i = 0;
                            while (i < 2) {
                                float p;
                                grid[g] = p = data[idx];
                                mask |= p < 0.0f ? 1 << g : 0;
                                i = (byte)(i + 1);
                                ++g;
                                ++idx;
                            }
                            ++j;
                            idx += dims[0] - 2;
                        }
                        ++k;
                        idx += dims[0] * (dims[1] - 2);
                    }
                    if (mask != 0 && mask != 255) {
                        int edge_mask = EDGE_TABLE[mask];
                        float[] v = new float[]{0.0f, 0.0f, 0.0f};
                        int e_count = 0;
                        for (int i = 0; i < 12; ++i) {
                            if ((edge_mask & 1 << i) == 0) continue;
                            ++e_count;
                            int e0 = CUBE_EDGES[i << 1];
                            float g0 = grid[e0];
                            int e1 = CUBE_EDGES[(i << 1) + 1];
                            float g1 = grid[e1];
                            float t = g0 - g1;
                            if (!((double)Math.abs(t) > 1.0E-6)) continue;
                            t = g0 / t;
                            int j = 0;
                            int k2 = 1;
                            while (j < 3) {
                                int a = e0 & k2;
                                int b = e1 & k2;
                                if (a != b) {
                                    int n2 = j;
                                    v[n2] = v[n2] + (a != 0 ? 1.0f - t : t);
                                } else {
                                    int n3 = j;
                                    v[n3] = v[n3] + (a != 0 ? 1.0f : 0.0f);
                                }
                                ++j;
                                k2 <<= 1;
                            }
                        }
                        float s = 1.0f / (float)e_count;
                        for (int i = 0; i < 3; ++i) {
                            v[i] = (float)x[i] + s * v[i];
                        }
                        buffer[m] = vertices.size();
                        vertices.add(v);
                        FaceList faces = FaceList.retain();
                        for (int i = 0; i < 3; ++i) {
                            if ((edge_mask & 1 << i) == 0) continue;
                            int iu = (i + 1) % 3;
                            int iv = (i + 2) % 3;
                            if (x[iu] == 0 || x[iv] == 0) continue;
                            int du = R[iu];
                            int dv = R[iv];
                            if ((mask & 1) != 0) {
                                faces.add(Face.retain(Vec3.retain((float[])vertices.get(buffer[m])), Vec3.retain((float[])vertices.get(buffer[m - du])), Vec3.retain((float[])vertices.get(buffer[m - du - dv])), Vec3.retain((float[])vertices.get(buffer[m - dv]))));
                                continue;
                            }
                            faces.add(Face.retain(Vec3.retain((float[])vertices.get(buffer[m])), Vec3.retain((float[])vertices.get(buffer[m - dv])), Vec3.retain((float[])vertices.get(buffer[m - du - dv])), Vec3.retain((float[])vertices.get(buffer[m - du]))));
                        }
                        posToFaces.put(Vec3b.retain(x[0], x[1], x[2]), faces);
                    }
                    x[0] = (byte)(x[0] + 1);
                    ++n;
                    ++m;
                }
                x[1] = (byte)(x[1] + 1);
                ++n;
                m += 2;
            }
            x[2] = (byte)(x[2] + 1);
            n += dims[0];
            buf_no ^= 1;
            R[2] = -R[2];
        }
        return posToFaces;
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull float[] data, @Nonnull byte[] dims) {
        int[] edge_table = EDGE_TABLE;
        int[] cube_edges = CUBE_EDGES;
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        int n = 0;
        byte[] x = new byte[]{0, 0, 0};
        int[] R = new int[]{1, dims[0] + 1, (dims[0] + 1) * (dims[1] + 1)};
        float[] grid = new float[8];
        int buf_no = 1;
        int[] buffer = new int[R[2] * 2];
        FaceList faces = FaceList.retain();
        x[2] = 0;
        while (x[2] < dims[2] - 1) {
            int m = 1 + (dims[0] + 1) * (1 + buf_no * (dims[1] + 1));
            x[1] = 0;
            while (x[1] < dims[1] - 1) {
                x[0] = 0;
                while (x[0] < dims[0] - 1) {
                    int mask = 0;
                    int g = 0;
                    int idx = n;
                    int k = 0;
                    while (k < 2) {
                        int j = 0;
                        while (j < 2) {
                            int i = 0;
                            while (i < 2) {
                                float p;
                                grid[g] = p = data[idx];
                                mask |= p < 0.0f ? 1 << g : 0;
                                i = (byte)(i + 1);
                                ++g;
                                ++idx;
                            }
                            ++j;
                            idx += dims[0] - 2;
                        }
                        ++k;
                        idx += dims[0] * (dims[1] - 2);
                    }
                    if (mask != 0 && mask != 255) {
                        int i;
                        int edge_mask = edge_table[mask];
                        float[] v = new float[]{0.0f, 0.0f, 0.0f};
                        int e_count = 0;
                        for (int i2 = 0; i2 < 12; ++i2) {
                            if ((edge_mask & 1 << i2) == 0) continue;
                            ++e_count;
                            int e0 = cube_edges[i2 << 1];
                            float g0 = grid[e0];
                            int e1 = cube_edges[(i2 << 1) + 1];
                            float g1 = grid[e1];
                            float t = g0 - g1;
                            if (!((double)Math.abs(t) > 1.0E-6)) continue;
                            t = g0 / t;
                            int j = 0;
                            int k2 = 1;
                            while (j < 3) {
                                int a = e0 & k2;
                                int b = e1 & k2;
                                if (a != b) {
                                    int n2 = j;
                                    v[n2] = v[n2] + (a != 0 ? 1.0f - t : t);
                                } else {
                                    int n3 = j;
                                    v[n3] = v[n3] + (a != 0 ? 1.0f : 0.0f);
                                }
                                ++j;
                                k2 <<= 1;
                            }
                        }
                        float s = 1.0f / (float)e_count;
                        for (i = 0; i < 3; ++i) {
                            v[i] = (float)x[i] + s * v[i];
                        }
                        buffer[m] = vertices.size();
                        vertices.add(v);
                        for (i = 0; i < 3; ++i) {
                            if ((edge_mask & 1 << i) == 0) continue;
                            int iu = (i + 1) % 3;
                            int iv = (i + 2) % 3;
                            if (x[iu] == 0 || x[iv] == 0) continue;
                            int du = R[iu];
                            int dv = R[iv];
                            if ((mask & 1) != 0) {
                                faces.add(Face.retain(Vec3.retain((float[])vertices.get(buffer[m])), Vec3.retain((float[])vertices.get(buffer[m - du])), Vec3.retain((float[])vertices.get(buffer[m - du - dv])), Vec3.retain((float[])vertices.get(buffer[m - dv]))));
                                continue;
                            }
                            faces.add(Face.retain(Vec3.retain((float[])vertices.get(buffer[m])), Vec3.retain((float[])vertices.get(buffer[m - dv])), Vec3.retain((float[])vertices.get(buffer[m - du - dv])), Vec3.retain((float[])vertices.get(buffer[m - du]))));
                        }
                    }
                    x[0] = (byte)(x[0] + 1);
                    ++n;
                    ++m;
                }
                x[1] = (byte)(x[1] + 1);
                ++n;
                m += 2;
            }
            x[2] = (byte)(x[2] + 1);
            n += dims[0];
            buf_no ^= 1;
            R[2] = -R[2];
        }
        return faces;
    }

    @Override
    public byte getSizeXExtension() {
        return 1;
    }

    @Override
    public byte getSizeYExtension() {
        return 1;
    }

    @Override
    public byte getSizeZExtension() {
        return 1;
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull BlockPos pos, @Nonnull IBlockAccess blockAccess, @Nonnull IsSmoothable isSmoothable) {
        return FaceList.retain();
    }

    static {
        SurfaceNets.generateCubeEdgesTable();
        SurfaceNets.generateIntersectionTable();
    }
}

