/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh.generator;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public final class OldNoCubes
implements MeshGenerator {
    public static final int X0Y0Z0 = 0;
    public static final int X1Y0Z0 = 1;
    public static final int X1Y0Z1 = 2;
    public static final int X0Y0Z1 = 3;
    public static final int X0Y1Z0 = 4;
    public static final int X1Y1Z0 = 5;
    public static final int X1Y1Z1 = 6;
    public static final int X0Y1Z1 = 7;

    @Nonnull
    public static HashMap<Vec3b, FaceList> generateChunk(@Nonnull BlockPos chunkPos, @Nonnull IBlockAccess reader, @Nonnull IsSmoothable isSmoothable, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        HashMap<Vec3b, FaceList> map = new HashMap<Vec3b, FaceList>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chunkPos, (BlockPos)chunkPos.func_177982_a(15, 15, 15))) {
            FaceList faces = OldNoCubes.generateBlock(pos, reader, isSmoothable, pooledMutableBlockPos);
            map.put(Vec3b.retain((byte)(pos.func_177958_n() & 0xF), (byte)(pos.func_177956_o() & 0xF), (byte)(pos.func_177952_p() & 0xF)), faces);
        }
        return map;
    }

    @Nonnull
    public static FaceList generateBlock(@Nonnull BlockPos pos, @Nonnull IBlockAccess reader, @Nonnull IsSmoothable isSmoothable, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        int relativePosX = posX & 0xF;
        int relativePosY = posY & 0xF;
        int relativePosZ = posZ & 0xF;
        IBlockState state = reader.func_180495_p(pos);
        Vec3[] points = OldNoCubes.getPoints(posX, posY, posZ, relativePosX, relativePosY, relativePosZ, state, reader, isSmoothable, pooledMutableBlockPos);
        FaceList faces = FaceList.retain();
        if (points != null) {
            int i;
            for (i = 0; i < ModUtil.DIRECTION_VALUES_LENGTH; ++i) {
                Vec3 vertex3;
                Vec3 vertex2;
                Vec3 vertex1;
                Vec3 vertex0;
                EnumFacing direction = ModUtil.DIRECTION_VALUES[i];
                if (isSmoothable.test(reader.func_180495_p((BlockPos)pooledMutableBlockPos.func_189533_g((Vec3i)pos).func_189536_c(direction)))) continue;
                switch (direction) {
                    default: {
                        vertex0 = points[3];
                        vertex1 = points[0];
                        vertex2 = points[1];
                        vertex3 = points[2];
                        break;
                    }
                    case UP: {
                        vertex0 = points[4];
                        vertex1 = points[7];
                        vertex2 = points[6];
                        vertex3 = points[5];
                        break;
                    }
                    case NORTH: {
                        vertex0 = points[5];
                        vertex1 = points[1];
                        vertex2 = points[0];
                        vertex3 = points[4];
                        break;
                    }
                    case SOUTH: {
                        vertex0 = points[7];
                        vertex1 = points[3];
                        vertex2 = points[2];
                        vertex3 = points[6];
                        break;
                    }
                    case WEST: {
                        vertex0 = points[4];
                        vertex1 = points[0];
                        vertex2 = points[3];
                        vertex3 = points[7];
                        break;
                    }
                    case EAST: {
                        vertex0 = points[6];
                        vertex1 = points[2];
                        vertex2 = points[1];
                        vertex3 = points[5];
                    }
                }
                faces.add(Face.retain(Vec3.retain(vertex0.x, vertex0.y, vertex0.z), Vec3.retain(vertex1.x, vertex1.y, vertex1.z), Vec3.retain(vertex2.x, vertex2.y, vertex2.z), Vec3.retain(vertex3.x, vertex3.y, vertex3.z)));
            }
            int pointsLength = points.length;
            for (i = 0; i < pointsLength; ++i) {
                points[i].close();
            }
        }
        return faces;
    }

    @Nullable
    public static Vec3[] getPoints(int posX, int posY, int posZ, int relativePosX, int relativePosY, int relativePosZ, @Nonnull IBlockState state, @Nonnull IBlockAccess reader, @Nonnull IsSmoothable isSmoothable, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        if (!isSmoothable.test(state)) {
            return null;
        }
        Vec3[] points = new Vec3[]{Vec3.retain(0.0, 0.0, 0.0), Vec3.retain(1.0, 0.0, 0.0), Vec3.retain(1.0, 0.0, 1.0), Vec3.retain(0.0, 0.0, 1.0), Vec3.retain(0.0, 1.0, 0.0), Vec3.retain(1.0, 1.0, 0.0), Vec3.retain(1.0, 1.0, 1.0), Vec3.retain(0.0, 1.0, 1.0)};
        for (int pointIndex = 0; pointIndex < 8; ++pointIndex) {
            Vec3 point = points[pointIndex];
            point.x += (double)posX;
            point.y += (double)posY;
            point.z += (double)posZ;
            if (OldNoCubes.doesPointIntersectWithManufactured(reader, point, isSmoothable, pooledMutableBlockPos)) continue;
            if (pointIndex < 4 && OldNoCubes.doesPointBottomIntersectWithAir(reader, point, pooledMutableBlockPos)) {
                point.y = (float)posY + 1.0f - 1.0E-4f;
                continue;
            }
            if (pointIndex < 4 || !OldNoCubes.doesPointTopIntersectWithAir(reader, point, pooledMutableBlockPos)) continue;
            point.y = (float)posY + 0.0f + 1.0E-4f;
        }
        return points;
    }

    @Nonnull
    public static Vec3 givePointRoughness(@Nonnull Vec3 point) {
        long i = (long)(point.x * 3129871.0) ^ (long)point.y * 116129781L ^ (long)point.z;
        i = i * i * 42317861L + i * 11L;
        point.x += (double)(((float)(i >> 16 & 0xFL) / 15.0f - 0.5f) * 0.5f);
        point.y += (double)(((float)(i >> 20 & 0xFL) / 15.0f - 0.5f) * 0.5f);
        point.z += (double)(((float)(i >> 24 & 0xFL) / 15.0f - 0.5f) * 0.5f);
        return point;
    }

    public static boolean isBlockAirOrPlant(@Nonnull IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151585_k || material == Material.field_151582_l;
    }

    public static boolean doesPointTopIntersectWithAir(@Nonnull IBlockAccess world, @Nonnull Vec3 point, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        boolean intersects = false;
        for (int i = 0; i < 4; ++i) {
            int x1 = (int)(point.x - (double)(i & 1));
            int z1 = (int)(point.z - (double)(i >> 1 & 1));
            if (!OldNoCubes.isBlockAirOrPlant(world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y, z1)))) {
                return false;
            }
            if (!OldNoCubes.isBlockAirOrPlant(world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y - 1, z1)))) continue;
            intersects = true;
        }
        return intersects;
    }

    public static boolean doesPointBottomIntersectWithAir(@Nonnull IBlockAccess world, @Nonnull Vec3 point, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        boolean intersects = false;
        boolean notOnly = false;
        for (int i = 0; i < 4; ++i) {
            int x1 = (int)(point.x - (double)(i & 1));
            int z1 = (int)(point.z - (double)(i >> 1 & 1));
            if (!OldNoCubes.isBlockAirOrPlant(world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y - 1, z1)))) {
                return false;
            }
            if (!OldNoCubes.isBlockAirOrPlant(world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y + 1, z1)))) {
                notOnly = true;
            }
            if (!OldNoCubes.isBlockAirOrPlant(world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y, z1)))) continue;
            intersects = true;
        }
        return intersects && notOnly;
    }

    public static boolean doesPointIntersectWithManufactured(@Nonnull IBlockAccess world, @Nonnull Vec3 point, @Nonnull IsSmoothable isSmoothable, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        for (int i = 0; i < 4; ++i) {
            int x1 = (int)(point.x - (double)(i & 1));
            int z1 = (int)(point.z - (double)(i >> 1 & 1));
            IBlockState state0 = world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y, z1));
            if (!OldNoCubes.isBlockAirOrPlant(state0) && !isSmoothable.test(state0)) {
                return true;
            }
            IBlockState state1 = world.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x1, (int)point.y - 1, z1));
            if (OldNoCubes.isBlockAirOrPlant(state1) || isSmoothable.test(state1)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public HashMap<Vec3b, FaceList> generateChunk(@Nonnull float[] scalarFieldData, @Nonnull byte[] dimensions) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull float[] scalarFieldData, @Nonnull byte[] dimensions) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull BlockPos pos, @Nonnull IBlockAccess reader, @Nonnull IsSmoothable isSmoothable) {
        throw new UnsupportedOperationException();
    }
}

