/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh.generator;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public final class MarchingCubes
implements MeshGenerator {
    private static final short[] EDGE_TABLE = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};
    private static final byte[][] TRI_TABLE = new byte[][]{new byte[0], {0, 8, 3}, {0, 1, 9}, {1, 8, 3, 9, 8, 1}, {1, 2, 10}, {0, 8, 3, 1, 2, 10}, {9, 2, 10, 0, 2, 9}, {2, 8, 3, 2, 10, 8, 10, 9, 8}, {3, 11, 2}, {0, 11, 2, 8, 11, 0}, {1, 9, 0, 2, 3, 11}, {1, 11, 2, 1, 9, 11, 9, 8, 11}, {3, 10, 1, 11, 10, 3}, {0, 10, 1, 0, 8, 10, 8, 11, 10}, {3, 9, 0, 3, 11, 9, 11, 10, 9}, {9, 8, 10, 10, 8, 11}, {4, 7, 8}, {4, 3, 0, 7, 3, 4}, {0, 1, 9, 8, 4, 7}, {4, 1, 9, 4, 7, 1, 7, 3, 1}, {1, 2, 10, 8, 4, 7}, {3, 4, 7, 3, 0, 4, 1, 2, 10}, {9, 2, 10, 9, 0, 2, 8, 4, 7}, {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4}, {8, 4, 7, 3, 11, 2}, {11, 4, 7, 11, 2, 4, 2, 0, 4}, {9, 0, 1, 8, 4, 7, 2, 3, 11}, {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1}, {3, 10, 1, 3, 11, 10, 7, 8, 4}, {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4}, {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3}, {4, 7, 11, 4, 11, 9, 9, 11, 10}, {9, 5, 4}, {9, 5, 4, 0, 8, 3}, {0, 5, 4, 1, 5, 0}, {8, 5, 4, 8, 3, 5, 3, 1, 5}, {1, 2, 10, 9, 5, 4}, {3, 0, 8, 1, 2, 10, 4, 9, 5}, {5, 2, 10, 5, 4, 2, 4, 0, 2}, {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8}, {9, 5, 4, 2, 3, 11}, {0, 11, 2, 0, 8, 11, 4, 9, 5}, {0, 5, 4, 0, 1, 5, 2, 3, 11}, {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5}, {10, 3, 11, 10, 1, 3, 9, 5, 4}, {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10}, {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3}, {5, 4, 8, 5, 8, 10, 10, 8, 11}, {9, 7, 8, 5, 7, 9}, {9, 3, 0, 9, 5, 3, 5, 7, 3}, {0, 7, 8, 0, 1, 7, 1, 5, 7}, {1, 5, 3, 3, 5, 7}, {9, 7, 8, 9, 5, 7, 10, 1, 2}, {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3}, {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2}, {2, 10, 5, 2, 5, 3, 3, 5, 7}, {7, 9, 5, 7, 8, 9, 3, 11, 2}, {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11}, {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7}, {11, 2, 1, 11, 1, 7, 7, 1, 5}, {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11}, {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0}, {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0}, {11, 10, 5, 7, 11, 5}, {10, 6, 5}, {0, 8, 3, 5, 10, 6}, {9, 0, 1, 5, 10, 6}, {1, 8, 3, 1, 9, 8, 5, 10, 6}, {1, 6, 5, 2, 6, 1}, {1, 6, 5, 1, 2, 6, 3, 0, 8}, {9, 6, 5, 9, 0, 6, 0, 2, 6}, {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8}, {2, 3, 11, 10, 6, 5}, {11, 0, 8, 11, 2, 0, 10, 6, 5}, {0, 1, 9, 2, 3, 11, 5, 10, 6}, {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11}, {6, 3, 11, 6, 5, 3, 5, 1, 3}, {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6}, {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9}, {6, 5, 9, 6, 9, 11, 11, 9, 8}, {5, 10, 6, 4, 7, 8}, {4, 3, 0, 4, 7, 3, 6, 5, 10}, {1, 9, 0, 5, 10, 6, 8, 4, 7}, {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4}, {6, 1, 2, 6, 5, 1, 4, 7, 8}, {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7}, {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6}, {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9}, {3, 11, 2, 7, 8, 4, 10, 6, 5}, {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11}, {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6}, {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6}, {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6}, {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11}, {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7}, {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9}, {10, 4, 9, 6, 4, 10}, {4, 10, 6, 4, 9, 10, 0, 8, 3}, {10, 0, 1, 10, 6, 0, 6, 4, 0}, {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10}, {1, 4, 9, 1, 2, 4, 2, 6, 4}, {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4}, {0, 2, 4, 4, 2, 6}, {8, 3, 2, 8, 2, 4, 4, 2, 6}, {10, 4, 9, 10, 6, 4, 11, 2, 3}, {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6}, {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10}, {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1}, {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3}, {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1}, {3, 11, 6, 3, 6, 0, 0, 6, 4}, {6, 4, 8, 11, 6, 8}, {7, 10, 6, 7, 8, 10, 8, 9, 10}, {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10}, {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0}, {10, 6, 7, 10, 7, 1, 1, 7, 3}, {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7}, {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9}, {7, 8, 0, 7, 0, 6, 6, 0, 2}, {7, 3, 2, 6, 7, 2}, {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7}, {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7}, {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11}, {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1}, {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6}, {0, 9, 1, 11, 6, 7}, {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0}, {7, 11, 6}, {7, 6, 11}, {3, 0, 8, 11, 7, 6}, {0, 1, 9, 11, 7, 6}, {8, 1, 9, 8, 3, 1, 11, 7, 6}, {10, 1, 2, 6, 11, 7}, {1, 2, 10, 3, 0, 8, 6, 11, 7}, {2, 9, 0, 2, 10, 9, 6, 11, 7}, {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8}, {7, 2, 3, 6, 2, 7}, {7, 0, 8, 7, 6, 0, 6, 2, 0}, {2, 7, 6, 2, 3, 7, 0, 1, 9}, {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6}, {10, 7, 6, 10, 1, 7, 1, 3, 7}, {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8}, {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7}, {7, 6, 10, 7, 10, 8, 8, 10, 9}, {6, 8, 4, 11, 8, 6}, {3, 6, 11, 3, 0, 6, 0, 4, 6}, {8, 6, 11, 8, 4, 6, 9, 0, 1}, {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6}, {6, 8, 4, 6, 11, 8, 2, 10, 1}, {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6}, {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9}, {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3}, {8, 2, 3, 8, 4, 2, 4, 6, 2}, {0, 4, 2, 4, 6, 2}, {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8}, {1, 9, 4, 1, 4, 2, 2, 4, 6}, {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1}, {10, 1, 0, 10, 0, 6, 6, 0, 4}, {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3}, {10, 9, 4, 6, 10, 4}, {4, 9, 5, 7, 6, 11}, {0, 8, 3, 4, 9, 5, 11, 7, 6}, {5, 0, 1, 5, 4, 0, 7, 6, 11}, {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5}, {9, 5, 4, 10, 1, 2, 7, 6, 11}, {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5}, {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2}, {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6}, {7, 2, 3, 7, 6, 2, 5, 4, 9}, {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7}, {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0}, {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8}, {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7}, {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4}, {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10}, {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10}, {6, 9, 5, 6, 11, 9, 11, 8, 9}, {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5}, {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11}, {6, 11, 3, 6, 3, 5, 5, 3, 1}, {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6}, {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10}, {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5}, {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3}, {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2}, {9, 5, 6, 9, 6, 0, 0, 6, 2}, {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8}, {1, 5, 6, 2, 1, 6}, {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6}, {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0}, {0, 3, 8, 5, 6, 10}, {10, 5, 6}, {11, 5, 10, 7, 5, 11}, {11, 5, 10, 11, 7, 5, 8, 3, 0}, {5, 11, 7, 5, 10, 11, 1, 9, 0}, {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1}, {11, 1, 2, 11, 7, 1, 7, 5, 1}, {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11}, {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7}, {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2}, {2, 5, 10, 2, 3, 5, 3, 7, 5}, {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5}, {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2}, {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2}, {1, 3, 5, 3, 7, 5}, {0, 8, 7, 0, 7, 1, 1, 7, 5}, {9, 0, 3, 9, 3, 5, 5, 3, 7}, {9, 8, 7, 5, 9, 7}, {5, 8, 4, 5, 10, 8, 10, 11, 8}, {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0}, {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5}, {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4}, {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8}, {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11}, {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5}, {9, 4, 5, 2, 11, 3}, {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4}, {5, 10, 2, 5, 2, 4, 4, 2, 0}, {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9}, {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2}, {8, 4, 5, 8, 5, 3, 3, 5, 1}, {0, 4, 5, 1, 0, 5}, {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5}, {9, 4, 5}, {4, 11, 7, 4, 9, 11, 9, 10, 11}, {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11}, {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11}, {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4}, {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2}, {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3}, {11, 7, 4, 11, 4, 2, 2, 4, 0}, {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4}, {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9}, {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7}, {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10}, {1, 10, 2, 8, 7, 4}, {4, 9, 1, 4, 1, 7, 7, 1, 3}, {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1}, {4, 0, 3, 7, 4, 3}, {4, 8, 7}, {9, 10, 8, 10, 11, 8}, {3, 0, 9, 3, 9, 11, 11, 9, 10}, {0, 1, 10, 0, 10, 8, 8, 10, 11}, {3, 1, 10, 11, 3, 10}, {1, 2, 11, 1, 11, 9, 9, 11, 8}, {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9}, {0, 2, 11, 8, 0, 11}, {3, 2, 11}, {2, 3, 8, 2, 8, 10, 10, 8, 9}, {9, 10, 2, 0, 9, 2}, {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8}, {1, 10, 2}, {1, 3, 8, 9, 1, 8}, {0, 9, 1}, {0, 3, 8}, new byte[0]};
    private static final byte[][] CUBE_VERTS = new byte[][]{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}, {0, 0, 1}, {1, 0, 1}, {1, 1, 1}, {0, 1, 1}};
    private static final byte[][] EDGE_INDEX = new byte[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};

    @Override
    @Nonnull
    public HashMap<Vec3b, FaceList> generateChunk(@Nonnull float[] data, @Nonnull byte[] dims) {
        byte[][] cubeVerts = CUBE_VERTS;
        short[] edgeTable = EDGE_TABLE;
        byte[][] edgeIndex = EDGE_INDEX;
        byte[][] triTable = TRI_TABLE;
        byte[] x = new byte[]{0, 0, 0};
        short n = 0;
        float[] grid = new float[8];
        int[] edges = new int[12];
        HashMap<Vec3b, FaceList> posToFaces = new HashMap<Vec3b, FaceList>();
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        x[2] = 0;
        while (x[2] < dims[2] - 1) {
            x[1] = 0;
            while (x[1] < dims[1] - 1) {
                x[0] = 0;
                while (x[0] < dims[0] - 1) {
                    int cube_index = 0;
                    for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                        float s;
                        byte[] v = cubeVerts[i];
                        grid[i] = s = data[n + v[0] + dims[0] * (v[1] + dims[1] * v[2])];
                        cube_index = (short)(cube_index | (s > 0.0f ? 1 << i : 0));
                    }
                    short edge_mask = edgeTable[cube_index];
                    if (edge_mask != 0) {
                        for (int i = 0; i < 12; i = (int)((byte)(i + 1))) {
                            if ((edge_mask & 1 << i) == 0) continue;
                            edges[i] = vertices.size();
                            float[] nv = new float[]{0.0f, 0.0f, 0.0f};
                            byte[] e = edgeIndex[i];
                            byte[] p0 = cubeVerts[e[0]];
                            byte[] p1 = cubeVerts[e[1]];
                            float a = grid[e[0]];
                            float b = grid[e[1]];
                            float d = a - b;
                            float t = 0.0f;
                            if ((double)Math.abs(d) > 1.0E-6) {
                                t = a / d;
                            }
                            for (int j = 0; j < 3; j = (int)((byte)(j + 1))) {
                                nv[j] = (float)(x[j] + p0[j]) + t * (float)(p1[j] - p0[j]);
                            }
                            vertices.add(nv);
                        }
                        FaceList faces = FaceList.retain();
                        byte[] f = triTable[cube_index];
                        for (int i = 0; i < f.length; i = (int)((byte)(i + 3))) {
                            faces.add(Face.retain(Vec3.retain((float[])vertices.get(edges[f[i]])), Vec3.retain((float[])vertices.get(edges[f[i + 1]])), Vec3.retain((float[])vertices.get(edges[f[i + 2]]))));
                        }
                        posToFaces.put(Vec3b.retain(x[0], x[1], x[2]), faces);
                    }
                    x[0] = (byte)(x[0] + 1);
                    n = (short)(n + 1);
                }
                x[1] = (byte)(x[1] + 1);
                n = (short)(n + 1);
            }
            x[2] = (byte)(x[2] + 1);
            n = (short)(n + dims[0]);
        }
        return posToFaces;
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull float[] data, @Nonnull byte[] dims) {
        byte[][] cubeVerts = CUBE_VERTS;
        short[] edgeTable = EDGE_TABLE;
        byte[][] edgeIndex = EDGE_INDEX;
        byte[][] triTable = TRI_TABLE;
        byte[] x = new byte[]{0, 0, 0};
        short n = 0;
        float[] grid = new float[8];
        int[] edges = new int[12];
        FaceList faces = FaceList.retain();
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        x[2] = 0;
        while (x[2] < dims[2] - 1) {
            x[1] = 0;
            while (x[1] < dims[1] - 1) {
                x[0] = 0;
                while (x[0] < dims[0] - 1) {
                    int cube_index = 0;
                    for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                        float s;
                        byte[] v = cubeVerts[i];
                        grid[i] = s = data[n + v[0] + dims[0] * (v[1] + dims[1] * v[2])];
                        cube_index = (short)(cube_index | (s > 0.0f ? 1 << i : 0));
                    }
                    short edge_mask = edgeTable[cube_index];
                    if (edge_mask != 0) {
                        for (int i = 0; i < 12; i = (int)((byte)(i + 1))) {
                            if ((edge_mask & 1 << i) == 0) continue;
                            edges[i] = vertices.size();
                            float[] nv = new float[]{0.0f, 0.0f, 0.0f};
                            byte[] e = edgeIndex[i];
                            byte[] p0 = cubeVerts[e[0]];
                            byte[] p1 = cubeVerts[e[1]];
                            float a = grid[e[0]];
                            float b = grid[e[1]];
                            float d = a - b;
                            float t = 0.0f;
                            if ((double)Math.abs(d) > 1.0E-6) {
                                t = a / d;
                            }
                            for (int j = 0; j < 3; j = (int)((byte)(j + 1))) {
                                nv[j] = (float)(x[j] + p0[j]) + t * (float)(p1[j] - p0[j]);
                            }
                            vertices.add(nv);
                        }
                        byte[] f = triTable[cube_index];
                        for (int i = 0; i < f.length; i = (int)((byte)(i + 3))) {
                            faces.add(Face.retain(Vec3.retain((float[])vertices.get(edges[f[i]])), Vec3.retain((float[])vertices.get(edges[f[i + 1]])), Vec3.retain((float[])vertices.get(edges[f[i + 2]]))));
                        }
                    }
                    x[0] = (byte)(x[0] + 1);
                    n = (short)(n + 1);
                }
                x[1] = (byte)(x[1] + 1);
                n = (short)(n + 1);
            }
            x[2] = (byte)(x[2] + 1);
            n = (short)(n + dims[0]);
        }
        return faces;
    }

    @Override
    @Nonnull
    public FaceList generateBlock(@Nonnull BlockPos pos, @Nonnull IBlockAccess blockAccess, @Nonnull IsSmoothable isSmoothable) {
        return FaceList.retain();
    }
}

