/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public interface MeshGenerator {
    @Nonnull
    public HashMap<Vec3b, FaceList> generateChunk(@Nonnull float[] var1, @Nonnull byte[] var2);

    @Nonnull
    public FaceList generateBlock(@Nonnull float[] var1, @Nonnull byte[] var2);

    default public byte getSizeXExtension() {
        return 0;
    }

    default public byte getSizeYExtension() {
        return 0;
    }

    default public byte getSizeZExtension() {
        return 0;
    }

    @Nonnull
    public FaceList generateBlock(@Nonnull BlockPos var1, @Nonnull IBlockAccess var2, @Nonnull IsSmoothable var3);

    @Nonnull
    default public float[] generateScalarFieldData(int startX, int startY, int startZ, int endX, int endY, int endZ, @Nonnull IBlockAccess blockAccess, @Nonnull IsSmoothable isSmoothable, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int maxX = endX - startX;
        int maxY = endY - startY;
        int maxZ = endZ - startZ;
        float[] scalarFieldData = new float[maxX * maxY * maxZ];
        int index = 0;
        for (int z = 0; z < maxZ; ++z) {
            for (int y = 0; y < maxY; ++y) {
                int x = 0;
                while (x < maxX) {
                    float density = 0.0f;
                    for (int zOffset = 0; zOffset < 2; ++zOffset) {
                        for (int yOffset = 0; yOffset < 2; ++yOffset) {
                            for (int xOffset = 0; xOffset < 2; ++xOffset) {
                                pooledMutableBlockPos.func_181079_c(startX + x - xOffset, startY + y - yOffset, startZ + z - zOffset);
                                IBlockState state = blockAccess.func_180495_p((BlockPos)pooledMutableBlockPos);
                                density += ModUtil.getIndividualBlockDensity(isSmoothable.test(state), state);
                            }
                        }
                    }
                    scalarFieldData[index] = density;
                    ++x;
                    ++index;
                }
            }
        }
        return scalarFieldData;
    }
}

