/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.hooks;

import io.github.cadiboo.nocubes.client.render.RenderDispatcher;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Hooks {
    @SideOnly(value=Side.CLIENT)
    public static void preIteration(RenderChunk renderChunk, float x, float y, float z, ChunkCompileTaskGenerator generator, CompiledChunk compiledchunk, BlockPos blockpos, BlockPos blockpos1, World world, IBlockAccess lvt_10_1_, VisGraph lvt_11_1_, HashSet lvt_12_1_, boolean[] aboolean, BlockRendererDispatcher blockrendererdispatcher) {
        RenderDispatcher.renderChunk(renderChunk, blockpos, generator, compiledchunk, world, lvt_10_1_, aboolean, new Random(), blockrendererdispatcher);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderBlockDamage(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, BlockPos blockpos, IBlockState iblockstate, WorldClient world, TextureAtlasSprite textureatlassprite, BlockRendererDispatcher blockrendererdispatcher) {
        if (!(Config.renderSmoothTerrain && IsSmoothable.TERRAIN_SMOOTHABLE.test(iblockstate) || Config.renderSmoothLeaves && IsSmoothable.LEAVES_SMOOTHABLE.test(iblockstate))) {
            return true;
        }
        RenderDispatcher.renderSmoothBlockDamage(tessellatorIn, bufferBuilderIn, blockpos, iblockstate, (IBlockAccess)world, textureatlassprite);
        return false;
    }

    public static boolean getCollisionBoxes(World _this, Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, List<AxisAlignedBB> outList, int i, int j, int k, int l, int i1, int j1, WorldBorder worldborder, boolean flag, boolean flag1) {
        return CollisionHandler.getCollisionBoxes(_this, entityIn, aabb, p_191504_3_, outList, i, j, k, l, i1, j1, worldborder, flag, flag1);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean canBlockStateRender(IBlockState blockstate) {
        if (IsSmoothable.TERRAIN_SMOOTHABLE.test(blockstate) && Config.renderSmoothTerrain) {
            return false;
        }
        if (IsSmoothable.LEAVES_SMOOTHABLE.test(blockstate)) {
            if (Config.renderSmoothLeaves) {
                return Config.renderSmoothAndVanillaLeaves;
            }
            return true;
        }
        return true;
    }
}

