/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.config.ForgeConfigSpec;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.util.ExtendFluidsRange;
import java.util.List;
import javax.annotation.Nonnull;

final class ServerConfig {
    @Nonnull
    final ForgeConfigSpec.ConfigValue<List<? extends String>> terrainSmoothable;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<ExtendFluidsRange> extendFluidsRange;
    @Nonnull
    final ForgeConfigSpec.ConfigValue<MeshGeneratorType> terrainMeshGenerator;
    @Nonnull
    final ForgeConfigSpec.BooleanValue terrainCollisions;
    @Nonnull
    final ForgeConfigSpec.BooleanValue forceVisuals;

    ServerConfig(@Nonnull ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.terrainSmoothable = builder.comment("The list of terrain smoothable blockstates").translation("nocubes.config.terrainSmoothable").defineList("terrainSmoothable", ConfigHelper.getDefaultTerrainSmoothable(), o -> o instanceof String);
        this.extendFluidsRange = builder.comment("The range at which to extend fluids into smoothable blocks").translation("nocubes.config.extendFluidsRange").defineEnum("extendFluidsRange", ExtendFluidsRange.OneBlock);
        this.terrainMeshGenerator = builder.comment("The mesh generator that generates the terrain").translation("nocubes.config.terrainMeshGenerator").defineEnum("terrainMeshGenerator", MeshGeneratorType.SurfaceNets);
        this.terrainCollisions = builder.comment("If realistic terrain collisions should be calculated").translation("nocubes.config.terrainCollisions").define("terrainCollisions", true);
        this.forceVisuals = builder.translation("nocubes.config.forceVisuals").comment("For MMO servers that require NoCubes to be enabled for a proper player experience.", "If you enable this make sure that you've manually checked that every chunk is navigable!").define("forceVisuals", false);
        builder.pop();
    }
}

