/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.ConfigFileTypeHandler;
import io.github.cadiboo.nocubes.config.ConfigTracker;
import io.github.cadiboo.nocubes.config.ForgeConfigSpec;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.StringUtils;

public final class ModConfig {
    private final Type type;
    private final ForgeConfigSpec spec;
    private final String fileName;
    private final ModContainer container;
    private final ConfigFileTypeHandler configHandler;
    private CommentedConfig configData;
    private Callable<Void> saveHandler;

    public ModConfig(Type type, ForgeConfigSpec spec, ModContainer container, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.container = container;
        this.configHandler = ConfigFileTypeHandler.TOML;
        ConfigTracker.INSTANCE.trackConfig(this);
    }

    public ModConfig(Type type, ForgeConfigSpec spec, ModContainer activeContainer) {
        this(type, spec, activeContainer, ModConfig.defaultConfigName(type, activeContainer.getModId()));
    }

    private static String defaultConfigName(Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConfigFileTypeHandler getHandler() {
        return this.configHandler;
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.container.getModId();
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.setConfig(this.configData);
    }

    void fireEvent(ModConfigEvent configEvent) {
        NoCubes.INSTANCE.dispatchConfigEvent(configEvent);
    }

    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }

    public static class ConfigReloading
    extends ModConfigEvent {
        ConfigReloading(ModConfig config) {
            super(config);
        }
    }

    public static class Loading
    extends ModConfigEvent {
        Loading(ModConfig config) {
            super(config);
        }
    }

    public static class ModConfigEvent
    extends Event {
        private final ModConfig config;

        ModConfigEvent(ModConfig config) {
            this.config = config;
        }

        public ModConfig getConfig() {
            return this.config;
        }
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER;


        public String extension() {
            return StringUtils.lowerCase((String)this.name());
        }
    }
}

