/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import io.github.cadiboo.nocubes.config.ModConfig;
import io.github.cadiboo.nocubes.network.S2CSyncConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigTracker {
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConcurrentHashMap<String, ModConfig> fileMap = new ConcurrentHashMap();
    private final EnumMap<ModConfig.Type, Set<ModConfig>> configSets = new EnumMap(ModConfig.Type.class);

    private ConfigTracker() {
        this.configSets.put(ModConfig.Type.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }

    void trackConfig(ModConfig config) {
        if (this.fileMap.containsKey(config.getFileName())) {
            LOGGER.error("Detected config file conflict {} between {} and {}", (Object)config.getFileName(), (Object)this.fileMap.get(config.getFileName()).getModId(), (Object)config.getModId());
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFileName(), config);
        this.configSets.get((Object)config.getType()).add(config);
        LOGGER.debug("Config file {} for {} tracking", (Object)config.getFileName(), (Object)config.getModId());
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath) {
        LOGGER.debug("Loading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.openConfig((ModConfig)config, configBasePath));
    }

    public List<Pair<String, S2CSyncConfig>> syncConfigs(boolean isLocal) {
        Map<String, byte[]> configData = this.configSets.get((Object)ModConfig.Type.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, mc -> {
            try {
                return Files.readAllBytes(mc.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return configData.entrySet().stream().map(e -> Pair.of((Object)("Config " + (String)e.getKey()), (Object)new S2CSyncConfig((String)e.getKey(), (byte[])e.getValue()))).collect(Collectors.toList());
    }

    private void openConfig(ModConfig config, Path configBasePath) {
        LOGGER.debug("Loading config file type {} at {} for {}", (Object)config.getType(), (Object)config.getFileName(), (Object)config.getModId());
        CommentedFileConfig configData = config.getHandler().reader(configBasePath).apply(config);
        config.setConfigData((CommentedConfig)configData);
        config.fireEvent(new ModConfig.Loading(config));
        config.save();
    }

    public void receiveSyncedConfig(S2CSyncConfig s2CConfigData) {
        if (!Minecraft.func_71410_x().func_71387_A()) {
            Optional.ofNullable(this.fileMap.get(s2CConfigData.getFileName())).ifPresent(mc -> {
                mc.setConfigData((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(s2CConfigData.getBytes())));
                mc.fireEvent(new ModConfig.ConfigReloading((ModConfig)mc));
            });
        }
    }

    public void loadDefaultServerConfigs() {
        this.configSets.get((Object)ModConfig.Type.SERVER).forEach(modConfig -> {
            CommentedConfig commentedConfig = CommentedConfig.inMemory();
            modConfig.getSpec().correct(commentedConfig);
            modConfig.setConfigData(commentedConfig);
            modConfig.fireEvent(new ModConfig.Loading((ModConfig)modConfig));
        });
    }
}

