/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.config.ConfigHolder;
import io.github.cadiboo.nocubes.config.ModConfig;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.util.ExtendFluidsRange;
import io.github.cadiboo.nocubes.util.INoCubesBlockState;
import io.github.cadiboo.nocubes.util.StateHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ConfigHelper {
    private static final Marker CONFIG_SMOOTHABLE = MarkerManager.getMarker((String)"CONFIG_SMOOTHABLE");
    public static ModConfig clientConfig;
    public static ModConfig serverConfig;

    public static void bakeClient(ModConfig config) {
        clientConfig = config;
        Config.renderSmoothTerrain = Config.forceVisuals | (Boolean)ConfigHolder.CLIENT.renderSmoothTerrain.get();
        Config.renderSmoothLeaves = (Boolean)ConfigHolder.CLIENT.renderSmoothLeaves.get();
        Config.renderSmoothAndVanillaLeaves = (Boolean)ConfigHolder.CLIENT.renderSmoothAndVanillaLeaves.get();
        Config.leavesMeshGenerator = ConfigHolder.CLIENT.leavesMeshGenerator.get();
        Config.leavesSmoothable = Sets.newHashSet((Iterable)ConfigHolder.CLIENT.leavesSmoothable.get());
        ConfigHelper.initLeavesSmoothable();
        Config.smoothLeavesType = ConfigHolder.CLIENT.smoothLeavesType.get();
        Config.applyDiffuseLighting = (Boolean)ConfigHolder.CLIENT.applyDiffuseLighting.get();
        Config.betterTextures = (Boolean)ConfigHolder.CLIENT.betterTextures.get();
        Config.shortGrass = (Boolean)ConfigHolder.CLIENT.shortGrass.get();
        Config.smoothFluidLighting = (Boolean)ConfigHolder.CLIENT.smoothFluidLighting.get();
        Config.smoothFluidColors = (Boolean)ConfigHolder.CLIENT.smoothFluidColors.get();
        Config.naturalFluidTextures = (Boolean)ConfigHolder.CLIENT.naturalFluidTextures.get();
    }

    public static void bakeServer(ModConfig config) {
        serverConfig = config;
        Config.terrainSmoothable = Sets.newHashSet((Iterable)ConfigHolder.SERVER.terrainSmoothable.get());
        ConfigHelper.initTerrainSmoothable();
        Config.extendFluidsRange = ConfigHolder.SERVER.extendFluidsRange.get();
        Config.terrainMeshGenerator = ConfigHolder.SERVER.terrainMeshGenerator.get();
        Config.terrainCollisions = (Boolean)ConfigHolder.SERVER.terrainCollisions.get();
        Config.forceVisuals = (Boolean)ConfigHolder.SERVER.forceVisuals.get();
        if (Config.forceVisuals) {
            Config.renderSmoothTerrain = true;
        }
    }

    public static void discoverDefaultTerrainSmoothable() {
    }

    public static void discoverDefaultLeavesSmoothable() {
        ArrayList discoveredStates = new ArrayList();
        ForgeRegistries.BLOCKS.getValues().parallelStream().forEach(block -> {
            IBlockState defaultState = block.func_176223_P();
            if (defaultState.func_185904_a() == Material.field_151584_j) {
                Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Discovered leaves smoothable \"" + block + "\"");
                discoveredStates.add(defaultState);
            }
        });
        ConfigHelper.addLeavesSmoothable(discoveredStates.toArray(new IBlockState[0]));
    }

    public static void addTerrainSmoothable(IBlockState ... states) {
        if (states.length > 0) {
            for (IBlockState state : states) {
                Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Adding terrain smoothable: " + state);
                ((INoCubesBlockState)state).nocubes_setTerrainSmoothable(true);
                Config.terrainSmoothable.add(ConfigHelper.getStringFromState(state));
            }
            ConfigHelper.setValueAndSave(serverConfig, "general.terrainSmoothable", new ArrayList<String>(Config.terrainSmoothable));
        }
    }

    public static void removeTerrainSmoothable(IBlockState ... states) {
        if (states.length > 0) {
            for (IBlockState state : states) {
                Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Removing terrain smoothable: " + state);
                ((INoCubesBlockState)state).nocubes_setTerrainSmoothable(false);
                Config.terrainSmoothable.remove(ConfigHelper.getStringFromState(state));
            }
            ConfigHelper.setValueAndSave(serverConfig, "general.terrainSmoothable", new ArrayList<String>(Config.terrainSmoothable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLeavesSmoothable(IBlockState ... states) {
        if (states.length > 0) {
            HashSet<Block> hashSet = Config.leavesSmoothableBlocks;
            synchronized (hashSet) {
                for (IBlockState originalState : states) {
                    Block block = originalState.func_177230_c();
                    Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Adding leaves smoothable block: " + block);
                    for (IBlockState state : block.func_176194_O().func_177619_a()) {
                        Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Adding leaves smoothable state: " + state);
                        ((INoCubesBlockState)state).nocubes_setLeavesSmoothable(true);
                    }
                    Config.leavesSmoothable.add(block.getRegistryName().toString());
                    Config.leavesSmoothableBlocks.add(block);
                }
            }
            ConfigHelper.setValueAndSave(clientConfig, "general.leavesSmoothable", new ArrayList<String>(Config.leavesSmoothable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLeavesSmoothable(IBlockState ... states) {
        if (states.length > 0) {
            HashSet<Block> hashSet = Config.leavesSmoothableBlocks;
            synchronized (hashSet) {
                for (IBlockState originalState : states) {
                    Block block = originalState.func_177230_c();
                    Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Removing leaves smoothable block: " + block);
                    for (IBlockState state : block.func_176194_O().func_177619_a()) {
                        Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Removing leaves smoothable state: " + state);
                        ((INoCubesBlockState)state).nocubes_setLeavesSmoothable(false);
                    }
                    Config.leavesSmoothable.remove(block.getRegistryName().toString());
                    Config.leavesSmoothableBlocks.remove(block);
                }
            }
            ConfigHelper.setValueAndSave(clientConfig, "general.leavesSmoothable", new ArrayList<String>(Config.leavesSmoothable));
        }
    }

    private static void initTerrainSmoothable() {
        Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Initialising terrain smoothable");
        HashSet<IBlockState> smoothableStates = new HashSet<IBlockState>();
        for (String stateString : Config.terrainSmoothable) {
            IBlockState blockState = ConfigHelper.getStateFromString(stateString);
            if (blockState != null && blockState != StateHolder.AIR_DEFAULT) {
                smoothableStates.add(blockState);
                continue;
            }
            Config.LOGGER.error(CONFIG_SMOOTHABLE, "Cannot add invalid blockState \"" + stateString + "\" to terrain smoothable");
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                ((INoCubesBlockState)state).nocubes_setTerrainSmoothable(smoothableStates.contains(state));
            }
        }
    }

    private static void initLeavesSmoothable() {
        Config.LOGGER.debug(CONFIG_SMOOTHABLE, "Initialising leaves smoothable");
        HashSet<Block> smoothableBlocks = new HashSet<Block>();
        for (String blockString : Config.leavesSmoothable) {
            IBlockState defaultState = ConfigHelper.getStateFromString(blockString);
            if (defaultState != null && defaultState != StateHolder.AIR_DEFAULT) {
                Block block = defaultState.func_177230_c();
                smoothableBlocks.add(block);
                continue;
            }
            Config.LOGGER.error(CONFIG_SMOOTHABLE, "Cannot add invalid block \"" + blockString + "\" to leaves smoothable");
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            boolean isBlockSmoothable = smoothableBlocks.contains(block);
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                ((INoCubesBlockState)state).nocubes_setLeavesSmoothable(isBlockSmoothable);
            }
        }
        Config.leavesSmoothableBlocks.clear();
        Config.leavesSmoothableBlocks.addAll(smoothableBlocks);
    }

    @Nullable
    private static IBlockState getStateFromString(@Nonnull String stateString) {
        Preconditions.checkNotNull((Object)stateString, (Object)"String to parse must not be null");
        try {
            String variantsString;
            String[] splitBlockStateString = StringUtils.split((String)stateString, (String)"[");
            String blockString = splitBlockStateString[0];
            if (splitBlockStateString.length == 1) {
                variantsString = "default";
            } else if (splitBlockStateString.length == 2) {
                variantsString = StringUtils.reverse((String)StringUtils.reverse((String)StringUtils.split((String)stateString, (String)"[")[1]).replaceFirst("]", ""));
            } else {
                Config.LOGGER.error("Block/BlockState Parsing error for \"" + stateString + "\"");
                return null;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockString));
            if (block == null || block == Blocks.field_150350_a) {
                Config.LOGGER.error("Block Parsing error for \"" + blockString + "\". Block does not exist!");
                return null;
            }
            try {
                return CommandBase.func_190794_a((Block)block, (String)variantsString);
            }
            catch (NumberInvalidException e) {
                Config.LOGGER.error("BlockState Parsing error " + (Object)((Object)e) + " for \"" + variantsString + "\". Invalid Number!");
                return null;
            }
            catch (InvalidBlockStateException e) {
                Config.LOGGER.error("BlockState Parsing error " + (Object)((Object)e) + " for \"" + variantsString + "\". Invalid BlockState!");
                return null;
            }
        }
        catch (Exception e) {
            Config.LOGGER.error("Failed to parse blockstate \"" + stateString + "\"!", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private static String getStringFromState(@Nonnull IBlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"State to serialise must not be null");
        return state.toString();
    }

    @Nonnull
    static List<String> getDefaultTerrainSmoothable() {
        List vanillaStates = Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150349_c.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176385_b, (Comparable)Boolean.valueOf(false)), Blocks.field_150349_c.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176385_b, (Comparable)Boolean.valueOf(true)), Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE), Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL).func_177226_a((IProperty)BlockDirt.field_176385_b, (Comparable)Boolean.valueOf(false)), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL).func_177226_a((IProperty)BlockDirt.field_176385_b, (Comparable)Boolean.valueOf(true)), Blocks.field_150354_m.func_176223_P(), Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), Blocks.field_150322_A.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150366_p.func_176223_P(), Blocks.field_150352_o.func_176223_P(), Blocks.field_150450_ax.func_176223_P(), Blocks.field_150439_ay.func_176223_P(), Blocks.field_150482_ag.func_176223_P(), Blocks.field_150369_x.func_176223_P(), Blocks.field_150412_bA.func_176223_P(), Blocks.field_150449_bY.func_176223_P(), Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.STONE), Blocks.field_185774_da.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.WHITE), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.ORANGE), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.YELLOW), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.SILVER), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.BROWN), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.RED), Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)EnumDyeColor.BLACK), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150431_aC.func_176223_P(), Blocks.field_150357_h.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), Blocks.field_189877_df.func_176223_P(), Blocks.field_150426_aN.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), Blocks.field_150391_bh.func_176223_P().func_177226_a((IProperty)BlockMycelium.field_176384_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150391_bh.func_176223_P().func_177226_a((IProperty)BlockMycelium.field_176384_a, (Comparable)Boolean.valueOf(false))}).stream().map(ConfigHelper::getStringFromState).collect(Collectors.toList());
        ArrayList moddedStates = Lists.newArrayList((Object[])new String[]{"biomesoplenty:grass[snowy=false,variant=sandy]", "biomesoplenty:dirt[coarse=false,variant=sandy]", "biomesoplenty:white_sand", "biomesoplenty:grass[snowy=false,variant=silty]", "biomesoplenty:dirt[coarse=false,variant=loamy]", "biomesoplenty:grass[snowy=false,variant=loamy]", "biomesoplenty:dried_sand", "biomesoplenty:hard_ice", "biomesoplenty:mud[variant=mud]", "biomesoplenty:dirt[coarse=false,variant=silty]", "chisel:marble2[variation=7]", "chisel:limestone2[variation=7]", "dynamictrees:rootydirtspecies[life=0]", "dynamictrees:rootysand[life=0]", "iceandfire:ash", "iceandfire:sapphire_ore", "iceandfire:chared_grass", "iceandfire:chared_stone", "iceandfire:frozen_grass_path", "notenoughroofs:copper_ore", "rustic:slate"});
        ArrayList finalStates = Lists.newArrayList();
        finalStates.addAll(vanillaStates);
        finalStates.addAll(moddedStates);
        return finalStates;
    }

    @Nonnull
    static List<String> getDefaultLeavesSmoothable() {
        List vanillaStates = Lists.newArrayList((Object[])new BlockLeaves[]{Blocks.field_150362_t, Blocks.field_150361_u}).stream().map(IForgeRegistryEntry.Impl::getRegistryName).map(ResourceLocation::toString).collect(Collectors.toList());
        ArrayList moddedStates = Lists.newArrayList();
        ArrayList finalStates = Lists.newArrayList();
        finalStates.addAll(vanillaStates);
        finalStates.addAll(moddedStates);
        return finalStates;
    }

    public static void setExtendFluidsRange(ExtendFluidsRange newRange) {
        ConfigHelper.setValueAndSave(serverConfig, "general.extendFluidsRange", (Object)newRange);
    }

    public static void setTerrainMeshGenerator(MeshGeneratorType newGenerator) {
        ConfigHelper.setValueAndSave(serverConfig, "general.terrainMeshGenerator", (Object)newGenerator);
    }

    public static void setTerrainCollisions(boolean enabled) {
        ConfigHelper.setValueAndSave(serverConfig, "general.terrainCollisions", enabled);
    }

    public static void setRenderSmoothTerrain(boolean enabled) {
        ConfigHelper.setValueAndSave(clientConfig, "general.renderSmoothTerrain", enabled);
    }

    public static void setRenderSmoothLeaves(boolean enabled) {
        ConfigHelper.setValueAndSave(clientConfig, "general.renderSmoothLeaves", enabled);
    }

    public static void setValueAndSave(ModConfig modConfig, String path, Object newValue) {
        modConfig.getConfigData().set(path, newValue);
        modConfig.save();
        modConfig.fireEvent(new ModConfig.ConfigReloading(modConfig));
    }
}

