/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import com.google.common.collect.ImmutableList;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.StateHolder;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;

final class StolenReposeCode {
    StolenReposeCode() {
    }

    static void addCollisionBoxToList(IBlockState stateIn, World worldIn, BlockPos posIn, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        AxisAlignedBB collisionBoundingBox = StolenReposeCode.getStateCollisionBoundingBox(stateIn, (IBlockAccess)worldIn, posIn);
        if (collisionBoundingBox == null) {
            return;
        }
        float density = StolenReposeCode.getDensity(worldIn, posIn);
        if (density > -1.0f) {
            return;
        }
        if (StolenReposeCode.canSlopeAt(stateIn, worldIn, posIn, collisionBoundingBox)) {
            StolenReposeCode.addSlopingCollisionBoxes(stateIn, worldIn, posIn, collidingBoxes, arg_0 -> ((AxisAlignedBB)entityBox).func_72326_a(arg_0));
        } else {
            stateIn.func_185908_a(worldIn, posIn, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getDensity(World reader, BlockPos pos) {
        float density = 0.0f;
        try (ModProfiler ignored = ModProfiler.get().start("Collisions calculate cube density");){
            BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
            try {
                WorldBorder worldBorder = reader.func_175723_af();
                int startX = pos.func_177958_n();
                int startY = pos.func_177956_o();
                int startZ = pos.func_177952_p();
                for (int zOffset = 0; zOffset < 2; ++zOffset) {
                    for (int yOffset = 0; yOffset < 2; ++yOffset) {
                        for (int xOffset = 0; xOffset < 2; ++xOffset) {
                            pooledMutableBlockPos.func_181079_c(startX - xOffset, startY - yOffset, startZ - zOffset);
                            if (!reader.func_175667_e((BlockPos)pooledMutableBlockPos) || !worldBorder.func_177746_a((BlockPos)pooledMutableBlockPos)) {
                                density += 1.0f;
                                continue;
                            }
                            IBlockState testState = reader.func_180495_p((BlockPos)pooledMutableBlockPos);
                            density += ModUtil.getIndividualBlockDensity(IsSmoothable.TERRAIN_SMOOTHABLE.test(testState), testState);
                        }
                    }
                }
            }
            finally {
                pooledMutableBlockPos.func_185344_t();
            }
        }
        return density;
    }

    private static boolean canSlope(IBlockState state) {
        return IsSmoothable.TERRAIN_SMOOTHABLE.test(state);
    }

    private static boolean canSlopeAt(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB collisionBoundingBox) {
        AxisAlignedBB box = StolenReposeCode.getStateCollisionBoundingBox(state, (IBlockAccess)worldIn, pos);
        BlockPos posUp = pos.func_177984_a();
        return StolenReposeCode.canSlope(state) && (box == null || box.field_72337_e > 0.5 && StolenReposeCode.getStateCollisionBoundingBox(worldIn.func_180495_p(posUp), (IBlockAccess)worldIn, posUp) == null);
    }

    private static void addSlopingCollisionBoxes(IBlockState state, World world, BlockPos pos, List<AxisAlignedBB> collidingBoxes, Predicate<AxisAlignedBB> predicate) {
        double height = StolenReposeCode.blockHeight(pos, world, state);
        double stepHeight = height - 0.5;
        boolean slopingShore = true;
        boolean submerged = world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
        for (Direction direction : Direction.OrdinalDirections) {
            AxisAlignedBB box = StolenReposeCode.cornerBox(pos, direction, height, stepHeight, true, submerged, world);
            if (!predicate.test(box)) continue;
            collidingBoxes.add(box);
        }
    }

    private static AxisAlignedBB cornerBox(BlockPos pos, Direction direction, double blockHeight, double stepHeight, boolean slopingShore, boolean submerged, World world) {
        double height = StolenReposeCode.stepHigh(pos.func_177982_a(direction.x, 0, 0), stepHeight, slopingShore, submerged, world) && StolenReposeCode.stepHigh(pos.func_177982_a(0, 0, direction.z), stepHeight, slopingShore, submerged, world) && StolenReposeCode.stepHigh(pos.func_177982_a(direction.x, 0, direction.z), stepHeight, slopingShore, submerged, world) ? blockHeight : stepHeight;
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        return new AxisAlignedBB((double)posX + Math.max(0.0, (double)direction.x / 2.0), (double)posY, (double)posZ + Math.max(0.0, (double)direction.z / 2.0), (double)posX + Math.max(0.5, (double)direction.x), (double)posY + height, (double)posZ + Math.max(0.5, (double)direction.z));
    }

    private static boolean stepHigh(BlockPos offsetPos, double stepHeight, boolean slopingShore, boolean submerged, World world) {
        if (!world.func_175667_e(offsetPos) || !world.func_175723_af().func_177746_a(offsetPos)) {
            return true;
        }
        IBlockState neighbor = world.func_180495_p(offsetPos);
        if (!slopingShore && !submerged && neighbor.func_185904_a().func_76224_d()) {
            return true;
        }
        if (neighbor.func_185904_a().func_76230_c()) {
            return StolenReposeCode.blockHeight(offsetPos, world, neighbor) >= stepHeight;
        }
        return false;
    }

    private static double blockHeight(BlockPos pos, World world, IBlockState blockState) {
        AxisAlignedBB box = StolenReposeCode.getStateCollisionBoundingBox(blockState, (IBlockAccess)world, pos);
        return box == null ? 0.0 : box.field_72337_e;
    }

    @Nullable
    private static AxisAlignedBB getStateCollisionBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state == StateHolder.SNOW_LAYER_DEFAULT) {
            return null;
        }
        return state.func_185890_d(world, pos);
    }

    private static enum Direction {
        North(0, -1),
        South(0, 1),
        East(1, 0),
        West(-1, 0),
        NorthEast(Direction.North.x + Direction.East.x, Direction.North.z + Direction.East.z),
        NorthWest(Direction.North.x + Direction.West.x, Direction.North.z + Direction.West.z),
        SouthEast(Direction.South.x + Direction.East.x, Direction.South.z + Direction.East.z),
        SouthWest(Direction.South.x + Direction.West.x, Direction.South.z + Direction.West.z);

        public static final ImmutableList<Direction> OrdinalDirections;
        private final int x;
        private final int z;

        private Direction(int x, int z) {
            this.x = x;
            this.z = z;
        }

        static {
            OrdinalDirections = ImmutableList.of((Object)((Object)NorthEast), (Object)((Object)NorthWest), (Object)((Object)SouthEast), (Object)((Object)SouthWest));
        }
    }
}

