/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.collision.MeshCollisionUtil;
import io.github.cadiboo.nocubes.collision.StolenReposeCode;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.mesh.MeshDispatcher;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.mesh.generator.OldNoCubes;
import io.github.cadiboo.nocubes.util.CacheUtil;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.ForgeEventFactory;

public final class CollisionHandler {
    public static boolean shouldApplyMeshCollisions(@Nullable Entity entity) {
        return entity instanceof EntityPlayer;
    }

    public static boolean shouldApplyReposeCollisions(@Nullable Entity entity) {
        return entity instanceof EntityItem || entity instanceof EntityLivingBase;
    }

    public static boolean getCollisionBoxes(World _this, Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, List<AxisAlignedBB> outList, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, WorldBorder worldborder, boolean flag, boolean flag1) {
        if (!Config.terrainCollisions) {
            return CollisionHandler.getVanillaCollisions(_this, entityIn, aabb, p_191504_3_, outList, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, worldborder, flag, flag1);
        }
        if (CollisionHandler.shouldApplyMeshCollisions(entityIn)) {
            return CollisionHandler.getMeshCollisions(_this, entityIn, aabb, p_191504_3_, outList, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, worldborder, flag, flag1);
        }
        if (CollisionHandler.shouldApplyReposeCollisions(entityIn)) {
            return CollisionHandler.getReposeCollisions(_this, entityIn, aabb, p_191504_3_, outList, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, worldborder, flag, flag1);
        }
        return CollisionHandler.getVanillaCollisions(_this, entityIn, aabb, p_191504_3_, outList, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, worldborder, flag, flag1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getVanillaCollisions(World _this, Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, List<AxisAlignedBB> outList, int i, int j, int k, int l, int i1, int j1, WorldBorder worldborder, boolean flag, boolean flag1) {
        IBlockState iblockstate = Blocks.field_150348_b.func_176223_P();
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            if (p_191504_3_ && !ForgeEventFactory.gatherCollisionBoxes((World)_this, (Entity)entityIn, (AxisAlignedBB)aabb, outList)) {
                boolean bl = true;
                return bl;
            }
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = i1; l1 < j1; ++l1) {
                    boolean flag3;
                    boolean flag2 = k1 == i || k1 == j - 1;
                    boolean bl = flag3 = l1 == i1 || l1 == j1 - 1;
                    if (flag2 && flag3 || !_this.func_175667_e((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, 64, l1))) continue;
                    for (int i2 = k; i2 < l; ++i2) {
                        if ((flag2 || flag3) && i2 == l - 1) continue;
                        if (p_191504_3_) {
                            if (k1 < -30000000 || k1 >= 30000000 || l1 < -30000000 || l1 >= 30000000) {
                                boolean bl2 = true;
                                return bl2;
                            }
                        } else if (entityIn != null && flag == flag1) {
                            entityIn.func_174821_h(!flag1);
                        }
                        blockpos$pooledmutableblockpos.func_181079_c(k1, i2, l1);
                        IBlockState iblockstate1 = !p_191504_3_ && !worldborder.func_177746_a((BlockPos)blockpos$pooledmutableblockpos) && flag1 ? iblockstate : _this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        iblockstate1.func_185908_a(_this, (BlockPos)blockpos$pooledmutableblockpos, aabb, outList, entityIn, false);
                        if (!p_191504_3_ || ForgeEventFactory.gatherCollisionBoxes((World)_this, (Entity)entityIn, (AxisAlignedBB)aabb, outList)) continue;
                        boolean bl3 = true;
                        return bl3;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return !outList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getReposeCollisions(World _this, Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, List<AxisAlignedBB> outList, int startX, int j, int k, int l, int startZ, int maxZ, WorldBorder worldborder, boolean flag, boolean flag1) {
        BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            if (p_191504_3_ && !ForgeEventFactory.gatherCollisionBoxes((World)_this, (Entity)entityIn, (AxisAlignedBB)aabb, outList)) {
                boolean bl = true;
                return bl;
            }
            for (int posX = startX; posX < j; ++posX) {
                for (int posZ = startZ; posZ < maxZ; ++posZ) {
                    boolean flag3;
                    boolean flag2 = posX == startX || posX == j - 1;
                    boolean bl = flag3 = posZ == startZ || posZ == maxZ - 1;
                    if (flag2 && flag3 || !_this.func_175667_e((BlockPos)pooledMutableBlockPos.func_181079_c(posX, 64, posZ))) continue;
                    for (int i2 = k; i2 < l; ++i2) {
                        if ((flag2 || flag3) && i2 == l - 1) continue;
                        if (p_191504_3_) {
                            if (posX < -30000000 || posX >= 30000000 || posZ < -30000000 || posZ >= 30000000) {
                                boolean bl2 = true;
                                return bl2;
                            }
                        } else if (entityIn != null && flag == flag1) {
                            entityIn.func_174821_h(!flag1);
                        }
                        pooledMutableBlockPos.func_181079_c(posX, i2, posZ);
                        IBlockState state = !p_191504_3_ && !worldborder.func_177746_a((BlockPos)pooledMutableBlockPos) && flag1 ? Blocks.field_150348_b.func_176223_P() : _this.func_180495_p((BlockPos)pooledMutableBlockPos);
                        if (IsSmoothable.TERRAIN_SMOOTHABLE.test(state)) {
                            StolenReposeCode.addCollisionBoxToList(state, _this, (BlockPos)pooledMutableBlockPos, aabb, outList, entityIn, false);
                        } else {
                            state.func_185908_a(_this, (BlockPos)pooledMutableBlockPos, aabb, outList, entityIn, false);
                        }
                        if (!p_191504_3_ || ForgeEventFactory.gatherCollisionBoxes((World)_this, (Entity)entityIn, (AxisAlignedBB)aabb, outList)) continue;
                        boolean bl3 = true;
                        return bl3;
                    }
                }
            }
        }
        finally {
            pooledMutableBlockPos.func_185344_t();
        }
        return !outList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean getMeshCollisions(World _this, Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, List<AxisAlignedBB> outList, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, WorldBorder worldborder, boolean flag, boolean flag1) {
        block296: {
            block297: {
                block291: {
                    pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                    meshGenerator = Config.terrainMeshGenerator.getMeshGenerator();
                    meshSizeX = ModUtil.getMeshSizeX(maxXp1 - minXm1, meshGenerator);
                    meshSizeY = ModUtil.getMeshSizeY(maxYp1 - minYm1, meshGenerator);
                    meshSizeZ = ModUtil.getMeshSizeZ(maxZp1 - minZm1, meshGenerator);
                    startPosX = minXm1 - 1;
                    startPosY = minYm1 - 1;
                    startPosZ = minZm1 - 1;
                    endPosX = maxXp1 + 1;
                    endPosY = maxYp1 + 1;
                    endPosZ = maxZp1 + 1;
                    if (!_this.func_175639_b(new StructureBoundingBox(startPosX, startPosY, startPosZ, endPosX, endPosY, endPosZ), true)) {
                        var25_25 = CollisionHandler.getFallbackMeshCollisions(_this, entityIn, aabb, p_191504_3_, outList, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, worldborder, flag, flag1);
                        return var25_25;
                    }
                    profiler = ModProfiler.get();
                    stateCache = CacheUtil.generateStateCache(startPosX, startPosY, startPosZ, endPosX, endPosY, endPosZ, 1, 1, 1, _this, pooledMutableBlockPos);
                    var27_28 = null;
                    try {
                        smoothableCache = CacheUtil.generateSmoothableCache(startPosX, startPosY, startPosZ, endPosX, endPosY, endPosZ, 1, 1, 1, stateCache, IsSmoothable.TERRAIN_SMOOTHABLE);
                        var29_32 = null;
                        try {
                            densityCache = CacheUtil.generateDensityCache(startPosX, startPosY, startPosZ, endPosX - 1, endPosY - 1, endPosZ - 1, 1, 1, 1, stateCache, smoothableCache);
                            var31_36 = null;
                            try {
                                collidingShapes = new ArrayList<AxisAlignedBB>();
                                densityCacheArray = densityCache.getDensityCache();
                                blockStateArray = stateCache.getBlockStates();
                                stateOffsetX = stateCache.startPaddingX;
                                stateOffsetY = stateCache.startPaddingY;
                                stateOffsetZ = stateCache.startPaddingZ;
                                stateCacheSizeX = stateCache.sizeX;
                                stateCacheSizeY = stateCache.sizeY;
                                sizeX = maxXp1 - minXm1;
                                sizeY = maxYp1 - minYm1;
                                sizeZ = maxZp1 - minZm1;
                                densityOffsetX = densityCache.startPaddingX;
                                densityOffsetY = densityCache.startPaddingY;
                                densityOffsetZ = densityCache.startPaddingZ;
                                densityCacheSizeX = densityCache.sizeX;
                                densityCacheSizeY = densityCache.sizeY;
                                z = 0;
lbl43:
                                // 2 sources

                                while (true) {
                                    if (z < sizeZ) {
                                        break block291;
                                    }
                                    ignored = profiler.start("Calculate collisions mesh");
                                    var42_52 = null;
                                    try {
                                        if (Config.terrainMeshGenerator == MeshGeneratorType.OldNoCubes) {
                                            meshData = new HashMap<Vec3b, FaceList>();
                                            meshData.put(Vec3b.retain((byte)0, (byte)0, (byte)0), OldNoCubes.generateBlock(new BlockPos(minXm1 + 1, minYm1 + 1, minZm1 + 1), (IBlockAccess)_this, IsSmoothable.TERRAIN_SMOOTHABLE, pooledMutableBlockPos));
                                        } else {
                                            meshData = meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ});
                                        }
                                    }
                                    catch (Throwable densityOffsetX) {
                                        var42_52 = densityOffsetX;
                                        throw densityOffsetX;
                                    }
                                    finally {
                                        if (ignored != null) {
                                            if (var42_52 != null) {
                                                try {
                                                    ignored.close();
                                                }
                                                catch (Throwable densityOffsetX) {
                                                    var42_52.addSuppressed(densityOffsetX);
                                                }
                                            } else {
                                                ignored.close();
                                            }
                                        }
                                    }
                                    ignored = profiler.start("Offset collisions mesh");
                                    var42_52 = null;
                                    try {
                                        MeshDispatcher.offsetMesh(minXm1, minYm1, minZm1, meshData);
                                    }
                                    catch (Throwable densityOffsetX) {
                                        var42_52 = densityOffsetX;
                                        throw densityOffsetX;
                                    }
                                    finally {
                                        if (ignored != null) {
                                            if (var42_52 != null) {
                                                try {
                                                    ignored.close();
                                                }
                                                catch (Throwable densityOffsetX) {
                                                    var42_52.addSuppressed(densityOffsetX);
                                                }
                                            } else {
                                                ignored.close();
                                            }
                                        }
                                    }
                                    finalFaces = FaceList.retain();
                                    var42_52 = null;
                                    try {
                                        ignored = profiler.start("Combine collisions faces");
                                        densityOffsetY = null;
                                        try {
                                            for (FaceList generatedFaceList : meshData.values()) {
                                                finalFaces.addAll(generatedFaceList);
                                                generatedFaceList.close();
                                            }
                                            for (Vec3b vec3b : meshData.keySet()) {
                                                vec3b.close();
                                            }
                                        }
                                        catch (Throwable densityOffsetZ) {
                                            densityOffsetY = densityOffsetZ;
                                            throw densityOffsetZ;
                                        }
                                        finally {
                                            if (ignored != null) {
                                                if (densityOffsetY != null) {
                                                    try {
                                                        ignored.close();
                                                    }
                                                    catch (Throwable densityOffsetZ) {
                                                        densityOffsetY.addSuppressed(densityOffsetZ);
                                                    }
                                                } else {
                                                    ignored.close();
                                                }
                                            }
                                        }
                                        n0 = Vec3.retain(0.0, 0.0, 0.0);
                                        densityOffsetY = null;
                                        try {
                                            n1 = Vec3.retain(0.0, 0.0, 0.0);
                                            vec3b = null;
                                            try {
                                                n2 = Vec3.retain(0.0, 0.0, 0.0);
                                                z = null;
                                                try {
                                                    n3 = Vec3.retain(0.0, 0.0, 0.0);
                                                    var50_100 = null;
                                                    try {
                                                        normal = Face.retain(n0, n1, n2, n3);
                                                        var52_109 = null;
                                                        try {
                                                            centre = Vec3.retain(0.0, 0.0, 0.0);
                                                            var54_115 = null;
                                                            try {
                                                                averageOfNormal = Vec3.retain(0.0, 0.0, 0.0);
                                                                var56_121 = null;
                                                                try {
                                                                    finalFacesSize = finalFaces.size();
                                                                    for (i = 0; i < finalFacesSize; ++i) {
                                                                        face = (Face)finalFaces.get(i);
                                                                        var60_128 = null;
                                                                        try {
                                                                            v0 = face.getVertex0();
                                                                            var62_132 = null;
                                                                            try {
                                                                                v1 = face.getVertex1();
                                                                                var64_136 = null;
                                                                                try {
                                                                                    v2 = face.getVertex2();
                                                                                    var66_140 = null;
                                                                                    try {
                                                                                        v3 = face.getVertex3();
                                                                                        var68_144 = null;
                                                                                        try {
                                                                                            face.assignNormalTo(normal);
                                                                                            face.assignAverageTo(centre);
                                                                                            normal.assignAverageTo(averageOfNormal);
                                                                                            averageOfNormal.normalise().multiply(0.125);
                                                                                            MeshCollisionUtil.addShapeToListIfIntersects(collidingShapes, MeshCollisionUtil.makeShape(centre, averageOfNormal, v0), aabb);
                                                                                            MeshCollisionUtil.addShapeToListIfIntersects(collidingShapes, MeshCollisionUtil.makeShape(centre, averageOfNormal, v1), aabb);
                                                                                            MeshCollisionUtil.addShapeToListIfIntersects(collidingShapes, MeshCollisionUtil.makeShape(centre, averageOfNormal, v2), aabb);
                                                                                            MeshCollisionUtil.addShapeToListIfIntersects(collidingShapes, MeshCollisionUtil.makeShape(centre, averageOfNormal, v3), aabb);
                                                                                            continue;
                                                                                        }
                                                                                        catch (Throwable var69_146) {
                                                                                            var68_144 = var69_146;
                                                                                            throw var69_146;
                                                                                        }
                                                                                        finally {
                                                                                            if (v3 != null) {
                                                                                                if (var68_144 != null) {
                                                                                                    try {
                                                                                                        v3.close();
                                                                                                    }
                                                                                                    catch (Throwable var69_145) {
                                                                                                        var68_144.addSuppressed(var69_145);
                                                                                                    }
                                                                                                } else {
                                                                                                    v3.close();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    catch (Throwable var67_143) {
                                                                                        var66_140 = var67_143;
                                                                                        throw var67_143;
                                                                                    }
                                                                                    finally {
                                                                                        if (v2 != null) {
                                                                                            if (var66_140 != null) {
                                                                                                try {
                                                                                                    v2.close();
                                                                                                }
                                                                                                catch (Throwable var67_142) {
                                                                                                    var66_140.addSuppressed(var67_142);
                                                                                                }
                                                                                            } else {
                                                                                                v2.close();
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                                catch (Throwable var65_139) {
                                                                                    var64_136 = var65_139;
                                                                                    throw var65_139;
                                                                                }
                                                                                finally {
                                                                                    if (v1 != null) {
                                                                                        if (var64_136 != null) {
                                                                                            try {
                                                                                                v1.close();
                                                                                            }
                                                                                            catch (Throwable var65_138) {
                                                                                                var64_136.addSuppressed(var65_138);
                                                                                            }
                                                                                        } else {
                                                                                            v1.close();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            catch (Throwable var63_135) {
                                                                                var62_132 = var63_135;
                                                                                throw var63_135;
                                                                            }
                                                                            finally {
                                                                                if (v0 != null) {
                                                                                    if (var62_132 != null) {
                                                                                        try {
                                                                                            v0.close();
                                                                                        }
                                                                                        catch (Throwable var63_134) {
                                                                                            var62_132.addSuppressed(var63_134);
                                                                                        }
                                                                                    } else {
                                                                                        v0.close();
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                        catch (Throwable var61_131) {
                                                                            var60_128 = var61_131;
                                                                            throw var61_131;
                                                                        }
                                                                        finally {
                                                                            if (face != null) {
                                                                                if (var60_128 != null) {
                                                                                    try {
                                                                                        face.close();
                                                                                    }
                                                                                    catch (Throwable var61_130) {
                                                                                        var60_128.addSuppressed(var61_130);
                                                                                    }
                                                                                } else {
                                                                                    face.close();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                catch (Throwable var57_125) {
                                                                    var56_121 = var57_125;
                                                                    throw var57_125;
                                                                }
                                                                finally {
                                                                    if (averageOfNormal != null) {
                                                                        if (var56_121 != null) {
                                                                            try {
                                                                                averageOfNormal.close();
                                                                            }
                                                                            catch (Throwable var57_124) {
                                                                                var56_121.addSuppressed(var57_124);
                                                                            }
                                                                        } else {
                                                                            averageOfNormal.close();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            catch (Throwable var55_119) {
                                                                var54_115 = var55_119;
                                                                throw var55_119;
                                                            }
                                                            finally {
                                                                if (centre != null) {
                                                                    if (var54_115 != null) {
                                                                        try {
                                                                            centre.close();
                                                                        }
                                                                        catch (Throwable var55_118) {
                                                                            var54_115.addSuppressed(var55_118);
                                                                        }
                                                                    } else {
                                                                        centre.close();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        catch (Throwable var53_113) {
                                                            var52_109 = var53_113;
                                                            throw var53_113;
                                                        }
                                                        finally {
                                                            if (normal != null) {
                                                                if (var52_109 != null) {
                                                                    try {
                                                                        normal.close();
                                                                    }
                                                                    catch (Throwable var53_112) {
                                                                        var52_109.addSuppressed(var53_112);
                                                                    }
                                                                } else {
                                                                    normal.close();
                                                                }
                                                            }
                                                        }
                                                    }
                                                    catch (Throwable var51_107) {
                                                        var50_100 = var51_107;
                                                        throw var51_107;
                                                    }
                                                    finally {
                                                        if (n3 != null) {
                                                            if (var50_100 != null) {
                                                                try {
                                                                    n3.close();
                                                                }
                                                                catch (Throwable var51_106) {
                                                                    var50_100.addSuppressed(var51_106);
                                                                }
                                                            } else {
                                                                n3.close();
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (Throwable var49_93) {
                                                    z = var49_93;
                                                    throw var49_93;
                                                }
                                                finally {
                                                    if (n2 != null) {
                                                        if (z != null) {
                                                            try {
                                                                n2.close();
                                                            }
                                                            catch (Throwable var49_92) {
                                                                z.addSuppressed(var49_92);
                                                            }
                                                        } else {
                                                            n2.close();
                                                        }
                                                    }
                                                }
                                            }
                                            catch (Throwable n2) {
                                                vec3b = n2;
                                                throw n2;
                                            }
                                            finally {
                                                if (n1 != null) {
                                                    if (vec3b != null) {
                                                        try {
                                                            n1.close();
                                                        }
                                                        catch (Throwable n2) {
                                                            vec3b.addSuppressed(n2);
                                                        }
                                                    } else {
                                                        n1.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable n1) {
                                            densityOffsetY = n1;
                                            throw n1;
                                        }
                                        finally {
                                            if (n0 != null) {
                                                if (densityOffsetY != null) {
                                                    try {
                                                        n0.close();
                                                    }
                                                    catch (Throwable n1) {
                                                        densityOffsetY.addSuppressed(n1);
                                                    }
                                                } else {
                                                    n0.close();
                                                }
                                            }
                                        }
                                        outList.addAll(collidingShapes);
                                        if (p_191504_3_ && !ForgeEventFactory.gatherCollisionBoxes((World)_this, (Entity)entityIn, (AxisAlignedBB)aabb, outList)) {
                                            n0 = true;
                                            return n0;
                                        }
                                        block218: for (posX = minXm1; posX < maxXp1; ++posX) {
                                            posZ = minZm1;
lbl347:
                                            // 2 sources

                                            while (true) {
                                                if (posZ >= maxZp1) continue block218;
                                                flag2 = posX == minXm1 || posX == maxXp1 - 1;
                                                v0 = flag3 = posZ == minZm1 || posZ == maxZp1 - 1;
                                                if (flag2 && flag3 || !_this.func_175667_e((BlockPos)pooledMutableBlockPos.func_181079_c(posX, 64, posZ))) break block296;
                                                break block297;
                                                break;
                                            }
                                        }
                                    }
                                    catch (Throwable var43_62) {
                                        var42_52 = var43_62;
                                        throw var43_62;
                                    }
                                    finally {
                                        if (finalFaces != null) {
                                            if (var42_52 != null) {
                                                try {
                                                    finalFaces.close();
                                                }
                                                catch (Throwable densityOffsetY) {
                                                    var42_52.addSuppressed(densityOffsetY);
                                                }
                                            } else {
                                                finalFaces.close();
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (Throwable var32_39) {
                                var31_36 = var32_39;
                                throw var32_39;
                            }
                            finally {
                                if (densityCache != null) {
                                    if (var31_36 != null) {
                                        try {
                                            densityCache.close();
                                        }
                                        catch (Throwable densityOffsetY) {
                                            var31_36.addSuppressed(densityOffsetY);
                                        }
                                    } else {
                                        densityCache.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable var30_35) {
                            var29_32 = var30_35;
                            throw var30_35;
                        }
                        finally {
                            if (smoothableCache != null) {
                                if (var29_32 != null) {
                                    try {
                                        smoothableCache.close();
                                    }
                                    catch (Throwable densityOffsetY) {
                                        var29_32.addSuppressed(densityOffsetY);
                                    }
                                } else {
                                    smoothableCache.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var28_31) {
                        var27_28 = var28_31;
                        throw var28_31;
                    }
                    finally {
                        pooledMutableBlockPos.func_185344_t();
                    }
                    if (!outList.isEmpty()) {
                        v1 = true;
                        return v1;
                    }
                    v1 = false;
                    return v1;
                }
                for (y = 0; y < sizeY; ++y) {
                    for (x = 0; x < sizeX; ++x) {
                        blockState = blockStateArray[stateCache.getIndex(stateOffsetX + x, stateOffsetY + y, stateOffsetZ + z, stateCacheSizeX, stateCacheSizeY)];
                        if (IsSmoothable.TERRAIN_SMOOTHABLE.test(blockState) && !(densityCacheArray[densityCache.getIndex(densityOffsetX + x, densityOffsetY + y, densityOffsetZ + z, densityCacheSizeX, densityCacheSizeY)] < -6.0f)) continue;
                        blockState.func_185908_a(_this, (BlockPos)pooledMutableBlockPos.func_181079_c(minXm1 + x, minYm1 + y, minZm1 + z), aabb, collidingShapes, entityIn, false);
                    }
                }
                ++z;
                ** continue;
            }
            for (posY = minYm1; posY < maxYp1; ++posY) {
                if ((flag2 || flag3) && posY == maxYp1 - 1) continue;
                if (p_191504_3_) {
                    if (posX < -30000000 || posX >= 30000000 || posZ < -30000000 || posZ >= 30000000) {
                        z = true;
                        return z;
                    }
                } else if (entityIn != null && flag == flag1) {
                    entityIn.func_174821_h(flag1 == false);
                }
                pooledMutableBlockPos.func_181079_c(posX, posY, posZ);
                state = p_191504_3_ == false && worldborder.func_177746_a((BlockPos)pooledMutableBlockPos) == false && flag1 != false ? Blocks.field_150348_b.func_176223_P() : _this.func_180495_p((BlockPos)pooledMutableBlockPos);
                if (!IsSmoothable.TERRAIN_SMOOTHABLE.test(state)) {
                    state.func_185908_a(_this, (BlockPos)pooledMutableBlockPos, aabb, outList, entityIn, false);
                }
                if (!p_191504_3_ || ForgeEventFactory.gatherCollisionBoxes((World)_this, (Entity)entityIn, (AxisAlignedBB)aabb, outList)) continue;
                var49_98 = true;
                return var49_98;
            }
        }
        ++posZ;
        ** continue;
    }

    private static boolean getFallbackMeshCollisions(World _this, Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, List<AxisAlignedBB> outList, int minXm1, int maxXp1, int minYm1, int maxYp1, int minZm1, int maxZp1, WorldBorder worldborder, boolean flag, boolean flag1) {
        return CollisionHandler.getVanillaCollisions(_this, entityIn, aabb, p_191504_3_, outList, minXm1, maxXp1, minYm1, maxYp1, minZm1, maxZp1, worldborder, flag, flag1);
    }
}

