/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.UVHelper;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;

public final class SmoothLightingFluidBlockRenderer
extends BlockFluidRenderer {
    public SmoothLightingFluidBlockRenderer() {
        super(Minecraft.func_71410_x().func_175602_ab().field_175025_e.field_187500_a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178270_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, BufferBuilder buffer) {
        OptiFineCompatibility.PROXY.pushShaderThing(state, pos, worldIn, buffer);
        BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            float blue0;
            float blue1;
            float blue2;
            float blue3;
            float green0;
            float green1;
            float green2;
            float green3;
            float red0;
            float red1;
            float red2;
            float red3;
            int light0;
            int light1;
            int light2;
            int light3;
            float blue;
            float green;
            float red;
            TextureAtlasSprite[] atextureatlassprite;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            BlockLiquid blockLiquid = (BlockLiquid)state.func_177230_c();
            Material material = state.func_185904_a();
            boolean isLava = material == Material.field_151587_i;
            TextureAtlasSprite[] textureAtlasSpriteArray = atextureatlassprite = isLava ? this.field_178272_a : this.field_178271_b;
            if (isLava) {
                red = 1.0f;
                green = 1.0f;
                blue = 1.0f;
            } else {
                int waterColor = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pos);
                red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                blue = (float)(waterColor & 0xFF) / 255.0f;
            }
            boolean shouldRenderDown = state.func_185894_c(worldIn, pos, EnumFacing.DOWN);
            shouldRenderDown &= !Config.renderSmoothTerrain || !IsSmoothable.TERRAIN_SMOOTHABLE.test(worldIn.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x, y - 1, z)));
            boolean shouldRenderUp = state.func_185894_c(worldIn, pos, EnumFacing.UP);
            shouldRenderUp &= !Config.renderSmoothTerrain || !IsSmoothable.TERRAIN_SMOOTHABLE.test(worldIn.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x, y + 1, z)));
            boolean shouldRenderNorth = state.func_185894_c(worldIn, pos, EnumFacing.NORTH);
            boolean shouldRenderSouth = state.func_185894_c(worldIn, pos, EnumFacing.SOUTH);
            boolean shouldRenderWest = state.func_185894_c(worldIn, pos, EnumFacing.WEST);
            boolean shouldRenderEast = state.func_185894_c(worldIn, pos, EnumFacing.EAST);
            if (!(shouldRenderUp || shouldRenderDown || (shouldRenderEast &= !Config.renderSmoothTerrain || !IsSmoothable.TERRAIN_SMOOTHABLE.test(worldIn.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x + 1, y, z)))) || (shouldRenderWest &= !Config.renderSmoothTerrain || !IsSmoothable.TERRAIN_SMOOTHABLE.test(worldIn.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x - 1, y, z)))) || (shouldRenderNorth &= !Config.renderSmoothTerrain || !IsSmoothable.TERRAIN_SMOOTHABLE.test(worldIn.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x, y, z - 1)))) || (shouldRenderSouth &= !Config.renderSmoothTerrain || !IsSmoothable.TERRAIN_SMOOTHABLE.test(worldIn.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(x, y, z + 1)))))) {
                boolean bl = false;
                return bl;
            }
            boolean wasAnythingRendered = false;
            float fluidHeight = this.getFluidHeight(worldIn, material, x, y, z, pooledMutableBlockPos);
            float fluidHeightSouth = this.getFluidHeight(worldIn, material, x, y, z + 1, pooledMutableBlockPos);
            float fluidHeightEastSouth = this.getFluidHeight(worldIn, material, x + 1, y, z + 1, pooledMutableBlockPos);
            float fluidHeightEast = this.getFluidHeight(worldIn, material, x + 1, y, z, pooledMutableBlockPos);
            boolean smoothLighting = this.smoothLighting();
            boolean colors = this.colors();
            if (shouldRenderUp) {
                if (isLava) {
                    light3 = 0xF000F0;
                    light2 = 0xF000F0;
                    light1 = 0xF000F0;
                    light0 = 0xF000F0;
                    red3 = 1.0f;
                    red2 = 1.0f;
                    red1 = 1.0f;
                    red0 = 1.0f;
                    green3 = 1.0f;
                    green2 = 1.0f;
                    green1 = 1.0f;
                    green0 = 1.0f;
                    blue3 = 1.0f;
                    blue2 = 1.0f;
                    blue1 = 1.0f;
                    blue0 = 1.0f;
                } else {
                    if (!smoothLighting) {
                        int combinedLightUpMax;
                        light0 = combinedLightUpMax = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x, y, z));
                        light1 = combinedLightUpMax;
                        light2 = combinedLightUpMax;
                        light3 = combinedLightUpMax;
                    } else {
                        light0 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x, y, z));
                        light1 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x, y, z + 1));
                        light2 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x + 1, y, z + 1));
                        light3 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x + 1, y, z));
                    }
                    if (!colors) {
                        red2 = red3 = red;
                        red1 = red3;
                        red0 = red3;
                        green2 = green3 = green;
                        green1 = green3;
                        green0 = green3;
                        blue2 = blue3 = blue;
                        blue1 = blue3;
                        blue0 = blue3;
                    } else {
                        red0 = red;
                        green0 = green;
                        blue0 = blue;
                        int waterColor1 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x, y, z + 1));
                        red1 = (float)(waterColor1 >> 16 & 0xFF) / 255.0f;
                        green1 = (float)(waterColor1 >> 8 & 0xFF) / 255.0f;
                        blue1 = (float)(waterColor1 & 0xFF) / 255.0f;
                        int waterColor2 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x + 1, y, z + 1));
                        red2 = (float)(waterColor2 >> 16 & 0xFF) / 255.0f;
                        green2 = (float)(waterColor2 >> 8 & 0xFF) / 255.0f;
                        blue2 = (float)(waterColor2 & 0xFF) / 255.0f;
                        int waterColor3 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x + 1, y, z));
                        red3 = (float)(waterColor3 >> 16 & 0xFF) / 255.0f;
                        green3 = (float)(waterColor3 >> 8 & 0xFF) / 255.0f;
                        blue3 = (float)(waterColor3 & 0xFF) / 255.0f;
                    }
                }
                wasAnythingRendered |= this.renderUp(buffer, atextureatlassprite, red0, green0, blue0, red1, green1, blue1, red2, green2, blue2, red3, green3, blue3, fluidHeight, fluidHeightSouth, fluidHeightEastSouth, fluidHeightEast, x, y, z, light0, light1, light2, light3, blockLiquid.func_176364_g(worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x, y + 1, z)), blockLiquid.func_189543_a(worldIn, pos, state), MathHelper.func_180187_c((int)x, (int)y, (int)z));
            }
            if (shouldRenderDown) {
                if (isLava) {
                    light3 = 0xF000F0;
                    light2 = 0xF000F0;
                    light1 = 0xF000F0;
                    light0 = 0xF000F0;
                    red3 = 1.0f;
                    red2 = 1.0f;
                    red1 = 1.0f;
                    red0 = 1.0f;
                    green3 = 1.0f;
                    green2 = 1.0f;
                    green1 = 1.0f;
                    green0 = 1.0f;
                    blue3 = 1.0f;
                    blue2 = 1.0f;
                    blue1 = 1.0f;
                    blue0 = 1.0f;
                } else {
                    int ym1 = y - 1;
                    if (!smoothLighting) {
                        int downCombinedLightUpMax;
                        light0 = downCombinedLightUpMax = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x, ym1, z));
                        light1 = downCombinedLightUpMax;
                        light2 = downCombinedLightUpMax;
                        light3 = downCombinedLightUpMax;
                    } else {
                        light0 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x, ym1, z + 1));
                        light1 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x, ym1, z));
                        light2 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x + 1, ym1, z));
                        light3 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_181079_c(x + 1, ym1, z + 1));
                    }
                    if (!colors) {
                        red2 = red3 = red;
                        red1 = red3;
                        red0 = red3;
                        green2 = green3 = green;
                        green1 = green3;
                        green0 = green3;
                        blue2 = blue3 = blue;
                        blue1 = blue3;
                        blue0 = blue3;
                    } else {
                        int waterColor0 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x, ym1, z + 1));
                        red0 = (float)(waterColor0 >> 16 & 0xFF) / 255.0f;
                        green0 = (float)(waterColor0 >> 8 & 0xFF) / 255.0f;
                        blue0 = (float)(waterColor0 & 0xFF) / 255.0f;
                        int waterColor1 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x, ym1, z));
                        red1 = (float)(waterColor1 >> 16 & 0xFF) / 255.0f;
                        green1 = (float)(waterColor1 >> 8 & 0xFF) / 255.0f;
                        blue1 = (float)(waterColor1 & 0xFF) / 255.0f;
                        int waterColor2 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x + 1, ym1, z));
                        red2 = (float)(waterColor2 >> 16 & 0xFF) / 255.0f;
                        green2 = (float)(waterColor2 >> 8 & 0xFF) / 255.0f;
                        blue2 = (float)(waterColor2 & 0xFF) / 255.0f;
                        int waterColor3 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_181079_c(x + 1, ym1, z + 1));
                        red3 = (float)(waterColor3 >> 16 & 0xFF) / 255.0f;
                        green3 = (float)(waterColor3 >> 8 & 0xFF) / 255.0f;
                        blue3 = (float)(waterColor3 & 0xFF) / 255.0f;
                    }
                }
                wasAnythingRendered |= this.renderDown(light0, light1, light2, light3, buffer, atextureatlassprite[0], red0, green0, blue0, red1, green1, blue1, red2, green2, blue2, red3, green3, blue3, x, y, z);
            }
            TextureAtlasSprite atlasSpriteWaterOverlay = this.field_187501_d;
            for (int facingIndex = 0; facingIndex < 4; ++facingIndex) {
                float blue02;
                float blue12;
                float blue22;
                float blue32;
                float green02;
                float green12;
                float green22;
                float green32;
                float red02;
                float red12;
                float red22;
                float red32;
                int light02;
                int light12;
                int light22;
                int light32;
                IBlockState blockstate;
                boolean shouldRenderSide;
                EnumFacing direction;
                double z1;
                double z0;
                double x1;
                double x0;
                float y1;
                float y0;
                if (facingIndex == 0) {
                    y0 = fluidHeight;
                    y1 = fluidHeightEast;
                    x0 = x;
                    x1 = (double)x + 1.0;
                    z0 = z;
                    z1 = z;
                    direction = EnumFacing.NORTH;
                    shouldRenderSide = shouldRenderNorth;
                } else if (facingIndex == 1) {
                    y0 = fluidHeightEastSouth;
                    y1 = fluidHeightSouth;
                    x0 = (double)x + 1.0;
                    x1 = x;
                    z0 = (double)z + 1.0;
                    z1 = (double)z + 1.0;
                    direction = EnumFacing.SOUTH;
                    shouldRenderSide = shouldRenderSouth;
                } else if (facingIndex == 2) {
                    y0 = fluidHeightSouth;
                    y1 = fluidHeight;
                    x0 = x;
                    x1 = x;
                    z0 = (double)z + 1.0;
                    z1 = z;
                    direction = EnumFacing.WEST;
                    shouldRenderSide = shouldRenderWest;
                } else {
                    y0 = fluidHeightEast;
                    y1 = fluidHeightEastSouth;
                    x0 = (double)x + 1.0;
                    x1 = (double)x + 1.0;
                    z0 = z;
                    z1 = (double)z + 1.0;
                    direction = EnumFacing.EAST;
                    shouldRenderSide = shouldRenderEast;
                }
                pooledMutableBlockPos.func_181079_c(x, y, z).func_189536_c(direction);
                if (!shouldRenderSide) continue;
                TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
                if (!isLava && (blockstate = worldIn.func_180495_p((BlockPos)pooledMutableBlockPos)).func_193401_d(worldIn, (BlockPos)pooledMutableBlockPos, direction) == BlockFaceShape.SOLID) {
                    textureatlassprite2 = atlasSpriteWaterOverlay;
                }
                if (isLava) {
                    light32 = 0xF000F0;
                    light22 = 0xF000F0;
                    light12 = 0xF000F0;
                    light02 = 0xF000F0;
                    red32 = 1.0f;
                    red22 = 1.0f;
                    red12 = 1.0f;
                    red02 = 1.0f;
                    green32 = 1.0f;
                    green22 = 1.0f;
                    green12 = 1.0f;
                    green02 = 1.0f;
                    blue32 = 1.0f;
                    blue22 = 1.0f;
                    blue12 = 1.0f;
                    blue02 = 1.0f;
                } else {
                    if (!smoothLighting) {
                        int combinedLightUpMax;
                        light02 = combinedLightUpMax = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos);
                        light12 = combinedLightUpMax;
                        light22 = combinedLightUpMax;
                        light32 = combinedLightUpMax;
                    } else {
                        light02 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_189532_c(x0, (double)((float)y + y0), z0));
                        light12 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_189532_c(x1, (double)((float)y + y1), z1));
                        light22 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_189532_c(x1, (double)y, z1));
                        light32 = this.getCombinedLightUpMax_optimised(worldIn, pooledMutableBlockPos.func_189532_c(x0, (double)y, z0));
                    }
                    if (!colors) {
                        red22 = red32 = red;
                        red12 = red32;
                        red02 = red32;
                        green22 = green32 = green;
                        green12 = green32;
                        green02 = green32;
                        blue22 = blue32 = blue;
                        blue12 = blue32;
                        blue02 = blue32;
                    } else {
                        int waterColor0 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_189532_c(x0, (double)((float)y + y0), z0));
                        red02 = (float)(waterColor0 >> 16 & 0xFF) / 255.0f;
                        green02 = (float)(waterColor0 >> 8 & 0xFF) / 255.0f;
                        blue02 = (float)(waterColor0 & 0xFF) / 255.0f;
                        int waterColor1 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_189532_c(x1, (double)((float)y + y1), z1));
                        red12 = (float)(waterColor1 >> 16 & 0xFF) / 255.0f;
                        green12 = (float)(waterColor1 >> 8 & 0xFF) / 255.0f;
                        blue12 = (float)(waterColor1 & 0xFF) / 255.0f;
                        int waterColor2 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_189532_c(x1, (double)y, z1));
                        red22 = (float)(waterColor2 >> 16 & 0xFF) / 255.0f;
                        green22 = (float)(waterColor2 >> 8 & 0xFF) / 255.0f;
                        blue22 = (float)(waterColor2 & 0xFF) / 255.0f;
                        int waterColor3 = BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pooledMutableBlockPos.func_189532_c(x0, (double)y, z0));
                        red32 = (float)(waterColor3 >> 16 & 0xFF) / 255.0f;
                        green32 = (float)(waterColor3 >> 8 & 0xFF) / 255.0f;
                        blue32 = (float)(waterColor3 & 0xFF) / 255.0f;
                    }
                }
                wasAnythingRendered = this.renderSide(buffer, textureatlassprite2, red02, green02, blue02, red12, green12, blue12, red22, green22, blue22, red32, green32, blue32, facingIndex, y, y0, y1, x0, x1, z0, z1, light02, light12, light22, light32, textureatlassprite2 != atlasSpriteWaterOverlay);
            }
            boolean bl = wasAnythingRendered;
            return bl;
        }
        finally {
            pooledMutableBlockPos.func_185344_t();
            OptiFineCompatibility.PROXY.popShaderThing(buffer);
        }
    }

    public int getCombinedLightUpMax_optimised(IBlockAccess reader, BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int light = reader.func_175626_b((BlockPos)pooledMutableBlockPos, 0);
        int lightUp = reader.func_175626_b((BlockPos)pooledMutableBlockPos.func_189536_c(EnumFacing.UP), 0);
        int blockLight = light & 0xFF;
        int blockLightUp = lightUp & 0xFF;
        int skyLight = light >> 16 & 0xFF;
        int skyLightUp = lightUp >> 16 & 0xFF;
        return (blockLight > blockLightUp ? blockLight : blockLightUp) | (skyLight > skyLightUp ? skyLight : skyLightUp) << 16;
    }

    public float getFluidHeight(IBlockAccess blockAccess, Material blockMaterial, int posX, int posY, int posZ, BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int divisor = 0;
        float height = 0.0f;
        for (int x = 0; x > -2; --x) {
            for (int z = 0; z > -2; --z) {
                pooledMutableBlockPos.func_181079_c(posX + x, posY + 1, posZ + z);
                if (blockAccess.func_180495_p((BlockPos)pooledMutableBlockPos).func_185904_a() == blockMaterial) {
                    return 1.0f;
                }
                pooledMutableBlockPos.func_181079_c(posX + x, posY, posZ + z);
                IBlockState iblockstate = blockAccess.func_180495_p((BlockPos)pooledMutableBlockPos);
                Material material = iblockstate.func_185904_a();
                if (material != blockMaterial) {
                    if (material.func_76220_a()) continue;
                    height += 1.0f;
                    ++divisor;
                    continue;
                }
                int k = (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                if (k >= 8 || k == 0) {
                    height += BlockLiquid.func_149801_b((int)k) * 10.0f;
                    divisor += 10;
                }
                height += BlockLiquid.func_149801_b((int)k);
                ++divisor;
            }
        }
        return 1.0f - height / (float)divisor;
    }

    public boolean renderUp(BufferBuilder buffer, TextureAtlasSprite[] sprites, float red0, float green0, float blue0, float red1, float green1, float blue1, float red2, float green2, float blue2, float red3, float green3, float blue3, double fluidHeight, double fluidHeightSouth, double fluidHeightEastSouth, double fluidHeightEast, double x, double y, double z, int combinedLightUpMax0, int combinedLightUpMax1, int combinedLightUpMax2, int combinedLightUpMax3, boolean shouldRenderUpUndersideFace, Vec3d flowVec, long positionRandom) {
        int blockLight3Check;
        float v3;
        float u3;
        float v2;
        float u1;
        float u2;
        float v1;
        float v0;
        float u0;
        if (flowVec.field_72450_a == 0.0 && flowVec.field_72449_c == 0.0) {
            TextureAtlasSprite stillSprite = sprites[0];
            if (this.textures()) {
                int rand = (int)(positionRandom % 7L);
                switch (rand) {
                    default: {
                        u0 = UVHelper.getMinU(stillSprite);
                        v0 = UVHelper.getMinV(stillSprite);
                        v1 = UVHelper.getMaxV(stillSprite);
                        u2 = UVHelper.getMaxU(stillSprite);
                        break;
                    }
                    case 1: 
                    case 2: {
                        u0 = UVHelper.getMaxU(stillSprite);
                        v0 = UVHelper.getMaxV(stillSprite);
                        v1 = UVHelper.getMinV(stillSprite);
                        u2 = UVHelper.getMinU(stillSprite);
                        break;
                    }
                    case 3: 
                    case 4: {
                        u0 = UVHelper.getMinU(stillSprite);
                        v0 = UVHelper.getMinV(stillSprite);
                        v1 = UVHelper.getMaxV(stillSprite);
                        u2 = UVHelper.getMaxU(stillSprite);
                        break;
                    }
                    case 5: 
                    case 6: {
                        u0 = UVHelper.getMaxU(stillSprite);
                        v0 = UVHelper.getMaxV(stillSprite);
                        v1 = UVHelper.getMinV(stillSprite);
                        u2 = UVHelper.getMinU(stillSprite);
                    }
                }
                u1 = u0;
                v2 = v1;
                u3 = u2;
                v3 = v0;
            } else {
                u0 = UVHelper.getMinU(stillSprite);
                v0 = UVHelper.getMinV(stillSprite);
                u1 = u0;
                v1 = UVHelper.getMaxV(stillSprite);
                u2 = UVHelper.getMaxU(stillSprite);
                v2 = v1;
                u3 = u2;
                v3 = v0;
            }
        } else {
            TextureAtlasSprite flowingSprite = sprites[1];
            float magicAtan2Flow = (float)MathHelper.func_181159_b((double)flowVec.field_72449_c, (double)flowVec.field_72450_a) - 1.5707964f;
            float sinMagicAtan2Flow = MathHelper.func_76126_a((float)magicAtan2Flow) * 0.25f;
            float cosMagicAtan2Flow = MathHelper.func_76134_b((float)magicAtan2Flow) * 0.25f;
            u0 = UVHelper.clampU(flowingSprite.func_94214_a((double)(8.0f + (-cosMagicAtan2Flow - sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            v0 = UVHelper.clampV(flowingSprite.func_94207_b((double)(8.0f + (-cosMagicAtan2Flow + sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            u1 = UVHelper.clampU(flowingSprite.func_94214_a((double)(8.0f + (-cosMagicAtan2Flow + sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            v1 = UVHelper.clampV(flowingSprite.func_94207_b((double)(8.0f + (cosMagicAtan2Flow + sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            u2 = UVHelper.clampU(flowingSprite.func_94214_a((double)(8.0f + (cosMagicAtan2Flow + sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            v2 = UVHelper.clampV(flowingSprite.func_94207_b((double)(8.0f + (cosMagicAtan2Flow - sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            u3 = UVHelper.clampU(flowingSprite.func_94214_a((double)(8.0f + (cosMagicAtan2Flow - sinMagicAtan2Flow) * 16.0f)), flowingSprite);
            v3 = UVHelper.clampV(flowingSprite.func_94207_b((double)(8.0f + (-cosMagicAtan2Flow - sinMagicAtan2Flow) * 16.0f)), flowingSprite);
        }
        int skyLight0 = combinedLightUpMax0 >> 16 & 0xFFFF;
        int blockLight0 = combinedLightUpMax0 & 0xFFFF;
        int skyLight1 = combinedLightUpMax1 >> 16 & 0xFFFF;
        int blockLight1 = combinedLightUpMax1 & 0xFFFF;
        int skyLight2 = combinedLightUpMax2 >> 16 & 0xFFFF;
        int blockLight2 = combinedLightUpMax2 & 0xFFFF;
        int skyLight3 = combinedLightUpMax3 >> 16 & 0xFFFF;
        int blockLight3 = combinedLightUpMax3 & 0xFFFF;
        int skyLight0Check = skyLight0 - 112;
        int skyLight1Check = skyLight1 - 112;
        int skyLight2Check = skyLight2 - 112;
        int skyLight3Check = skyLight3 - 112;
        if (skyLight0 < skyLight1Check) {
            skyLight0 = skyLight1;
        } else if (skyLight0 < skyLight2Check) {
            skyLight0 = skyLight2;
        } else if (skyLight0 < skyLight3Check) {
            skyLight0 = skyLight3;
        }
        if (skyLight1 < skyLight0Check) {
            skyLight1 = skyLight0;
        } else if (skyLight1 < skyLight2Check) {
            skyLight1 = skyLight2;
        } else if (skyLight1 < skyLight3Check) {
            skyLight1 = skyLight3;
        }
        if (skyLight2 < skyLight0Check) {
            skyLight2 = skyLight0;
        } else if (skyLight2 < skyLight1Check) {
            skyLight2 = skyLight1;
        } else if (skyLight2 < skyLight3Check) {
            skyLight2 = skyLight3;
        }
        if (skyLight3 < skyLight0Check) {
            skyLight3 = skyLight0;
        } else if (skyLight3 < skyLight1Check) {
            skyLight3 = skyLight1;
        } else if (skyLight3 < skyLight2Check) {
            skyLight3 = skyLight2;
        }
        int blockLight0Check = blockLight0 == 240 ? 0 : blockLight0 - 208;
        int blockLight1Check = blockLight1 == 240 ? 0 : blockLight1 - 208;
        int blockLight2Check = blockLight2 == 240 ? 0 : blockLight2 - 208;
        int n = blockLight3Check = blockLight3 == 240 ? 0 : blockLight3 - 208;
        if (blockLight0 < blockLight1Check) {
            blockLight0 = blockLight1;
        } else if (blockLight0 < blockLight2Check) {
            blockLight0 = blockLight2;
        } else if (blockLight0 < blockLight3Check) {
            blockLight0 = blockLight3;
        }
        if (blockLight1 < blockLight0Check) {
            blockLight1 = blockLight0;
        } else if (blockLight1 < blockLight2Check) {
            blockLight1 = blockLight2;
        } else if (blockLight1 < blockLight3Check) {
            blockLight1 = blockLight3;
        }
        if (blockLight2 < blockLight0Check) {
            blockLight2 = blockLight0;
        } else if (blockLight2 < blockLight1Check) {
            blockLight2 = blockLight1;
        } else if (blockLight2 < blockLight3Check) {
            blockLight2 = blockLight3;
        }
        if (blockLight3 < blockLight0Check) {
            blockLight3 = blockLight0;
        } else if (blockLight3 < blockLight1Check) {
            blockLight3 = blockLight1;
        } else if (blockLight3 < blockLight2Check) {
            blockLight3 = blockLight2;
        }
        buffer.func_181662_b(x + 0.0, y + fluidHeight, z + 0.0).func_181666_a(red0, green0, blue0, 1.0f).func_187315_a((double)u0, (double)v0).func_187314_a(skyLight0, blockLight0).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + fluidHeightSouth, z + 1.0).func_181666_a(red1, green1, blue1, 1.0f).func_187315_a((double)u1, (double)v1).func_187314_a(skyLight1, blockLight1).func_181675_d();
        buffer.func_181662_b(x + 1.0, y + fluidHeightEastSouth, z + 1.0).func_181666_a(red2, green2, blue2, 1.0f).func_187315_a((double)u2, (double)v2).func_187314_a(skyLight2, blockLight2).func_181675_d();
        buffer.func_181662_b(x + 1.0, y + fluidHeightEast, z + 0.0).func_181666_a(red3, green3, blue3, 1.0f).func_187315_a((double)u3, (double)v3).func_187314_a(skyLight3, blockLight3).func_181675_d();
        if (shouldRenderUpUndersideFace) {
            buffer.func_181662_b(x + 0.0, y + fluidHeight, z + 0.0).func_181666_a(red0, green0, blue0, 1.0f).func_187315_a((double)u0, (double)v0).func_187314_a(skyLight0, blockLight0).func_181675_d();
            buffer.func_181662_b(x + 1.0, y + fluidHeightEast, z + 0.0).func_181666_a(red3, green3, blue3, 1.0f).func_187315_a((double)u3, (double)v3).func_187314_a(skyLight3, blockLight3).func_181675_d();
            buffer.func_181662_b(x + 1.0, y + fluidHeightEastSouth, z + 1.0).func_181666_a(red2, green2, blue2, 1.0f).func_187315_a((double)u2, (double)v2).func_187314_a(skyLight2, blockLight2).func_181675_d();
            buffer.func_181662_b(x + 0.0, y + fluidHeightSouth, z + 1.0).func_181666_a(red1, green1, blue1, 1.0f).func_187315_a((double)u1, (double)v1).func_187314_a(skyLight1, blockLight1).func_181675_d();
        }
        return true;
    }

    public boolean renderSide(BufferBuilder buffer, TextureAtlasSprite textureatlassprite, float red0, float green0, float blue0, float red1, float green1, float blue1, float red2, float green2, float blue2, float red3, float green3, float blue3, int facingIndex, double y, float y0, float y1, double x0, double x1, double z0, double z1, int combinedLightUpMax0, int combinedLightUpMax1, int combinedLightUpMax2, int combinedLightUpMax3, boolean shouldRenderOppositeFace) {
        int blockLight3Check;
        float u0 = UVHelper.getMinU(textureatlassprite);
        float u1 = textureatlassprite.func_94214_a(8.0);
        float v0 = UVHelper.clampV(textureatlassprite.func_94207_b((double)((1.0f - y0) * 16.0f * 0.5f)), textureatlassprite);
        float v1 = UVHelper.clampV(textureatlassprite.func_94207_b((double)((1.0f - y1) * 16.0f * 0.5f)), textureatlassprite);
        float v2 = textureatlassprite.func_94207_b(8.0);
        int skyLight0 = combinedLightUpMax0 >> 16 & 0xFFFF;
        int blockLight0 = combinedLightUpMax0 & 0xFFFF;
        int skyLight1 = combinedLightUpMax1 >> 16 & 0xFFFF;
        int blockLight1 = combinedLightUpMax1 & 0xFFFF;
        int skyLight2 = combinedLightUpMax2 >> 16 & 0xFFFF;
        int blockLight2 = combinedLightUpMax2 & 0xFFFF;
        int skyLight3 = combinedLightUpMax3 >> 16 & 0xFFFF;
        int blockLight3 = combinedLightUpMax3 & 0xFFFF;
        int skyLight0Check = skyLight0 - 112;
        int skyLight1Check = skyLight1 - 112;
        int skyLight2Check = skyLight2 - 112;
        int skyLight3Check = skyLight3 - 112;
        if (skyLight0 < skyLight1Check) {
            skyLight0 = skyLight1;
        } else if (skyLight0 < skyLight2Check) {
            skyLight0 = skyLight2;
        } else if (skyLight0 < skyLight3Check) {
            skyLight0 = skyLight3;
        }
        if (skyLight1 < skyLight0Check) {
            skyLight1 = skyLight0;
        } else if (skyLight1 < skyLight2Check) {
            skyLight1 = skyLight2;
        } else if (skyLight1 < skyLight3Check) {
            skyLight1 = skyLight3;
        }
        if (skyLight2 < skyLight0Check) {
            skyLight2 = skyLight0;
        } else if (skyLight2 < skyLight1Check) {
            skyLight2 = skyLight1;
        } else if (skyLight2 < skyLight3Check) {
            skyLight2 = skyLight3;
        }
        if (skyLight3 < skyLight0Check) {
            skyLight3 = skyLight0;
        } else if (skyLight3 < skyLight1Check) {
            skyLight3 = skyLight1;
        } else if (skyLight3 < skyLight2Check) {
            skyLight3 = skyLight2;
        }
        int blockLight0Check = blockLight0 == 240 ? 0 : blockLight0 - 208;
        int blockLight1Check = blockLight1 == 240 ? 0 : blockLight1 - 208;
        int blockLight2Check = blockLight2 == 240 ? 0 : blockLight2 - 208;
        int n = blockLight3Check = blockLight3 == 240 ? 0 : blockLight3 - 208;
        if (blockLight0 < blockLight1Check) {
            blockLight0 = blockLight1;
        } else if (blockLight0 < blockLight2Check) {
            blockLight0 = blockLight2;
        } else if (blockLight0 < blockLight3Check) {
            blockLight0 = blockLight3;
        }
        if (blockLight1 < blockLight0Check) {
            blockLight1 = blockLight0;
        } else if (blockLight1 < blockLight2Check) {
            blockLight1 = blockLight2;
        } else if (blockLight1 < blockLight3Check) {
            blockLight1 = blockLight3;
        }
        if (blockLight2 < blockLight0Check) {
            blockLight2 = blockLight0;
        } else if (blockLight2 < blockLight1Check) {
            blockLight2 = blockLight1;
        } else if (blockLight2 < blockLight3Check) {
            blockLight2 = blockLight3;
        }
        if (blockLight3 < blockLight0Check) {
            blockLight3 = blockLight0;
        } else if (blockLight3 < blockLight1Check) {
            blockLight3 = blockLight1;
        } else if (blockLight3 < blockLight2Check) {
            blockLight3 = blockLight2;
        }
        float diffuse = facingIndex < 2 ? 0.8f : 0.6f;
        buffer.func_181662_b(x0, y + (double)y0, z0).func_181666_a(diffuse * red0, diffuse * green0, diffuse * blue0, 1.0f).func_187315_a((double)u0, (double)v0).func_187314_a(skyLight0, blockLight0).func_181675_d();
        buffer.func_181662_b(x1, y + (double)y1, z1).func_181666_a(diffuse * red1, diffuse * green1, diffuse * blue1, 1.0f).func_187315_a((double)u1, (double)v1).func_187314_a(skyLight1, blockLight1).func_181675_d();
        buffer.func_181662_b(x1, y + 0.0, z1).func_181666_a(diffuse * red2, diffuse * green2, diffuse * blue2, 1.0f).func_187315_a((double)u1, (double)v2).func_187314_a(skyLight2, blockLight2).func_181675_d();
        buffer.func_181662_b(x0, y + 0.0, z0).func_181666_a(diffuse * red3, diffuse * green3, diffuse * blue3, 1.0f).func_187315_a((double)u0, (double)v2).func_187314_a(skyLight3, blockLight3).func_181675_d();
        if (shouldRenderOppositeFace) {
            buffer.func_181662_b(x0, y + 0.0, z0).func_181666_a(diffuse * red3, diffuse * green3, diffuse * blue3, 1.0f).func_187315_a((double)u0, (double)v2).func_187314_a(skyLight3, blockLight3).func_181675_d();
            buffer.func_181662_b(x1, y + 0.0, z1).func_181666_a(diffuse * red2, diffuse * green2, diffuse * blue2, 1.0f).func_187315_a((double)u1, (double)v2).func_187314_a(skyLight2, blockLight2).func_181675_d();
            buffer.func_181662_b(x1, y + (double)y1, z1).func_181666_a(diffuse * red1, diffuse * green1, diffuse * blue1, 1.0f).func_187315_a((double)u1, (double)v1).func_187314_a(skyLight1, blockLight1).func_181675_d();
            buffer.func_181662_b(x0, y + (double)y0, z0).func_181666_a(diffuse * red0, diffuse * green0, diffuse * blue0, 1.0f).func_187315_a((double)u0, (double)v0).func_187314_a(skyLight0, blockLight0).func_181675_d();
        }
        return true;
    }

    public boolean renderDown(int downCombinedLightUpMax0, int downCombinedLightUpMax1, int downCombinedLightUpMax2, int downCombinedLightUpMax3, BufferBuilder buffer, TextureAtlasSprite textureAtlasSprite, float red0, float green0, float blue0, float red1, float green1, float blue1, float red2, float green2, float blue2, float red3, float green3, float blue3, double x, double y, double z) {
        int blockLight3Check;
        float minU = UVHelper.getMinU(textureAtlasSprite);
        float maxU = UVHelper.getMaxU(textureAtlasSprite);
        float minV = UVHelper.getMinV(textureAtlasSprite);
        float maxV = UVHelper.getMaxV(textureAtlasSprite);
        int skyLight0 = downCombinedLightUpMax0 >> 16 & 0xFFFF;
        int blockLight0 = downCombinedLightUpMax0 & 0xFFFF;
        int skyLight1 = downCombinedLightUpMax1 >> 16 & 0xFFFF;
        int blockLight1 = downCombinedLightUpMax1 & 0xFFFF;
        int skyLight2 = downCombinedLightUpMax2 >> 16 & 0xFFFF;
        int blockLight2 = downCombinedLightUpMax2 & 0xFFFF;
        int skyLight3 = downCombinedLightUpMax3 >> 16 & 0xFFFF;
        int blockLight3 = downCombinedLightUpMax3 & 0xFFFF;
        int skyLight0Check = skyLight0 - 112;
        int skyLight1Check = skyLight1 - 112;
        int skyLight2Check = skyLight2 - 112;
        int skyLight3Check = skyLight3 - 112;
        if (skyLight0 < skyLight1Check) {
            skyLight0 = skyLight1;
        } else if (skyLight0 < skyLight2Check) {
            skyLight0 = skyLight2;
        } else if (skyLight0 < skyLight3Check) {
            skyLight0 = skyLight3;
        }
        if (skyLight1 < skyLight0Check) {
            skyLight1 = skyLight0;
        } else if (skyLight1 < skyLight2Check) {
            skyLight1 = skyLight2;
        } else if (skyLight1 < skyLight3Check) {
            skyLight1 = skyLight3;
        }
        if (skyLight2 < skyLight0Check) {
            skyLight2 = skyLight0;
        } else if (skyLight2 < skyLight1Check) {
            skyLight2 = skyLight1;
        } else if (skyLight2 < skyLight3Check) {
            skyLight2 = skyLight3;
        }
        if (skyLight3 < skyLight0Check) {
            skyLight3 = skyLight0;
        } else if (skyLight3 < skyLight1Check) {
            skyLight3 = skyLight1;
        } else if (skyLight3 < skyLight2Check) {
            skyLight3 = skyLight2;
        }
        int blockLight0Check = blockLight0 == 240 ? 0 : blockLight0 - 208;
        int blockLight1Check = blockLight1 == 240 ? 0 : blockLight1 - 208;
        int blockLight2Check = blockLight2 == 240 ? 0 : blockLight2 - 208;
        int n = blockLight3Check = blockLight3 == 240 ? 0 : blockLight3 - 208;
        if (blockLight0 < blockLight1Check) {
            blockLight0 = blockLight1;
        } else if (blockLight0 < blockLight2Check) {
            blockLight0 = blockLight2;
        } else if (blockLight0 < blockLight3Check) {
            blockLight0 = blockLight3;
        }
        if (blockLight1 < blockLight0Check) {
            blockLight1 = blockLight0;
        } else if (blockLight1 < blockLight2Check) {
            blockLight1 = blockLight2;
        } else if (blockLight1 < blockLight3Check) {
            blockLight1 = blockLight3;
        }
        if (blockLight2 < blockLight0Check) {
            blockLight2 = blockLight0;
        } else if (blockLight2 < blockLight1Check) {
            blockLight2 = blockLight1;
        } else if (blockLight2 < blockLight3Check) {
            blockLight2 = blockLight3;
        }
        if (blockLight3 < blockLight0Check) {
            blockLight3 = blockLight0;
        } else if (blockLight3 < blockLight1Check) {
            blockLight3 = blockLight1;
        } else if (blockLight3 < blockLight2Check) {
            blockLight3 = blockLight2;
        }
        buffer.func_181662_b(x, y, z + 1.0).func_181666_a(0.5f * red0, 0.5f * green0, 0.5f * blue0, 1.0f).func_187315_a((double)minU, (double)maxV).func_187314_a(skyLight0, blockLight0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_181666_a(0.5f * red1, 0.5f * green1, 0.5f * blue1, 1.0f).func_187315_a((double)minU, (double)minV).func_187314_a(skyLight1, blockLight1).func_181675_d();
        buffer.func_181662_b(x + 1.0, y, z).func_181666_a(0.5f * red2, 0.5f * green2, 0.5f * blue2, 1.0f).func_187315_a((double)maxU, (double)minV).func_187314_a(skyLight2, blockLight2).func_181675_d();
        buffer.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(0.5f * red3, 0.5f * green3, 0.5f * blue3, 1.0f).func_187315_a((double)maxU, (double)maxV).func_187314_a(skyLight3, blockLight3).func_181675_d();
        return true;
    }

    public boolean smoothLighting() {
        return Config.smoothFluidLighting;
    }

    public boolean colors() {
        return Config.smoothFluidColors;
    }

    public boolean textures() {
        return Config.naturalFluidTextures;
    }
}

