/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.ClientCacheUtil;
import io.github.cadiboo.nocubes.client.LazyBlockColorCache;
import io.github.cadiboo.nocubes.client.LazyPackedLightCache;
import io.github.cadiboo.nocubes.client.UVHelper;
import io.github.cadiboo.nocubes.client.render.ExtendedFluidChunkRenderer;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.mesh.MeshDispatcher;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.mesh.generator.OldNoCubes;
import io.github.cadiboo.nocubes.util.CacheUtil;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.Vec3b;
import io.github.cadiboo.nocubes.util.pooled.cache.DensityCache;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;

public final class RenderDispatcher {
    private static final Predicate<IBlockState> IS_BLOCK_STATE_GRASS = blockState -> ModUtil.isMaterialGrass(blockState.func_185904_a());
    private static final Predicate<IBlockState> IS_BLOCK_STATE_LEAVES = blockState -> ModUtil.isMaterialLeaves(blockState.func_185904_a());
    private static final Predicate<IBlockState> ALWAYS_TRUE = blockState -> true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderChunk(@Nonnull RenderChunk chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkCompileTaskGenerator chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull World world, @Nonnull IBlockAccess chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher) {
        MeshGenerator meshGenerator;
        int chunkRenderPosX = chunkRenderPos.func_177958_n();
        int chunkRenderPosY = chunkRenderPos.func_177956_o();
        int chunkRenderPosZ = chunkRenderPos.func_177952_p();
        int stateCachePaddingX = 0;
        int stateCachePaddingY = 0;
        int stateCachePaddingZ = 0;
        int stateCacheEndX = 0;
        int stateCacheEndY = 0;
        int stateCacheEndZ = 0;
        if (Config.renderSmoothTerrain) {
            meshGenerator = Config.terrainMeshGenerator.getMeshGenerator();
            stateCacheEndX = Math.max(stateCacheEndX, ModUtil.getMeshSizeX(17, meshGenerator));
            stateCacheEndY = Math.max(stateCacheEndY, ModUtil.getMeshSizeY(17, meshGenerator));
            stateCacheEndZ = Math.max(stateCacheEndZ, ModUtil.getMeshSizeZ(17, meshGenerator));
            stateCachePaddingX = Math.max(stateCachePaddingX, 1);
            stateCachePaddingY = Math.max(stateCachePaddingY, 1);
            stateCachePaddingZ = Math.max(stateCachePaddingZ, 1);
        }
        if (Config.renderSmoothLeaves) {
            meshGenerator = Config.leavesMeshGenerator.getMeshGenerator();
            stateCacheEndX = Math.max(stateCacheEndX, ModUtil.getMeshSizeX(17, meshGenerator));
            stateCacheEndY = Math.max(stateCacheEndY, ModUtil.getMeshSizeY(17, meshGenerator));
            stateCacheEndZ = Math.max(stateCacheEndZ, ModUtil.getMeshSizeZ(17, meshGenerator));
            stateCachePaddingX = Math.max(stateCachePaddingX, 1);
            stateCachePaddingY = Math.max(stateCachePaddingY, 1);
            stateCachePaddingZ = Math.max(stateCachePaddingZ, 1);
        }
        if (Config.renderSmoothTerrain || Config.renderSmoothLeaves) {
            stateCacheEndX = Math.max(stateCacheEndX, 18);
            stateCacheEndY = Math.max(stateCacheEndY, 18);
            stateCacheEndZ = Math.max(stateCacheEndZ, 18);
            stateCachePaddingX = Math.max(stateCachePaddingX, 2);
            stateCachePaddingY = Math.max(stateCachePaddingY, 2);
            stateCachePaddingZ = Math.max(stateCachePaddingZ, 2);
        }
        BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            try (StateCache stateCache = CacheUtil.generateStateCache(chunkRenderPosX - stateCachePaddingX, chunkRenderPosY - stateCachePaddingY, chunkRenderPosZ - stateCachePaddingZ, chunkRenderPosX + stateCacheEndX, chunkRenderPosY + stateCacheEndY, chunkRenderPosZ + stateCacheEndZ, stateCachePaddingX, stateCachePaddingY, stateCachePaddingZ, world, pooledMutableBlockPos);
                 LazyPackedLightCache lazyPackedLightCache = ClientCacheUtil.generateLazyPackedLightCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, stateCache, chunkRenderCache);){
                byte meshSizeZ;
                byte meshSizeY;
                byte meshSizeX;
                MeshGenerator meshGenerator2;
                if (Config.renderSmoothTerrain) {
                    meshGenerator2 = Config.terrainMeshGenerator.getMeshGenerator();
                    meshSizeX = ModUtil.getMeshSizeX(17, meshGenerator2);
                    meshSizeY = ModUtil.getMeshSizeY(17, meshGenerator2);
                    meshSizeZ = ModUtil.getMeshSizeZ(17, meshGenerator2);
                    try (SmoothableCache smoothableCache = CacheUtil.generateSmoothableCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX, chunkRenderPosY + meshSizeY, chunkRenderPosZ + meshSizeZ, 1, 1, 1, stateCache, IsSmoothable.TERRAIN_SMOOTHABLE);
                         DensityCache densityCache = CacheUtil.generateDensityCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX - 1, chunkRenderPosY + meshSizeY - 1, chunkRenderPosZ + meshSizeZ - 1, 1, 1, 1, stateCache, smoothableCache);){
                        ExtendedFluidChunkRenderer.renderChunk(chunkRender, chunkRenderTask, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, pooledMutableBlockPos, usedBlockRenderLayers, blockRendererDispatcher, stateCache, smoothableCache, lazyPackedLightCache);
                        RenderDispatcher.renderTerrainChunk(chunkRender, chunkRenderPos, chunkRenderTask, compiledChunk, chunkRenderCache, usedBlockRenderLayers, random, blockRendererDispatcher, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos, stateCache, lazyPackedLightCache, meshGenerator2, meshSizeX, meshSizeY, meshSizeZ, smoothableCache, densityCache);
                    }
                }
                if (Config.renderSmoothLeaves) {
                    meshGenerator2 = Config.leavesMeshGenerator.getMeshGenerator();
                    meshSizeX = ModUtil.getMeshSizeX(17, meshGenerator2);
                    meshSizeY = ModUtil.getMeshSizeY(17, meshGenerator2);
                    meshSizeZ = ModUtil.getMeshSizeZ(17, meshGenerator2);
                    RenderDispatcher.renderLeavesChunk(chunkRender, chunkRenderPos, chunkRenderTask, compiledChunk, chunkRenderCache, usedBlockRenderLayers, random, blockRendererDispatcher, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, pooledMutableBlockPos, stateCache, lazyPackedLightCache, meshGenerator2, meshSizeX, meshSizeY, meshSizeZ);
                }
            }
            finally {
                pooledMutableBlockPos.func_185344_t();
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Error rendering NoCubes chunk!");
            crashReport.func_85058_a("Rendering chunk");
            throw new ReportedException(crashReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderTerrainChunk(@Nonnull RenderChunk chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkCompileTaskGenerator chunkRenderTask, @Nonnull CompiledChunk compiledChunk, @Nonnull IBlockAccess chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, StateCache stateCache, LazyPackedLightCache lazyPackedLightCache, MeshGenerator meshGenerator, byte meshSizeX, byte meshSizeY, byte meshSizeZ, SmoothableCache smoothableCache, DensityCache densityCache) {
        BlockPos.PooledMutableBlockPos texturePooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try (LazyBlockColorCache lazyBlockColorCache = ClientCacheUtil.generateLazyBlockColorCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, BiomeColorHelper.field_180291_a, IS_BLOCK_STATE_GRASS);){
            HashMap<Vec3b, FaceList> mesh = Config.terrainMeshGenerator == MeshGeneratorType.OldNoCubes ? OldNoCubes.generateChunk(chunkRenderPos, chunkRenderCache, IsSmoothable.TERRAIN_SMOOTHABLE, pooledMutableBlockPos) : MeshDispatcher.offsetChunkMesh(chunkRenderPos, meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ}));
            MeshRenderer.renderMesh(chunkRender, chunkRenderTask, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, stateCache, blockRendererDispatcher, random, lazyPackedLightCache, lazyBlockColorCache, mesh, smoothableCache, pooledMutableBlockPos, texturePooledMutableBlockPos, usedBlockRenderLayers, false, true, true);
        }
        finally {
            texturePooledMutableBlockPos.func_185344_t();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void renderLeavesChunk(@Nonnull RenderChunk chunkRender, @Nonnull BlockPos chunkRenderPos, @Nonnull ChunkCompileTaskGenerator generator, @Nonnull CompiledChunk compiledChunk, @Nonnull IBlockAccess chunkRenderCache, @Nonnull boolean[] usedBlockRenderLayers, @Nonnull Random random, @Nonnull BlockRendererDispatcher blockRendererDispatcher, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, BlockPos.PooledMutableBlockPos pooledMutableBlockPos, StateCache stateCache, LazyPackedLightCache lazyPackedLightCache, MeshGenerator meshGenerator, byte meshSizeX, byte meshSizeY, byte meshSizeZ) {
        texturePooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            lazyBlockColorCache = ClientCacheUtil.generateLazyBlockColorCache(chunkRenderPosX - 2, chunkRenderPosY - 2, chunkRenderPosZ - 2, chunkRenderPosX + 18, chunkRenderPosY + 18, chunkRenderPosZ + 18, 2, 2, 2, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, BiomeColorHelper.field_180289_b, RenderDispatcher.IS_BLOCK_STATE_LEAVES);
            var20_20 = null;
            try {
                switch (1.$SwitchMap$io$github$cadiboo$nocubes$util$SmoothLeavesType[Config.smoothLeavesType.ordinal()]) {
                    case 1: {
                        for (Block smoothableBlock : Config.leavesSmoothableBlocks) {
                            isSmoothable = (IsSmoothable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/block/state/IBlockState;)Z, lambda$renderLeavesChunk$3(net.minecraft.block.Block net.minecraft.block.state.IBlockState ), (Lnet/minecraft/block/state/IBlockState;)Z)((Block)smoothableBlock);
                            smoothableCache = CacheUtil.generateSmoothableCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX, chunkRenderPosY + meshSizeY, chunkRenderPosZ + meshSizeZ, 1, 1, 1, stateCache, isSmoothable);
                            var25_32 = null;
                            try {
                                densityCache = CacheUtil.generateDensityCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX - 1, chunkRenderPosY + meshSizeY - 1, chunkRenderPosZ + meshSizeZ - 1, 1, 1, 1, stateCache, smoothableCache);
                                var27_40 = null;
                                try {
                                    mesh = Config.leavesMeshGenerator == MeshGeneratorType.OldNoCubes ? OldNoCubes.generateChunk(chunkRenderPos, chunkRenderCache, isSmoothable, pooledMutableBlockPos) : MeshDispatcher.offsetChunkMesh(chunkRenderPos, meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ}));
                                    MeshRenderer.renderMesh(chunkRender, generator, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, stateCache, blockRendererDispatcher, random, lazyPackedLightCache, lazyBlockColorCache, mesh, smoothableCache, pooledMutableBlockPos, texturePooledMutableBlockPos, usedBlockRenderLayers, true, true, false);
                                }
                                catch (Throwable var28_43) {
                                    var27_40 = var28_43;
                                    throw var28_43;
                                }
                                finally {
                                    if (densityCache == null) continue;
                                    if (var27_40 != null) {
                                        try {
                                            densityCache.close();
                                        }
                                        catch (Throwable var28_42) {
                                            var27_40.addSuppressed(var28_42);
                                        }
                                        continue;
                                    }
                                    densityCache.close();
                                }
                            }
                            catch (Throwable densityCache) {
                                var25_32 = densityCache;
                                throw densityCache;
                            }
                            finally {
                                if (smoothableCache == null) continue;
                                if (var25_32 != null) {
                                    try {
                                        smoothableCache.close();
                                    }
                                    catch (Throwable densityCache) {
                                        var25_32.addSuppressed(densityCache);
                                    }
                                    continue;
                                }
                                smoothableCache.close();
                            }
                        }
                        break;
                    }
                    case 2: {
                        isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
                        smoothableCache = CacheUtil.generateSmoothableCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX, chunkRenderPosY + meshSizeY, chunkRenderPosZ + meshSizeZ, 1, 1, 1, stateCache, isSmoothable);
                        var23_27 = null;
                        densityCache = CacheUtil.generateDensityCache(chunkRenderPosX - 1, chunkRenderPosY - 1, chunkRenderPosZ - 1, chunkRenderPosX + meshSizeX - 1, chunkRenderPosY + meshSizeY - 1, chunkRenderPosZ + meshSizeZ - 1, 1, 1, 1, stateCache, smoothableCache);
                        var25_33 = null;
                        try {
                            mesh = Config.leavesMeshGenerator == MeshGeneratorType.OldNoCubes ? OldNoCubes.generateChunk(chunkRenderPos, chunkRenderCache, isSmoothable, pooledMutableBlockPos) : MeshDispatcher.offsetChunkMesh(chunkRenderPos, meshGenerator.generateChunk(densityCache.getDensityCache(), new byte[]{meshSizeX, meshSizeY, meshSizeZ}));
                            MeshRenderer.renderMesh(chunkRender, generator, compiledChunk, chunkRenderPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, chunkRenderCache, stateCache, blockRendererDispatcher, random, lazyPackedLightCache, lazyBlockColorCache, mesh, smoothableCache, pooledMutableBlockPos, texturePooledMutableBlockPos, usedBlockRenderLayers, true, true, false);
                        }
                        catch (Throwable var26_39) {
                            var25_33 = var26_39;
                            throw var26_39;
                        }
                        finally {
                            if (densityCache != null) {
                                if (var25_33 != null) {
                                    try {
                                        densityCache.close();
                                    }
                                    catch (Throwable var26_38) {
                                        var25_33.addSuppressed(var26_38);
                                    }
                                } else {
                                    densityCache.close();
                                }
                            }
                        }
                        if (smoothableCache == null) ** break;
                        if (var23_27 == null) ** GOTO lbl83
                        try {
                            smoothableCache.close();
                            ** break;
lbl78:
                            // 1 sources

                        }
                        catch (Throwable var24_30) {
                            var23_27.addSuppressed(var24_30);
                            ** break;
                        }
lbl82:
                        // 1 sources

                        break;
lbl83:
                        // 1 sources

                        smoothableCache.close();
                        ** break;
lbl85:
                        // 1 sources

                        break;
                        catch (Throwable var24_31) {
                            try {
                                var23_27 = var24_31;
                                throw var24_31;
                            }
                            catch (Throwable var35_50) {
                                if (smoothableCache != null) {
                                    if (var23_27 != null) {
                                        try {
                                            smoothableCache.close();
                                        }
                                        catch (Throwable var36_51) {
                                            var23_27.addSuppressed(var36_51);
                                        }
                                    } else {
                                        smoothableCache.close();
                                    }
                                }
                                throw var35_50;
                            }
                        }
                    }
                    ** default:
lbl102:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable var21_23) {
                var20_20 = var21_23;
                throw var21_23;
            }
            finally {
                if (lazyBlockColorCache != null) {
                    if (var20_20 != null) {
                        try {
                            lazyBlockColorCache.close();
                        }
                        catch (Throwable var21_22) {
                            var20_20.addSuppressed(var21_22);
                        }
                    } else {
                        lazyBlockColorCache.close();
                    }
                }
            }
        }
        finally {
            texturePooledMutableBlockPos.func_185344_t();
        }
    }

    public static void renderSmoothBlockDamage(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, BlockPos blockpos, IBlockState iblockstate, IBlockAccess world, TextureAtlasSprite textureatlassprite) {
        MeshGeneratorType meshGeneratorType;
        IsSmoothable isSmoothable;
        if (iblockstate.func_185901_i() != EnumBlockRenderType.MODEL) {
            return;
        }
        if (Config.renderSmoothTerrain && IsSmoothable.TERRAIN_SMOOTHABLE.test(iblockstate)) {
            isSmoothable = IsSmoothable.TERRAIN_SMOOTHABLE;
            meshGeneratorType = Config.terrainMeshGenerator;
        } else if (Config.renderSmoothLeaves && IsSmoothable.LEAVES_SMOOTHABLE.test(iblockstate)) {
            isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
            meshGeneratorType = Config.leavesMeshGenerator;
        } else {
            return;
        }
        tessellatorIn.func_78381_a();
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        try (FaceList faces = MeshDispatcher.generateBlockMeshOffset(blockpos, world, isSmoothable, meshGeneratorType);){
            float minU = UVHelper.getMinU(textureatlassprite);
            float maxU = UVHelper.getMaxU(textureatlassprite);
            float minV = UVHelper.getMinV(textureatlassprite);
            float maxV = UVHelper.getMaxV(textureatlassprite);
            int packed = iblockstate.func_185889_a(world, blockpos);
            int lightmapSkyLight = packed >> 16 & 0xFFFF;
            int lightmapBlockLight = packed & 0xFFFF;
            int facesSize = faces.size();
            for (int faceIndex = 0; faceIndex < facesSize; ++faceIndex) {
                try (Face face = (Face)faces.get(faceIndex);
                     Vec3 v0 = face.getVertex0();
                     Vec3 v1 = face.getVertex1();
                     Vec3 v2 = face.getVertex2();
                     Vec3 v3 = face.getVertex3();){
                    bufferBuilderIn.func_181662_b(v0.x, v0.y, v0.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)minU, (double)minV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    bufferBuilderIn.func_181662_b(v1.x, v1.y, v1.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)minU, (double)maxV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    bufferBuilderIn.func_181662_b(v2.x, v2.y, v2.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)maxU, (double)maxV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    bufferBuilderIn.func_181662_b(v3.x, v3.y, v3.z).func_181669_b(255, 255, 255, 255).func_187315_a((double)maxU, (double)minV).func_187314_a(lightmapSkyLight, lightmapBlockLight).func_181675_d();
                    continue;
                }
            }
        }
        tessellatorIn.func_78381_a();
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilderIn.func_78914_f();
    }

    private static /* synthetic */ boolean lambda$renderLeavesChunk$3(Block smoothableBlock, IBlockState checkState) {
        return IsSmoothable.LEAVES_SMOOTHABLE.test(checkState) && checkState.func_177230_c() == smoothableBlock;
    }
}

