/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.optifine;

import io.github.cadiboo.nocubes.NoCubes;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;

public final class OptiFineLocator {
    public static final String SUPPORTED_SERIES = "HD_U_F";

    @Nullable
    static Class<?> findConfigClass() {
        Class<?> config;
        try {
            config = Class.forName("net.optifine.Config");
        }
        catch (ClassNotFoundException failedToFindModernConfigClass) {
            try {
                config = Class.forName("Config");
            }
            catch (ClassNotFoundException failedToFindLegacyConfigClass) {
                NoCubes.LOGGER.info("OptiFineCompatibility: OptiFine not detected.");
                return null;
            }
        }
        NoCubes.LOGGER.info("OptiFineCompatibility: Found OptiFine!");
        return config;
    }

    @Nullable
    public static String getOptiFineVersion() {
        Class<?> configClass = OptiFineLocator.findConfigClass();
        return configClass == null ? null : OptiFineLocator.getOptiFineVersion(configClass);
    }

    @Nonnull
    private static String getOptiFineVersion(Class<?> configClass) {
        try {
            Field versionField = configClass.getField("VERSION");
            versionField.setAccessible(true);
            return (String)versionField.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Problem getting OptiFine version");
            crashReport.func_85058_a("NoCubes OptiFine Locator");
            throw new ReportedException(crashReport);
        }
    }

    public static boolean isOptiFineInstalled() {
        return OptiFineLocator.findConfigClass() != null;
    }
}

