/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.gui.toast;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.render.BufferBuilderCache;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.util.vector.Vector3f;

public abstract class BlockStateToast
implements IToast {
    private static final Matrix4f ITEM_CAMERA_TRANSFORM_MATRIX = TRSRTransformation.from((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(-30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f))).getMatrix();
    @Nonnull
    private final BufferBuilderCache bufferCache = new BufferBuilderCache(512, 512, 512, 512);
    @Nonnull
    private final boolean[] usedBlockRenderLayers = new boolean[ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH];
    @Nonnull
    private final String name;

    BlockStateToast(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.name = I18n.func_135052_a((String)state.func_177230_c().func_149739_a(), (Object[])new Object[0]);
        this.build(state, pos, (IBlockAccess)minecraft.field_71441_e, minecraft.func_175602_ab(), new Random());
    }

    private static void drawBuffer(@Nonnull BufferBuilder bufferBuilderIn) {
        if (bufferBuilderIn.func_178989_h() > 0) {
            VertexFormat vertexformat = bufferBuilderIn.func_178973_g();
            int i = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = bufferBuilderIn.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (int j = 0; j < list.size(); ++j) {
                VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                bytebuffer.position(vertexformat.func_181720_d(j));
                vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, bytebuffer);
            }
            GlStateManager.func_187439_f((int)bufferBuilderIn.func_178979_i(), (int)0, (int)bufferBuilderIn.func_178989_h());
            int j1 = list.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, bytebuffer);
            }
        }
    }

    private void build(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull IBlockAccess reader, @Nonnull BlockRendererDispatcher blockRendererDispatcher, @Nonnull Random random) {
        if (state.func_185901_i() != EnumBlockRenderType.MODEL) {
            return;
        }
        boolean[] startedBufferBuilders = new boolean[ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH];
        BlockModelRenderer blockModelRenderer = blockRendererDispatcher.func_175019_b();
        for (int i = 0; i < ClientUtil.BLOCK_RENDER_LAYER_VALUES_LENGTH; ++i) {
            BlockRenderLayer blockRenderLayer = ClientUtil.BLOCK_RENDER_LAYER_VALUES[i];
            if (!state.func_177230_c().canRenderInLayer(state, blockRenderLayer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockRenderLayer);
            int blockRenderLayerId = blockRenderLayer.ordinal();
            BufferBuilder bufferBuilder = this.bufferCache.get(blockRenderLayerId);
            if (!startedBufferBuilders[blockRenderLayerId]) {
                startedBufferBuilders[blockRenderLayerId] = true;
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                bufferBuilder.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            }
            int n = blockRenderLayerId;
            this.usedBlockRenderLayers[n] = this.usedBlockRenderLayers[n] | blockModelRenderer.func_187493_a(reader, blockRendererDispatcher.func_184389_a(state), state, pos, bufferBuilder, false, MathHelper.func_180186_a((Vec3i)pos));
        }
        ForgeHooksClient.setRenderLayer(null);
        for (int blockRenderLayerId = 0; blockRenderLayerId < this.usedBlockRenderLayers.length; ++blockRenderLayerId) {
            if (!startedBufferBuilders[blockRenderLayerId]) continue;
            this.bufferCache.get(blockRenderLayerId).func_178977_d();
        }
    }

    public abstract String getUpdateType();

    @Nonnull
    public IToast.Visibility func_193653_a(@Nonnull GuiToast toastGui, long delta) {
        Minecraft minecraft = toastGui.func_192989_b();
        minecraft.func_110434_K().func_110577_a(field_193654_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.func_73729_b(0, 0, 0, 0, 160, 32);
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)this.getUpdateType(), (Object[])new Object[0]) + ":", 30, 7, -1);
        minecraft.field_71466_p.func_78276_b(this.name, 30, 18, -1);
        Entity entity = minecraft.func_175606_aa();
        if (entity != null) {
            minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            minecraft.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)7.0f, (float)21.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
            RenderHelper.func_74520_c();
            ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)ITEM_CAMERA_TRANSFORM_MATRIX);
            for (int blockRenderLayerId = 0; blockRenderLayerId < this.usedBlockRenderLayers.length; ++blockRenderLayerId) {
                if (!this.usedBlockRenderLayers[blockRenderLayerId]) continue;
                BlockStateToast.drawBuffer(this.bufferCache.get(blockRenderLayerId));
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            minecraft.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
        return delta >= 10000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    public static final class RemoveLeaves
    extends BlockStateToast {
        public RemoveLeaves(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.removedLeavesSmoothableBlockState";
        }
    }

    public static final class AddLeaves
    extends BlockStateToast {
        public AddLeaves(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.addedLeavesSmoothableBlockState";
        }
    }

    public static final class RemoveTerrain
    extends BlockStateToast {
        public RemoveTerrain(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.removedTerrainSmoothableBlockState";
        }
    }

    public static final class AddTerrain
    extends BlockStateToast {
        public AddTerrain(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
            super(state, pos);
        }

        @Override
        public String getUpdateType() {
            return "nocubes.addedTerrainSmoothableBlockState";
        }
    }
}

