/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.gui.config;

import com.google.common.base.Joiner;
import io.github.cadiboo.nocubes.client.gui.config.BooleanOption;
import io.github.cadiboo.nocubes.client.gui.config.EnumOption;
import io.github.cadiboo.nocubes.client.gui.config.LazyLoadBase;
import io.github.cadiboo.nocubes.client.gui.config.ListOption;
import io.github.cadiboo.nocubes.client.gui.config.NoCubesConfigGui;
import io.github.cadiboo.nocubes.client.gui.config.OptionButton;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.config.ConfigHolder;
import io.github.cadiboo.nocubes.config.ForgeConfigSpec;
import io.github.cadiboo.nocubes.config.ModConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;

final class ConfigOptionsList
extends GuiListExtended {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    final List<Entry> entries;
    private final NoCubesConfigGui configGui;
    private final int maxListLabelWidth;

    public ConfigOptionsList(NoCubesConfigGui configGui, Minecraft mcIn) {
        super(mcIn, configGui.field_146294_l + 45, configGui.field_146295_m, 43, configGui.field_146295_m - 32, 20);
        this.configGui = configGui;
        this.entries = new ArrayList<Entry>();
        this.entries.add(new CategoryEntry("nocubes.config.client"));
        this.getConfigValues(ConfigHolder.CLIENT).forEach((configValue, name) -> {
            ValueEntry<?> e = this.createValueEntry((ForgeConfigSpec.ConfigValue<?>)configValue, (String)name, () -> ConfigHelper.clientConfig);
            this.entries.add(e);
        });
        if (this.field_148161_k.field_71441_e != null && this.field_148161_k.func_71401_C() != null) {
            this.entries.add(new CategoryEntry("nocubes.config.server"));
            this.getConfigValues(ConfigHolder.SERVER).forEach((configValue, name) -> {
                ValueEntry<?> e = this.createValueEntry((ForgeConfigSpec.ConfigValue<?>)configValue, (String)name, () -> ConfigHelper.serverConfig);
                this.entries.add(e);
            });
        }
        FontRenderer fontRenderer = mcIn.field_71466_p;
        int maxListLabelWidth = 0;
        for (Entry entry : this.entries) {
            int i = fontRenderer.func_78256_a(entry.getTranslatedText());
            if (i <= maxListLabelWidth) continue;
            maxListLabelWidth = i;
        }
        this.maxListLabelWidth = maxListLabelWidth;
    }

    private static void saveValue(ForgeConfigSpec.ConfigValue<?> configValue, Supplier<ModConfig> configSupplier, Object newValue) {
        ConfigHelper.setValueAndSave(configSupplier.get(), DOT_JOINER.join(configValue.getPath()), newValue);
    }

    @Nonnull
    private ValueEntry<?> createValueEntry(ForgeConfigSpec.ConfigValue<?> configValue, String name, Supplier<ModConfig> configSupplier) {
        if (configValue instanceof ForgeConfigSpec.BooleanValue) {
            return new BooleanValueEntry((ForgeConfigSpec.BooleanValue)configValue, name, configSupplier);
        }
        if (configValue instanceof ForgeConfigSpec.EnumValue) {
            return new EnumValueEntry((ForgeConfigSpec.EnumValue)configValue, name, configSupplier);
        }
        try {
            return new ListValueEntry(configValue, name, configSupplier);
        }
        catch (Exception e) {
            return new NotImplementedValueEntry(configValue, name, configSupplier);
        }
    }

    private Map<ForgeConfigSpec.ConfigValue<?>, String> getConfigValues(Object config) {
        HashMap configValuesAndNames = new HashMap();
        for (Field declaredField : config.getClass().getDeclaredFields()) {
            declaredField.setAccessible(true);
            try {
                Object o = declaredField.get(config);
                if (!(o instanceof ForgeConfigSpec.ConfigValue)) continue;
                configValuesAndNames.put((ForgeConfigSpec.ConfigValue)o, declaredField.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return configValuesAndNames;
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    public int func_148139_c() {
        return super.func_148139_c() + 150;
    }

    public int func_148137_d() {
        return super.func_148137_d() + 15 + 20;
    }

    boolean saveChanged() {
        boolean wasAnythingSaved = false;
        for (Entry entry : this.entries) {
            if (entry instanceof ValueEntry) {
                ValueEntry valueEntry = (ValueEntry)entry;
                if (!valueEntry.isChanged()) continue;
                ConfigOptionsList.saveValue(valueEntry.configValue, valueEntry.configSupplier, valueEntry.currentValue);
                wasAnythingSaved = true;
                continue;
            }
            if (!(entry instanceof CategoryEntry)) continue;
            CategoryEntry categoryEntry = (CategoryEntry)entry;
        }
        return wasAnythingSaved;
    }

    public void keyTyped(char eventChar, int eventKey) {
        for (Entry entry : this.entries) {
            entry.keyTyped(eventChar, eventKey);
        }
    }

    public void mouseClickedPassThru(int mouseX, int mouseY, int mouseEvent) {
        for (Entry entry : this.entries) {
            entry.mouseClicked(mouseX, mouseY, mouseEvent);
        }
    }

    public void updateScreen() {
        for (Entry entry : this.entries) {
            entry.updateCursorCounter();
        }
    }

    private final class NotImplementedValueEntry<T>
    extends ValueEntry<T> {
        NotImplementedValueEntry(ForgeConfigSpec.ConfigValue<T> configValue, String name, Supplier<ModConfig> configSupplier) {
            super(configValue, name, configSupplier);
        }

        protected OptionButton makeWidget() {
            OptionButton widget = new BooleanOption(this.text, () -> false, this::handleChanged){

                @Override
                public String getTranslatedName() {
                    return this.getDisplayString() + I18n.func_135052_a((String)"commands.scoreboard.objectives.add.wrongType", (Object[])new Object[]{NotImplementedValueEntry.this.getTranslatedText()});
                }
            }.createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.field_146294_l / 4 * 3);
            widget.packedFGColour = 0xFF0000;
            return widget;
        }

        @Override
        private void handleChanged(Boolean ignored) {
        }
    }

    final class ListValueEntry<T>
    extends ValueEntry<List<? extends T>> {
        ListValueEntry(ForgeConfigSpec.ConfigValue<List<? extends T>> listValue, String name, Supplier<ModConfig> configSupplier) {
            super(listValue, name, configSupplier);
        }

        protected GuiTextField makeWidget() {
            return new ListOption(this.text, () -> (String[])((List)this.currentValue).stream().map(Object::toString).toArray(String[]::new), this::handleChanged).createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.field_146294_l / 4 * 3);
        }

        @Override
        private void handleChanged(String[] newValue) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : newValue) {
                list.add(str);
            }
            this.handleChanged(list);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            ((GuiTextField)this.widgetSupplier.getValue()).func_146201_a(eventChar, eventKey);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseEvent) {
            ((GuiTextField)this.widgetSupplier.getValue()).func_146192_a(mouseX, mouseY, mouseEvent);
        }

        @Override
        public void updateCursorCounter() {
            ((GuiTextField)this.widgetSupplier.getValue()).func_146178_a();
        }
    }

    final class EnumValueEntry<T extends Enum<T>>
    extends ValueEntry<T> {
        final T[] values;

        EnumValueEntry(ForgeConfigSpec.EnumValue<T> enumValue, String name, Supplier<ModConfig> configSupplier) {
            super(enumValue, name, configSupplier);
            this.values = (Enum[])((Enum)this.initialValue).getDeclaringClass().getEnumConstants();
        }

        private int cycle(int ordinal) {
            int i = (ordinal + 1) % this.values.length;
            this.handleChanged(this.values[i]);
            return i;
        }

        private String getTranslatedText(EnumOption enumOption) {
            return enumOption.getDisplayString() + ((Enum)this.currentValue).name();
        }

        protected OptionButton makeWidget() {
            return new EnumOption(this.text, this::cycle, this::getTranslatedText, ((Enum)this.currentValue).ordinal()).createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.field_146294_l / 4 * 3);
        }
    }

    final class BooleanValueEntry
    extends ValueEntry<Boolean> {
        BooleanValueEntry(ForgeConfigSpec.BooleanValue booleanValue, String name, Supplier<ModConfig> configSupplier) {
            super(booleanValue, name, configSupplier);
        }

        @Override
        protected Gui makeWidget() {
            return new BooleanOption(this.text, () -> (Boolean)this.currentValue, this::handleChanged).createWidget(((ConfigOptionsList)ConfigOptionsList.this).configGui.field_146294_l / 4 * 3);
        }
    }

    abstract class ValueEntry<T>
    extends Entry {
        final ForgeConfigSpec.ConfigValue<T> configValue;
        final String text;
        final int initialHash;
        final T initialValue;
        final Supplier<ModConfig> configSupplier;
        final LazyLoadBase<Gui> widgetSupplier;
        T currentValue;

        private ValueEntry(ForgeConfigSpec.ConfigValue<T> configValue, String name, Supplier<ModConfig> configSupplier) {
            this.configValue = configValue;
            this.text = I18n.func_135052_a((String)("nocubes.config." + name), (Object[])new Object[0]);
            this.configSupplier = configSupplier;
            T value = configValue.get();
            this.initialValue = value;
            this.currentValue = this.initialValue;
            this.initialHash = Objects.hashCode(value);
            this.widgetSupplier = new LazyLoadBase<Gui>(this::makeWidget);
        }

        protected abstract Gui makeWidget();

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            Gui widget = this.widgetSupplier.getValue();
            if (widget instanceof GuiTextField) {
                GuiTextField ihate1122 = (GuiTextField)widget;
                ihate1122.field_146209_f = x + 2;
                ihate1122.field_146210_g = y + 2;
                ihate1122.func_146194_f();
            } else {
                OptionButton ihate1122 = (OptionButton)widget;
                ihate1122.field_146128_h = x;
                ihate1122.field_146129_i = y;
                ihate1122.func_191745_a(ConfigOptionsList.this.field_148161_k, mouseX, mouseY, partialTicks);
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            Gui value = this.widgetSupplier.getValue();
            if (value instanceof GuiTextField) {
                return ((GuiTextField)value).func_146192_a(mouseX, mouseY, 0);
            }
            return ((OptionButton)value).func_146116_c(ConfigOptionsList.this.field_148161_k, mouseX, mouseY);
        }

        @Override
        String getTranslatedText() {
            return this.text;
        }

        void handleChanged(T newValue) {
            this.currentValue = newValue;
        }

        public boolean isChanged() {
            return this.initialHash != Objects.hashCode(this.currentValue);
        }
    }

    final class CategoryEntry
    extends Entry {
        private final String labelText;
        private final int labelWidth;

        CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((ConfigOptionsList)ConfigOptionsList.this).field_148161_k.field_71466_p.func_78256_a(this.labelText);
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            ((ConfigOptionsList)ConfigOptionsList.this).field_148161_k.field_71466_p.func_78276_b("Category: " + this.labelText, ((ConfigOptionsList)ConfigOptionsList.this).configGui.field_146294_l / 2 - this.labelWidth, y + slotHeight - 9 - 1, 0xFFFFFF);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        @Override
        String getTranslatedText() {
            return this.labelText;
        }
    }

    static abstract class Entry
    implements GuiListExtended.IGuiListEntry {
        Entry() {
        }

        abstract String getTranslatedText();

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        public void keyTyped(char eventChar, int eventKey) {
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseEvent) {
        }

        public void updateCursorCounter() {
        }
    }
}

