/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.StateHolder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public final class ModelHelper {
    public static final EnumFacing[] DIRECTION_QUADS_ORDERED = new EnumFacing[]{EnumFacing.UP, null, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    public static final int DIRECTION_QUADS_ORDERED_LENGTH = DIRECTION_QUADS_ORDERED.length;

    @Nullable
    public static List<BakedQuad> getQuads(IBlockState state, BlockPos pos, BufferBuilder bufferBuilder, IBlockAccess reader, BlockRendererDispatcher blockRendererDispatcher, long posRandLong, BlockRenderLayer blockRenderLayer) {
        IBakedModel model = ModelHelper.getModel(state, blockRendererDispatcher);
        Object renderEnv = null;
        if (OptiFineCompatibility.ENABLED) {
            renderEnv = OptiFineCompatibility.PROXY.getRenderEnv(bufferBuilder, state, pos);
            model = OptiFineCompatibility.PROXY.getRenderModel(model, state, renderEnv);
        }
        try (ModProfiler ignored = ModProfiler.get().start("getExtendedState");){
            state = state.func_177230_c().getExtendedState(state, reader, pos);
        }
        for (int directionIndex = 0; directionIndex < DIRECTION_QUADS_ORDERED_LENGTH; ++directionIndex) {
            EnumFacing direction = DIRECTION_QUADS_ORDERED[directionIndex];
            List<BakedQuad> quads = model.func_188616_a(state, direction, posRandLong);
            if (quads.isEmpty()) continue;
            if (OptiFineCompatibility.ENABLED) {
                try (ModProfiler ignored = ModProfiler.get().start("getRenderQuads");){
                    quads = OptiFineCompatibility.PROXY.getRenderQuads(quads, reader, state, pos, direction, blockRenderLayer, posRandLong, renderEnv);
                    if (quads.isEmpty()) {
                        continue;
                    }
                }
            }
            return quads;
        }
        return null;
    }

    @Nonnull
    public static IBakedModel getModel(IBlockState state, BlockRendererDispatcher blockRendererDispatcher) {
        try (ModProfiler ignored = ModProfiler.get().start("getModel");){
            if (ClientUtil.isStateSnow(state)) {
                IBakedModel iBakedModel = blockRendererDispatcher.func_184389_a(StateHolder.SNOW_LAYER_DEFAULT);
                return iBakedModel;
            }
            IBakedModel iBakedModel = blockRendererDispatcher.func_184389_a(state);
            return iBakedModel;
        }
    }
}

