/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.client.LazyPackedLightCache;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public final class LightmapInfo
implements AutoCloseable {
    private static final ThreadLocal<LightmapInfo> POOL = ThreadLocal.withInitial(() -> new LightmapInfo(0, 0, 0, 0, 0, 0, 0, 0));
    public int skylight0;
    public int skylight1;
    public int skylight2;
    public int skylight3;
    public int blocklight0;
    public int blocklight1;
    public int blocklight2;
    public int blocklight3;
    private boolean inUse;

    private LightmapInfo(int skylight0, int skylight1, int skylight2, int skylight3, int blocklight0, int blocklight1, int blocklight2, int blocklight3) {
        this.skylight0 = skylight0;
        this.skylight1 = skylight1;
        this.skylight2 = skylight2;
        this.skylight3 = skylight3;
        this.blocklight0 = blocklight0;
        this.blocklight1 = blocklight1;
        this.blocklight2 = blocklight2;
        this.blocklight3 = blocklight3;
        this.inUse = false;
    }

    public static LightmapInfo generateLightmapInfo(@Nonnull LazyPackedLightCache lazyPackedLightCache, @Nonnull Vec3 v0, @Nonnull Vec3 v1, @Nonnull Vec3 v2, Vec3 v3, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        try (ModProfiler ignored = ModProfiler.get().start("generateLightmapInfo");){
            switch (Minecraft.func_71410_x().field_71474_y.field_74348_k) {
                case 0: {
                    LightmapInfo lightmapInfo = LightmapInfo.generateLightmapInfoFlat(v0, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyPackedLightCache, pooledMutableBlockPos);
                    return lightmapInfo;
                }
                default: {
                    LightmapInfo lightmapInfo = LightmapInfo.generateLightmapInfoSmooth(v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyPackedLightCache, pooledMutableBlockPos);
                    return lightmapInfo;
                }
                case 2: 
            }
            LightmapInfo lightmapInfo = LightmapInfo.generateLightmapInfoSmoothAO(v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, lazyPackedLightCache, pooledMutableBlockPos);
            return lightmapInfo;
        }
    }

    private static LightmapInfo generateLightmapInfoSmoothAO(@Nonnull Vec3 v0, @Nonnull Vec3 v1, @Nonnull Vec3 v2, @Nonnull Vec3 v3, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull LazyPackedLightCache packedLightCache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        return LightmapInfo.generateLightmapInfoSmooth(v0, v1, v2, v3, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, packedLightCache, pooledMutableBlockPos);
    }

    private static LightmapInfo generateLightmapInfoSmooth(@Nonnull Vec3 v0, @Nonnull Vec3 v1, @Nonnull Vec3 v2, @Nonnull Vec3 v3, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull LazyPackedLightCache lazyPackedLightCache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int[] packedLight0 = new int[27];
        int[] packedLight1 = new int[27];
        int[] packedLight2 = new int[27];
        int[] packedLight3 = new int[27];
        int v0XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.x) - chunkRenderPosX), (int)-1, (int)16);
        int v0YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.y) - chunkRenderPosY), (int)-1, (int)16);
        int v0ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.z) - chunkRenderPosZ), (int)-1, (int)16);
        int v1XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v1.x) - chunkRenderPosX), (int)-1, (int)16);
        int v1YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v1.y) - chunkRenderPosY), (int)-1, (int)16);
        int v1ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v1.z) - chunkRenderPosZ), (int)-1, (int)16);
        int v2XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v2.x) - chunkRenderPosX), (int)-1, (int)16);
        int v2YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v2.y) - chunkRenderPosY), (int)-1, (int)16);
        int v2ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v2.z) - chunkRenderPosZ), (int)-1, (int)16);
        int v3XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v3.x) - chunkRenderPosX), (int)-1, (int)16);
        int v3YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v3.y) - chunkRenderPosY), (int)-1, (int)16);
        int v3ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v3.z) - chunkRenderPosZ), (int)-1, (int)16);
        int[] cache = lazyPackedLightCache.cache;
        StateCache stateCache = lazyPackedLightCache.stateCache;
        int sizeX = lazyPackedLightCache.sizeX;
        int sizeY = lazyPackedLightCache.sizeY;
        IBlockAccess reader = lazyPackedLightCache.reader;
        int startPaddingX = lazyPackedLightCache.startPaddingX;
        int startPaddingZ = lazyPackedLightCache.startPaddingZ;
        int startPaddingY = lazyPackedLightCache.startPaddingY;
        int diffX = stateCache.startPaddingX - startPaddingX;
        int diffY = stateCache.startPaddingY - startPaddingY;
        int diffZ = stateCache.startPaddingZ - startPaddingZ;
        int stateCacheSizeX = stateCache.sizeX;
        int stateCacheSizeY = stateCache.sizeY;
        int index = 0;
        for (int zOffset = 0; zOffset < 3; ++zOffset) {
            for (int yOffset = 0; yOffset < 3; ++yOffset) {
                int xOffset = 0;
                while (xOffset < 3) {
                    int x0 = v0XOffset + xOffset;
                    int y0 = v0YOffset + yOffset;
                    int z0 = v0ZOffset + zOffset;
                    packedLight0[index] = LazyPackedLightCache.get(x0, y0, z0, cache, lazyPackedLightCache.getIndex(x0, y0, z0, sizeX, sizeY), stateCache, reader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, stateCacheSizeX, stateCacheSizeY);
                    int x1 = v1XOffset + xOffset;
                    int y1 = v1YOffset + yOffset;
                    int z1 = v1ZOffset + zOffset;
                    packedLight1[index] = LazyPackedLightCache.get(x1, y1, z1, cache, lazyPackedLightCache.getIndex(x1, y1, z1, sizeX, sizeY), stateCache, reader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, stateCacheSizeX, stateCacheSizeY);
                    int x2 = v2XOffset + xOffset;
                    int y2 = v2YOffset + yOffset;
                    int z2 = v2ZOffset + zOffset;
                    packedLight2[index] = LazyPackedLightCache.get(x2, y2, z2, cache, lazyPackedLightCache.getIndex(x2, y2, z2, sizeX, sizeY), stateCache, reader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, stateCacheSizeX, stateCacheSizeY);
                    int x3 = v3XOffset + xOffset;
                    int y3 = v3YOffset + yOffset;
                    int z3 = v3ZOffset + zOffset;
                    packedLight3[index] = LazyPackedLightCache.get(x3, y3, z3, cache, lazyPackedLightCache.getIndex(x3, y3, z3, sizeX, sizeY), stateCache, reader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ, stateCacheSizeX, stateCacheSizeY);
                    ++xOffset;
                    ++index;
                }
            }
        }
        int skylight0 = LightmapInfo.getSkylight(packedLight0);
        int skylight1 = LightmapInfo.getSkylight(packedLight1);
        int skylight2 = LightmapInfo.getSkylight(packedLight2);
        int skylight3 = LightmapInfo.getSkylight(packedLight3);
        int blocklight0 = LightmapInfo.getBlocklight(packedLight0);
        int blocklight1 = LightmapInfo.getBlocklight(packedLight1);
        int blocklight2 = LightmapInfo.getBlocklight(packedLight2);
        int blocklight3 = LightmapInfo.getBlocklight(packedLight3);
        return LightmapInfo.retain(skylight0, skylight1, skylight2, skylight3, blocklight0, blocklight1, blocklight2, blocklight3);
    }

    private static LightmapInfo generateLightmapInfoFlat(@Nonnull Vec3 v0, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, @Nonnull LazyPackedLightCache lazyPackedLightCache, @Nonnull BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        int v0XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.x) - chunkRenderPosX), (int)-1, (int)16);
        int v0YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.y) - chunkRenderPosY), (int)-1, (int)16);
        int v0ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.z) - chunkRenderPosZ), (int)-1, (int)16);
        int[] packedLight0 = new int[27];
        int[] cache = lazyPackedLightCache.cache;
        StateCache stateCache = lazyPackedLightCache.stateCache;
        IBlockAccess reader = lazyPackedLightCache.reader;
        int startPaddingX = lazyPackedLightCache.startPaddingX;
        int startPaddingY = lazyPackedLightCache.startPaddingY;
        int startPaddingZ = lazyPackedLightCache.startPaddingZ;
        int diffX = stateCache.startPaddingX - startPaddingX;
        int diffY = stateCache.startPaddingY - startPaddingY;
        int diffZ = stateCache.startPaddingZ - startPaddingZ;
        int index = 0;
        for (int zOffset = 0; zOffset < 3; ++zOffset) {
            for (int yOffset = 0; yOffset < 3; ++yOffset) {
                int xOffset = 0;
                while (xOffset < 3) {
                    packedLight0[index] = lazyPackedLightCache.get(v0XOffset + xOffset, v0YOffset + yOffset, v0ZOffset + zOffset, cache, stateCache, reader, (BlockPos.MutableBlockPos)pooledMutableBlockPos, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, startPaddingX, startPaddingY, startPaddingZ, diffX, diffY, diffZ);
                    ++xOffset;
                    ++index;
                }
            }
        }
        int skylight0 = LightmapInfo.getSkylight(packedLight0);
        int blocklight0 = LightmapInfo.getBlocklight(packedLight0);
        return LightmapInfo.retain(skylight0, skylight0, skylight0, skylight0, blocklight0, blocklight0, blocklight0, blocklight0);
    }

    private static int getSkylight(int[] packedLight) {
        return LightmapInfo.max(packedLight[0] >> 16 & 0xFFFF, packedLight[1] >> 16 & 0xFFFF, packedLight[2] >> 16 & 0xFFFF, packedLight[3] >> 16 & 0xFFFF, packedLight[4] >> 16 & 0xFFFF, packedLight[5] >> 16 & 0xFFFF, packedLight[6] >> 16 & 0xFFFF, packedLight[7] >> 16 & 0xFFFF, packedLight[8] >> 16 & 0xFFFF, packedLight[9] >> 16 & 0xFFFF, packedLight[10] >> 16 & 0xFFFF, packedLight[11] >> 16 & 0xFFFF, packedLight[12] >> 16 & 0xFFFF, packedLight[13] >> 16 & 0xFFFF, packedLight[14] >> 16 & 0xFFFF, packedLight[15] >> 16 & 0xFFFF, packedLight[16] >> 16 & 0xFFFF, packedLight[17] >> 16 & 0xFFFF, packedLight[18] >> 16 & 0xFFFF, packedLight[19] >> 16 & 0xFFFF, packedLight[20] >> 16 & 0xFFFF, packedLight[21] >> 16 & 0xFFFF, packedLight[22] >> 16 & 0xFFFF, packedLight[23] >> 16 & 0xFFFF, packedLight[24] >> 16 & 0xFFFF, packedLight[25] >> 16 & 0xFFFF, packedLight[26] >> 16 & 0xFFFF);
    }

    private static int getBlocklight(int[] packedLight) {
        return LightmapInfo.max(packedLight[0] & 0xFFFF, packedLight[1] & 0xFFFF, packedLight[2] & 0xFFFF, packedLight[3] & 0xFFFF, packedLight[4] & 0xFFFF, packedLight[5] & 0xFFFF, packedLight[6] & 0xFFFF, packedLight[7] & 0xFFFF, packedLight[8] & 0xFFFF, packedLight[9] & 0xFFFF, packedLight[10] & 0xFFFF, packedLight[11] & 0xFFFF, packedLight[12] & 0xFFFF, packedLight[13] & 0xFFFF, packedLight[14] & 0xFFFF, packedLight[15] & 0xFFFF, packedLight[16] & 0xFFFF, packedLight[17] & 0xFFFF, packedLight[18] & 0xFFFF, packedLight[19] & 0xFFFF, packedLight[20] & 0xFFFF, packedLight[21] & 0xFFFF, packedLight[22] & 0xFFFF, packedLight[23] & 0xFFFF, packedLight[24] & 0xFFFF, packedLight[25] & 0xFFFF, packedLight[26] & 0xFFFF);
    }

    private static int max(int i0, int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9, int i10, int i11, int i12, int i13, int i14, int i15, int i16, int i17, int i18, int i19, int i20, int i21, int i22, int i23, int i24, int i25, int i26) {
        if (i1 > i0) {
            i0 = i1;
        }
        if (i2 > i0) {
            i0 = i2;
        }
        if (i3 > i0) {
            i0 = i3;
        }
        if (i4 > i0) {
            i0 = i4;
        }
        if (i5 > i0) {
            i0 = i5;
        }
        if (i6 > i0) {
            i0 = i6;
        }
        if (i7 > i0) {
            i0 = i7;
        }
        if (i8 > i0) {
            i0 = i8;
        }
        if (i9 > i0) {
            i0 = i9;
        }
        if (i10 > i0) {
            i0 = i10;
        }
        if (i11 > i0) {
            i0 = i11;
        }
        if (i12 > i0) {
            i0 = i12;
        }
        if (i13 > i0) {
            i0 = i13;
        }
        if (i14 > i0) {
            i0 = i14;
        }
        if (i15 > i0) {
            i0 = i15;
        }
        if (i16 > i0) {
            i0 = i16;
        }
        if (i17 > i0) {
            i0 = i17;
        }
        if (i18 > i0) {
            i0 = i18;
        }
        if (i19 > i0) {
            i0 = i19;
        }
        if (i20 > i0) {
            i0 = i20;
        }
        if (i21 > i0) {
            i0 = i21;
        }
        if (i22 > i0) {
            i0 = i22;
        }
        if (i23 > i0) {
            i0 = i23;
        }
        if (i24 > i0) {
            i0 = i24;
        }
        if (i25 > i0) {
            i0 = i25;
        }
        return i0 > i26 ? i0 : i26;
    }

    public static LightmapInfo retain(int skylight0, int skylight1, int skylight2, int skylight3, int blocklight0, int blocklight1, int blocklight2, int blocklight3) {
        LightmapInfo pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("LightmapInfo is already in use!");
        }
        pooled.inUse = true;
        pooled.skylight0 = skylight0;
        pooled.skylight1 = skylight1;
        pooled.skylight2 = skylight2;
        pooled.skylight3 = skylight3;
        pooled.blocklight0 = blocklight0;
        pooled.blocklight1 = blocklight1;
        pooled.blocklight2 = blocklight2;
        pooled.blocklight3 = blocklight3;
        return pooled;
    }

    @Override
    public void close() {
        this.inUse = false;
    }
}

