/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientEventSubscriber;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.client.optifine.OptiFineLocator;
import io.github.cadiboo.nocubes.client.render.SmoothLightingFluidBlockRenderer;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.StateHolder;
import io.github.cadiboo.nocubes.util.pooled.cache.SmoothableCache;
import io.github.cadiboo.nocubes.util.pooled.cache.StateCache;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;

public final class ClientUtil {
    public static final BlockRenderLayer[] BLOCK_RENDER_LAYER_VALUES = BlockRenderLayer.values();
    public static final int BLOCK_RENDER_LAYER_VALUES_LENGTH = BLOCK_RENDER_LAYER_VALUES.length;
    static final int[] NEGATIVE_1_8000 = new int[8000];
    private static final int[][] OFFSETS_ORDERED = new int[][]{{0, -1, 0}, {0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {-1, -1, 0}, {-1, 0, -1}, {-1, 0, 1}, {-1, 1, 0}, {0, -1, -1}, {0, -1, 1}, {0, 1, -1}, {0, 1, 1}, {1, -1, 0}, {1, 0, -1}, {1, 0, 1}, {1, 1, 0}, {1, 1, 1}, {1, 1, -1}, {-1, 1, 1}, {-1, 1, -1}, {1, -1, 1}, {1, -1, -1}, {-1, -1, 1}, {-1, -1, -1}};
    private static final Field BLOCK_COLOR_MAP;

    @Nonnull
    public static IBlockState getTexturePosAndState(int posX, int posY, int posZ, @Nonnull BlockPos.PooledMutableBlockPos texturePooledMutablePos, @Nonnull StateCache stateCache, @Nonnull SmoothableCache smoothableCache, byte relativePosX, byte relativePosY, byte relativePosZ, boolean tryForBetterTexturesSnow, boolean tryForBetterTexturesGrass) {
        boolean[] smoothableCacheArray = smoothableCache.getSmoothableCache();
        IBlockState[] blockCacheArray = stateCache.getBlockStates();
        int stateCacheStartPaddingX = stateCache.startPaddingX;
        int stateCacheStartPaddingY = stateCache.startPaddingY;
        int stateCacheStartPaddingZ = stateCache.startPaddingZ;
        int stateCacheSizeX = stateCache.sizeX;
        int stateCacheSizeY = stateCache.sizeY;
        if (Config.betterTextures) {
            Throwable throwable;
            ModProfiler ignored;
            if (tryForBetterTexturesSnow) {
                ignored = ModProfiler.get().start("getTexturePosAndState-tryForBetterTextures-snow");
                throwable = null;
                try {
                    IBlockState betterTextureState2 = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                    if (ClientUtil.isStateSnow(betterTextureState2)) {
                        texturePooledMutablePos.func_181079_c(posX, posY, posZ);
                        IBlockState iBlockState = betterTextureState2;
                        return iBlockState;
                    }
                    for (int[] offset : OFFSETS_ORDERED) {
                        betterTextureState2 = blockCacheArray[stateCache.getIndex(relativePosX + offset[0] + stateCacheStartPaddingX, relativePosY + offset[1] + stateCacheStartPaddingY, relativePosZ + offset[2] + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                        if (!ClientUtil.isStateSnow(betterTextureState2)) continue;
                        texturePooledMutablePos.func_181079_c(posX + offset[0], posY + offset[1], posZ + offset[2]);
                        IBlockState iBlockState = betterTextureState2;
                        return iBlockState;
                    }
                }
                catch (Throwable betterTextureState2) {
                    throwable = betterTextureState2;
                    throw betterTextureState2;
                }
                finally {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
            }
            if (tryForBetterTexturesGrass) {
                ignored = ModProfiler.get().start("getTexturePosAndState-tryForBetterTextures-grass");
                throwable = null;
                try {
                    IBlockState betterTextureState3 = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                    if (ClientUtil.isStateGrass(betterTextureState3)) {
                        texturePooledMutablePos.func_181079_c(posX, posY, posZ);
                        IBlockState iBlockState = betterTextureState3;
                        return iBlockState;
                    }
                    for (int[] offset : OFFSETS_ORDERED) {
                        betterTextureState3 = blockCacheArray[stateCache.getIndex(relativePosX + offset[0] + stateCacheStartPaddingX, relativePosY + offset[1] + stateCacheStartPaddingY, relativePosZ + offset[2] + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                        if (!ClientUtil.isStateGrass(betterTextureState3)) continue;
                        texturePooledMutablePos.func_181079_c(posX + offset[0], posY + offset[1], posZ + offset[2]);
                        IBlockState iBlockState = betterTextureState3;
                        return iBlockState;
                    }
                }
                catch (Throwable betterTextureState3) {
                    throwable = betterTextureState3;
                    throw betterTextureState3;
                }
                finally {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
            }
        }
        int smoothableCacheStartPaddingX = smoothableCache.startPaddingX;
        int smoothableCacheStartPaddingY = smoothableCache.startPaddingY;
        int smoothableCacheStartPaddingZ = smoothableCache.startPaddingZ;
        int n = smoothableCache.sizeX;
        int smoothableCacheSizeY = smoothableCache.sizeY;
        try (ModProfiler ignored = ModProfiler.get().start("getTexturePosAndState");){
            if (smoothableCacheArray[smoothableCache.getIndex(relativePosX + smoothableCacheStartPaddingX, relativePosY + smoothableCacheStartPaddingY, relativePosZ + smoothableCacheStartPaddingZ, n, smoothableCacheSizeY)]) {
                texturePooledMutablePos.func_181079_c(posX, posY, posZ);
                IBlockState iBlockState = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                return iBlockState;
            }
            IBlockState state = blockCacheArray[stateCache.getIndex(relativePosX + stateCacheStartPaddingX, relativePosY + stateCacheStartPaddingY, relativePosZ + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
            for (int[] offset : OFFSETS_ORDERED) {
                if (!smoothableCacheArray[smoothableCache.getIndex(relativePosX + offset[0] + smoothableCacheStartPaddingX, relativePosY + offset[1] + smoothableCacheStartPaddingY, relativePosZ + offset[2] + smoothableCacheStartPaddingZ, n, smoothableCacheSizeY)]) continue;
                texturePooledMutablePos.func_181079_c(posX + offset[0], posY + offset[1], posZ + offset[2]);
                state = blockCacheArray[stateCache.getIndex(relativePosX + offset[0] + stateCacheStartPaddingX, relativePosY + offset[1] + stateCacheStartPaddingY, relativePosZ + offset[2] + stateCacheStartPaddingZ, stateCacheSizeX, stateCacheSizeY)];
                break;
            }
            IBlockState iBlockState = state;
            return iBlockState;
        }
    }

    public static boolean isStateSnow(IBlockState checkState) {
        if (checkState == StateHolder.SNOW_LAYER_DEFAULT) {
            return true;
        }
        if (checkState == StateHolder.GRASS_BLOCK_SNOWY) {
            return true;
        }
        return checkState == StateHolder.PODZOL_SNOWY;
    }

    private static boolean isStateGrass(IBlockState checkState) {
        return checkState == StateHolder.GRASS_BLOCK_DEFAULT;
    }

    @Nonnull
    @Deprecated
    public static BlockRenderLayer getCorrectRenderLayer(@Nonnull IBlockState state) {
        return ClientUtil.getCorrectRenderLayer(state.func_177230_c().func_180664_k());
    }

    @Nonnull
    public static BlockRenderLayer getCorrectRenderLayer(@Nonnull BlockRenderLayer blockRenderLayer) {
        switch (blockRenderLayer) {
            default: {
                return blockRenderLayer;
            }
            case CUTOUT_MIPPED: {
                return Minecraft.func_71410_x().field_71474_y.field_151442_I == 0 ? BlockRenderLayer.CUTOUT : BlockRenderLayer.CUTOUT_MIPPED;
            }
            case CUTOUT: 
        }
        return Minecraft.func_71410_x().field_71474_y.field_151442_I != 0 ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.CUTOUT;
    }

    public static BufferBuilder startOrContinueBufferBuilder(ChunkCompileTaskGenerator generator, int blockRenderLayerOrdinal, CompiledChunk compiledChunk, BlockRenderLayer blockRenderLayer, RenderChunk chunkRender, BlockPos renderChunkPosition) {
        BufferBuilder bufferBuilder = generator.func_178545_d().func_179039_a(blockRenderLayerOrdinal);
        if (!compiledChunk.func_178492_d(blockRenderLayer)) {
            compiledChunk.func_178493_c(blockRenderLayer);
            chunkRender.func_178573_a(bufferBuilder, renderChunkPosition);
        }
        return bufferBuilder;
    }

    public static void tryReloadRenderers() {
        RenderGlobal worldRenderer = Minecraft.func_71410_x().field_71438_f;
        if (worldRenderer != null) {
            worldRenderer.func_72712_a();
        }
    }

    public static Chunk getChunk(int currentChunkPosX, int currentChunkPosZ, IBlockAccess reader) {
        if (reader instanceof ChunkCache) {
            ChunkCache renderChunkCache = (ChunkCache)reader;
            int x = currentChunkPosX - renderChunkCache.field_72818_a;
            int z = currentChunkPosZ - renderChunkCache.field_72816_b;
            return renderChunkCache.field_72817_c[x][z];
        }
        if (OptiFineCompatibility.PROXY.isChunkCacheOF(reader)) {
            ChunkCache renderChunkCache = OptiFineCompatibility.PROXY.getChunkRenderCache(reader);
            int x = currentChunkPosX - renderChunkCache.field_72818_a;
            int z = currentChunkPosZ - renderChunkCache.field_72816_b;
            return renderChunkCache.field_72817_c[x][z];
        }
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)new IllegalStateException(), (String)("Invalid ChunkRenderCache: " + reader));
        crashReport.func_85058_a("NoCubes getting Chunk");
        throw new ReportedException(crashReport);
    }

    public static void replaceFluidRenderer() {
        NoCubes.LOGGER.debug("Replacing fluid renderer");
        ClientEventSubscriber.smoothLightingBlockFluidRenderer = new SmoothLightingFluidBlockRenderer();
        Minecraft.func_71410_x().func_175602_ab().field_175025_e = ClientEventSubscriber.smoothLightingBlockFluidRenderer;
        NoCubes.LOGGER.debug("Replaced fluid renderer");
    }

    public static void crashIfIncompatibleOptiFine() {
        final String optiFineVersion = OptiFineLocator.getOptiFineVersion();
        String message = "Incompatible OptiFine version detected! Please use the HD_U_F series (Installed: " + optiFineVersion + ")";
        throw new CustomModLoadingErrorDisplayException(message, new IllegalStateException(message)){
            private final String[] lines;
            {
                super(x0, x1);
                this.lines = new String[]{"Incompatible OptiFine version detected!", "Please use the HD_U_F series", "(Installed: " + optiFineVersion + ")"};
            }

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
            }

            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
                int x = errorScreen.field_146294_l / 2;
                int y = errorScreen.field_146295_m / 2 / 2;
                String[] lines = this.lines;
                int linesLength = lines.length;
                for (int i = 0; i < linesLength; ++i) {
                    errorScreen.func_73732_a(fontRenderer, lines[i], x, y + i * 10, 0xFFFFFF);
                }
            }
        };
    }

    public static void crashIfRCRCHInstalled() {
        String message = "NoCubes Dependency Error! RenderChunk rebuildChunk Hooks CANNOT be installed! Remove RenderChunk rebuildChunk Hooks from the mods folder and then restart the game.";
        throw new CustomModLoadingErrorDisplayException("NoCubes Dependency Error! RenderChunk rebuildChunk Hooks CANNOT be installed! Remove RenderChunk rebuildChunk Hooks from the mods folder and then restart the game.", new IllegalStateException("NoCubes Dependency Error! RenderChunk rebuildChunk Hooks CANNOT be installed! Remove RenderChunk rebuildChunk Hooks from the mods folder and then restart the game.")){
            private final String[] lines = new String[]{"NoCubes Dependency Error!", "", "RenderChunk rebuildChunk Hooks CANNOT be installed!", "", "Remove RenderChunk rebuildChunk Hooks from", "the mods folder and then restart the game."};

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
            }

            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
                int x = errorScreen.field_146294_l / 2;
                int y = errorScreen.field_146295_m / 2 / 2;
                String[] lines = this.lines;
                int linesLength = lines.length;
                for (int i = 0; i < linesLength; ++i) {
                    errorScreen.func_73732_a(fontRenderer, lines[i], x, y + i * 10, 0xFFFFFF);
                }
            }
        };
    }

    public static void markBlocksForUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately) {
        RenderGlobal worldRenderer = Minecraft.func_71410_x().field_71438_f;
        if (worldRenderer != null && worldRenderer.field_72769_h != null && worldRenderer.field_175008_n != null) {
            worldRenderer.func_184385_a(minX, minY, minZ, maxX, maxY, maxZ, updateImmediately);
        }
    }

    public static Map<IRegistryDelegate<Block>, IBlockColor> getBlockColorsMap() {
        try {
            return (Map)BLOCK_COLOR_MAP.get(Minecraft.func_71410_x().func_184125_al());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException while getting the BlockColorsMap... how? It should have been made accessible", e);
        }
    }

    static {
        Arrays.fill(NEGATIVE_1_8000, -1);
        BLOCK_COLOR_MAP = ObfuscationReflectionHelper.findField(BlockColors.class, (String)"blockColorMap");
    }
}

