/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.BlockColorInfo;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.gui.toast.BlockStateToast;
import io.github.cadiboo.nocubes.client.render.SmoothLightingFluidBlockRenderer;
import io.github.cadiboo.nocubes.config.Config;
import io.github.cadiboo.nocubes.config.ConfigHelper;
import io.github.cadiboo.nocubes.config.ConfigTracker;
import io.github.cadiboo.nocubes.mesh.MeshDispatcher;
import io.github.cadiboo.nocubes.mesh.MeshGeneratorType;
import io.github.cadiboo.nocubes.network.C2SRequestAddTerrainSmoothable;
import io.github.cadiboo.nocubes.network.C2SRequestDisableTerrainCollisions;
import io.github.cadiboo.nocubes.network.C2SRequestEnableTerrainCollisions;
import io.github.cadiboo.nocubes.network.C2SRequestRemoveTerrainSmoothable;
import io.github.cadiboo.nocubes.util.IsSmoothable;
import io.github.cadiboo.nocubes.util.ModProfiler;
import io.github.cadiboo.nocubes.util.Profiler1122;
import io.github.cadiboo.nocubes.util.pooled.Face;
import io.github.cadiboo.nocubes.util.pooled.FaceList;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetworkManager;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="nocubes", value={Side.CLIENT})
public final class ClientEventSubscriber {
    private static final String CATEGORY = "key.categories.nocubes";
    private static final KeyBinding toggleRenderSmoothTerrain = new KeyBinding("nocubes.key.toggleRenderSmoothTerrain", 24, "key.categories.nocubes");
    private static final KeyBinding toggleRenderSmoothLeaves = new KeyBinding("nocubes.key.toggleRenderSmoothLeaves", 23, "key.categories.nocubes");
    private static final KeyBinding toggleProfilers = new KeyBinding("nocubes.key.toggleProfilers", 25, "key.categories.nocubes");
    private static final KeyBinding toggleTerrainSmoothableBlockState = new KeyBinding("nocubes.key.toggleTerrainSmoothableBlockState", 49, "key.categories.nocubes");
    private static final KeyBinding toggleLeavesSmoothableBlockState = new KeyBinding("nocubes.key.toggleLeavesSmoothableBlockState", 37, "key.categories.nocubes");
    private static final KeyBinding toggleTerrainCollisions = new KeyBinding("nocubes.key.toggleTerrainCollisions", 46, "key.categories.nocubes");
    public static SmoothLightingFluidBlockRenderer smoothLightingBlockFluidRenderer;

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        WorldClient world;
        NetworkDispatcher networkDispatcher;
        NetworkManager networkManager;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        NetHandlerPlayClient connection = minecraft.func_147114_u();
        if (connection != null && (networkManager = connection.func_147298_b()) != null && (networkDispatcher = NetworkDispatcher.get((NetworkManager)networkManager)) != null && networkDispatcher.getConnectionType() != NetworkDispatcher.ConnectionType.MODDED) {
            Config.terrainCollisions = false;
        }
        if ((world = minecraft.field_71441_e) != null && world.func_72820_D() % 1200L == 0L) {
            BlockColorInfo.refresh();
        }
        if (toggleRenderSmoothTerrain.func_151468_f()) {
            if (Config.renderSmoothTerrain && Config.forceVisuals) {
                TextComponentTranslation msg = new TextComponentTranslation("nocubes.visualsForcedByServer", new Object[0]);
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)msg);
                return;
            }
            boolean newRenderSmoothTerrain = !Config.renderSmoothTerrain;
            ConfigHelper.setRenderSmoothTerrain(newRenderSmoothTerrain);
            Config.renderSmoothTerrain = newRenderSmoothTerrain;
            ClientUtil.tryReloadRenderers();
            return;
        }
        if (toggleRenderSmoothLeaves.func_151468_f()) {
            boolean newRenderSmoothLeaves = !Config.renderSmoothLeaves;
            ConfigHelper.setRenderSmoothLeaves(newRenderSmoothLeaves);
            Config.renderSmoothLeaves = newRenderSmoothLeaves;
            ClientUtil.tryReloadRenderers();
            return;
        }
        if (toggleTerrainCollisions.func_151468_f()) {
            if (Config.terrainCollisions) {
                NoCubes.CHANNEL.sendToServer((IMessage)new C2SRequestDisableTerrainCollisions());
            } else {
                NoCubes.CHANNEL.sendToServer((IMessage)new C2SRequestEnableTerrainCollisions());
            }
        }
        boolean terrainPressed = toggleTerrainSmoothableBlockState.func_151468_f();
        boolean leavesPressed = toggleLeavesSmoothableBlockState.func_151468_f();
        if (terrainPressed || leavesPressed) {
            RayTraceResult objectMouseOver = minecraft.field_71476_x;
            if (objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockPos = objectMouseOver.func_178782_a();
                IBlockState state = minecraft.field_71441_e.func_180495_p(blockPos);
                if (terrainPressed) {
                    if (IsSmoothable.TERRAIN_SMOOTHABLE.test(state)) {
                        NoCubes.CHANNEL.sendToServer((IMessage)new C2SRequestRemoveTerrainSmoothable(Block.func_176210_f((IBlockState)state)));
                    } else {
                        NoCubes.CHANNEL.sendToServer((IMessage)new C2SRequestAddTerrainSmoothable(Block.func_176210_f((IBlockState)state)));
                    }
                }
                if (leavesPressed) {
                    BlockStateToast toast;
                    if (!IsSmoothable.LEAVES_SMOOTHABLE.test(state)) {
                        ConfigHelper.addLeavesSmoothable(state);
                        toast = new BlockStateToast.AddLeaves(state, blockPos);
                    } else {
                        ConfigHelper.removeLeavesSmoothable(state);
                        toast = new BlockStateToast.RemoveLeaves(state, blockPos);
                    }
                    minecraft.func_193033_an().func_192988_a((IToast)toast);
                    if (Config.renderSmoothLeaves) {
                        ClientUtil.tryReloadRenderers();
                    }
                }
            }
        }
        if (toggleProfilers.func_151468_f()) {
            if (ModProfiler.isProfilingEnabled()) {
                ModProfiler.disableProfiling();
            } else {
                ModProfiler.enableProfiling();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (!ModProfiler.isProfilingEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e == null || minecraft.field_71439_g == null || minecraft.func_175606_aa() == null) {
            return;
        }
        Profiler profiler = minecraft.field_71424_I;
        profiler.func_76320_a("debugNoCubes");
        GlStateManager.func_179094_E();
        try {
            ClientEventSubscriber.renderProfilers();
        }
        catch (Exception e) {
            LogManager.getLogger((String)"NoCubes Profile Renderer").error("Error Rendering Profilers.", (Throwable)e);
        }
        GlStateManager.func_179121_F();
        profiler.func_76319_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderProfilers() {
        Minecraft mc = Minecraft.func_71410_x();
        HashMap<Thread, ModProfiler> hashMap = ModProfiler.PROFILERS;
        synchronized (hashMap) {
            int visibleIndex = 0;
            for (Map.Entry<Thread, ModProfiler> entry : ModProfiler.PROFILERS.entrySet()) {
                Thread thread = entry.getKey();
                ModProfiler profiler = entry.getValue();
                List<Profiler1122.Result> list = profiler.getProfilingData("");
                if (list.size() < 2) continue;
                int offset = visibleIndex++;
                Profiler1122.Result profiler$result = list.remove(0);
                int size = list.size();
                GlStateManager.func_179086_m((int)256);
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179142_g();
                GlStateManager.func_179096_D();
                int framebufferWidth = mc.field_71443_c;
                int framebufferHeight = mc.field_71440_d;
                GlStateManager.func_179130_a((double)0.0, (double)framebufferWidth, (double)framebufferHeight, (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179096_D();
                GlStateManager.func_179152_a((float)((float)framebufferWidth / 1000.0f), (float)((float)framebufferWidth / 1000.0f), (float)1.0f);
                GlStateManager.func_179109_b((float)5.0f, (float)5.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.func_187441_d((float)1.0f);
                int cx = 160 + 320 * (offset % 3);
                int cy = 100 + 320 * (offset / 3);
                GlStateManager.func_179098_w();
                FontRenderer fontRenderer = mc.field_71466_p;
                fontRenderer.func_175063_a(thread.getName(), (float)(cx - 160), (float)(cy - 80 - 10 - 16), 0xFFFFFF);
                GlStateManager.func_179090_x();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                GlStateManager.func_179147_l();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b((double)((float)cx - 176.0f), (double)((float)cy - 96.0f - 16.0f), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                bufferbuilder.func_181662_b((double)((float)cx - 176.0f), (double)(cy + 320), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                bufferbuilder.func_181662_b((double)((float)cx + 176.0f), (double)(cy + 320), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                bufferbuilder.func_181662_b((double)((float)cx + 176.0f), (double)((float)cy - 96.0f - 16.0f), 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179084_k();
                double d0 = 0.0;
                for (int i = 0; i < size; ++i) {
                    Profiler1122.Result profiler$result1 = list.get(i);
                    double usePercentage = profiler$result1.usePercentage;
                    int i11 = MathHelper.func_76128_c((double)(usePercentage / 4.0)) + 1;
                    bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                    int j1 = profiler$result1.getColor();
                    int k1 = j1 >> 16 & 0xFF;
                    int l1 = j1 >> 8 & 0xFF;
                    int i2 = j1 & 0xFF;
                    bufferbuilder.func_181662_b((double)cx, (double)cy, 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                    for (int j2 = i11; j2 >= 0; --j2) {
                        float f = (float)((d0 + usePercentage * (double)j2 / (double)i11) * (Math.PI * 2) / 100.0);
                        float f1 = MathHelper.func_76126_a((float)f) * 160.0f;
                        float f2 = MathHelper.func_76134_b((float)f) * 160.0f * 0.5f;
                        bufferbuilder.func_181662_b((double)((float)cx + f1), (double)((float)cy - f2), 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                    for (int i3 = i11; i3 >= 0; --i3) {
                        float f3 = (float)((d0 + usePercentage * (double)i3 / (double)i11) * (Math.PI * 2) / 100.0);
                        float f4 = MathHelper.func_76126_a((float)f3) * 160.0f;
                        float f5 = MathHelper.func_76134_b((float)f3) * 160.0f * 0.5f;
                        bufferbuilder.func_181662_b((double)((float)cx + f4), (double)((float)cy - f5), 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                        bufferbuilder.func_181662_b((double)((float)cx + f4), (double)((float)cy - f5 + 10.0f), 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    d0 += usePercentage;
                }
                DecimalFormat decimalformat = new DecimalFormat("##0.00");
                GlStateManager.func_179098_w();
                String str = "";
                String profilerName = profiler$result.profilerName;
                if (!"unspecified".equals(profilerName)) {
                    str = str + "[0] ";
                }
                str = profilerName.isEmpty() ? str + "ROOT " : str + profilerName + ' ';
                fontRenderer.func_175063_a(str, (float)(cx - 160), (float)(cy - 80 - 16), 0xFFFFFF);
                str = decimalformat.format(profiler$result.totalUsePercentage) + "%";
                fontRenderer.func_175063_a(str, (float)(cx + 160 - fontRenderer.func_78256_a(str)), (float)(cy - 80 - 16), 0xFFFFFF);
                for (int k2 = 0; k2 < size; ++k2) {
                    Profiler1122.Result profiler$result2 = list.get(k2);
                    StringBuilder stringbuilder = new StringBuilder();
                    String profilerName1 = profiler$result2.profilerName;
                    if ("unspecified".equals(profilerName1)) {
                        stringbuilder.append("[?] ");
                    } else {
                        stringbuilder.append("[").append(k2 + 1).append("] ");
                    }
                    String s1 = stringbuilder.append(profilerName1).toString();
                    int color = profiler$result2.getColor();
                    fontRenderer.func_175063_a(s1, (float)(cx - 160), (float)(cy + 80 + k2 * 8 + 20), color);
                    s1 = decimalformat.format(profiler$result2.usePercentage) + "%";
                    fontRenderer.func_175063_a(s1, (float)(cx + 160 - 50 - fontRenderer.func_78256_a(s1)), (float)(cy + 80 + k2 * 8 + 20), color);
                    s1 = decimalformat.format(profiler$result2.totalUsePercentage) + "%";
                    fontRenderer.func_175063_a(s1, (float)(cx + 160 - fontRenderer.func_78256_a(s1)), (float)(cy + 80 + k2 * 8 + 20), color);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GameSettings gameSettings = minecraft.field_71474_y;
        if (!gameSettings.field_74330_P || !gameSettings.field_74329_Q || gameSettings.field_74319_N) {
            return;
        }
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)Math.max(2.5f, (float)minecraft.field_71443_c / 1920.0f * 2.5f));
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)0.999f);
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (AxisAlignedBB voxelShape : world.func_184144_a((Entity)player, new AxisAlignedBB(player.func_180425_c()).func_186662_g(3.0))) {
            RenderGlobal.func_189697_a((AxisAlignedBB)voxelShape.func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        for (AxisAlignedBB voxelShape : world.func_184144_a((Entity)player, new AxisAlignedBB(player.func_180425_c()))) {
            RenderGlobal.func_189697_a((AxisAlignedBB)voxelShape.func_72317_d(-d0, -d1, -d2), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @SubscribeEvent
    public static void drawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        MeshGeneratorType meshGeneratorType;
        IsSmoothable isSmoothable;
        if (!Config.renderSmoothTerrain && !Config.renderSmoothLeaves) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        RayTraceResult rayTraceResult = event.getTarget();
        if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        BlockPos pos = rayTraceResult.func_178782_a();
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a || !world.func_175723_af().func_177746_a(pos)) {
            return;
        }
        if (Config.renderSmoothTerrain && IsSmoothable.TERRAIN_SMOOTHABLE.test(blockState)) {
            isSmoothable = IsSmoothable.TERRAIN_SMOOTHABLE;
            meshGeneratorType = Config.terrainMeshGenerator;
            event.setCanceled(true);
        } else if (Config.renderSmoothLeaves && IsSmoothable.LEAVES_SMOOTHABLE.test(blockState)) {
            isSmoothable = IsSmoothable.LEAVES_SMOOTHABLE;
            meshGeneratorType = Config.leavesMeshGenerator;
            event.setCanceled(!Config.renderSmoothAndVanillaLeaves);
        } else {
            return;
        }
        double renderX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double renderY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double renderZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_178969_c(-renderX, -renderY, -renderZ);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        try (FaceList faces = MeshDispatcher.generateBlockMeshOffset(pos, (IBlockAccess)world, isSmoothable, meshGeneratorType);){
            int facesSize = faces.size();
            for (int i = 0; i < facesSize; ++i) {
                try (Face face = (Face)faces.get(i);
                     Vec3 v0 = face.getVertex0();
                     Vec3 v1 = face.getVertex1();
                     Vec3 v2 = face.getVertex2();
                     Vec3 v3 = face.getVertex3();){
                    double v0x = v0.x;
                    double v0y = v0.y;
                    double v0z = v0.z;
                    bufferbuilder.func_181662_b(v0x, v0y, v0z).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(v1.x, v1.y, v1.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v2.x, v2.y, v2.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v3.x, v3.y, v3.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    bufferbuilder.func_181662_b(v0x, v0y, v0z).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    continue;
                }
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public static void onPlayerSPPushOutOfBlocksEvent(PlayerSPPushOutOfBlocksEvent event) {
        if (Config.terrainCollisions) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal()) {
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        }
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)toggleRenderSmoothTerrain);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleRenderSmoothLeaves);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleProfilers);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleTerrainSmoothableBlockState);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleLeavesSmoothableBlockState);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleTerrainCollisions);
    }
}

