/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.client.LazyBlockColorCache;
import io.github.cadiboo.nocubes.util.pooled.Vec3;
import java.util.Calendar;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;

public final class BlockColorInfo
implements AutoCloseable {
    private static final ThreadLocal<BlockColorInfo> POOL = ThreadLocal.withInitial(() -> new BlockColorInfo(-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f));
    public static boolean rainbow;
    public static boolean black;
    public float red0;
    public float green0;
    public float blue0;
    public float red1;
    public float green1;
    public float blue1;
    public float red2;
    public float green2;
    public float blue2;
    public float red3;
    public float green3;
    public float blue3;
    private boolean inUse;

    private BlockColorInfo(float red0, float green0, float blue0, float red1, float green1, float blue1, float red2, float green2, float blue2, float red3, float green3, float blue3) {
        this.red0 = red0;
        this.green0 = green0;
        this.blue0 = blue0;
        this.red1 = red1;
        this.green1 = green1;
        this.blue1 = blue1;
        this.red2 = red2;
        this.green2 = green2;
        this.blue2 = blue2;
        this.red3 = red3;
        this.green3 = green3;
        this.blue3 = blue3;
        this.inUse = false;
    }

    public static BlockColorInfo generateBlockColorInfo(@Nonnull LazyBlockColorCache lazyBlockColorCache, @Nonnull Vec3 v0, @Nonnull Vec3 v1, @Nonnull Vec3 v2, @Nonnull Vec3 v3, int chunkRenderPosX, int chunkRenderPosY, int chunkRenderPosZ, int[] cache, int sizeX, int sizeY, int biomeBlendRadius, int area, int max, IBlockAccess reader, BiomeColorHelper.ColorResolver colorResolver, boolean useCache, BlockPos.PooledMutableBlockPos pooledMutableBlockPos) {
        if (black) {
            return BlockColorInfo.retain(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        int[] blockColor0 = new int[27];
        int[] blockColor1 = new int[27];
        int[] blockColor2 = new int[27];
        int[] blockColor3 = new int[27];
        int v0XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.x) - chunkRenderPosX), (int)-1, (int)16);
        int v0YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.y) - chunkRenderPosY), (int)-1, (int)16);
        int v0ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v0.z) - chunkRenderPosZ), (int)-1, (int)16);
        int v1XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v1.x) - chunkRenderPosX), (int)-1, (int)16);
        int v1YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v1.y) - chunkRenderPosY), (int)-1, (int)16);
        int v1ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v1.z) - chunkRenderPosZ), (int)-1, (int)16);
        int v2XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v2.x) - chunkRenderPosX), (int)-1, (int)16);
        int v2YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v2.y) - chunkRenderPosY), (int)-1, (int)16);
        int v2ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v2.z) - chunkRenderPosZ), (int)-1, (int)16);
        int v3XOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v3.x) - chunkRenderPosX), (int)-1, (int)16);
        int v3YOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v3.y) - chunkRenderPosY), (int)-1, (int)16);
        int v3ZOffset = 1 + MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)v3.z) - chunkRenderPosZ), (int)-1, (int)16);
        int index = 0;
        for (int zOffset = 0; zOffset < 3; ++zOffset) {
            for (int yOffset = 0; yOffset < 3; ++yOffset) {
                int xOffset = 0;
                while (xOffset < 3) {
                    int x0 = v0XOffset + xOffset;
                    int y0 = v0YOffset + yOffset;
                    int z0 = v0ZOffset + zOffset;
                    blockColor0[index] = LazyBlockColorCache.get(x0, y0, z0, cache, lazyBlockColorCache.getIndex(x0, y0, z0, sizeX, sizeY), biomeBlendRadius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, (BlockPos.MutableBlockPos)pooledMutableBlockPos, reader, colorResolver, useCache);
                    int x1 = v1XOffset + xOffset;
                    int y1 = v1YOffset + yOffset;
                    int z1 = v1ZOffset + zOffset;
                    blockColor1[index] = LazyBlockColorCache.get(x1, y1, z1, cache, lazyBlockColorCache.getIndex(x1, y1, z1, sizeX, sizeY), biomeBlendRadius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, (BlockPos.MutableBlockPos)pooledMutableBlockPos, reader, colorResolver, useCache);
                    int x2 = v2XOffset + xOffset;
                    int y2 = v2YOffset + yOffset;
                    int z2 = v2ZOffset + zOffset;
                    blockColor2[index] = LazyBlockColorCache.get(x2, y2, z2, cache, lazyBlockColorCache.getIndex(x2, y2, z2, sizeX, sizeY), biomeBlendRadius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, (BlockPos.MutableBlockPos)pooledMutableBlockPos, reader, colorResolver, useCache);
                    int x3 = v3XOffset + xOffset;
                    int y3 = v3YOffset + yOffset;
                    int z3 = v3ZOffset + zOffset;
                    blockColor3[index] = LazyBlockColorCache.get(x3, y3, z3, cache, lazyBlockColorCache.getIndex(x3, y3, z3, sizeX, sizeY), biomeBlendRadius, area, max, chunkRenderPosX, chunkRenderPosY, chunkRenderPosZ, (BlockPos.MutableBlockPos)pooledMutableBlockPos, reader, colorResolver, useCache);
                    ++xOffset;
                    ++index;
                }
            }
        }
        int red0 = 0;
        int green0 = 0;
        int blue0 = 0;
        int red1 = 0;
        int green1 = 0;
        int blue1 = 0;
        int red2 = 0;
        int green2 = 0;
        int blue2 = 0;
        int red3 = 0;
        int green3 = 0;
        int blue3 = 0;
        for (int colorIndex = 0; colorIndex < 27; ++colorIndex) {
            int color0 = blockColor0[colorIndex];
            red0 += (color0 & 0xFF0000) >> 16;
            green0 += (color0 & 0xFF00) >> 8;
            blue0 += color0 & 0xFF;
            int color1 = blockColor1[colorIndex];
            red1 += (color1 & 0xFF0000) >> 16;
            green1 += (color1 & 0xFF00) >> 8;
            blue1 += color1 & 0xFF;
            int color2 = blockColor2[colorIndex];
            red2 += (color2 & 0xFF0000) >> 16;
            green2 += (color2 & 0xFF00) >> 8;
            blue2 += color2 & 0xFF;
            int color3 = blockColor3[colorIndex];
            red3 += (color3 & 0xFF0000) >> 16;
            green3 += (color3 & 0xFF00) >> 8;
            blue3 += color3 & 0xFF;
        }
        if (rainbow) {
            return BlockColorInfo.retain(red0, green0, blue0, red1, green1, blue1, red2, green2, blue2, red3, green3, blue3);
        }
        red0 = (int)((float)red0 / 27.0f);
        green0 = (int)((float)green0 / 27.0f);
        blue0 = (int)((float)blue0 / 27.0f);
        red1 = (int)((float)red1 / 27.0f);
        green1 = (int)((float)green1 / 27.0f);
        blue1 = (int)((float)blue1 / 27.0f);
        red2 = (int)((float)red2 / 27.0f);
        green2 = (int)((float)green2 / 27.0f);
        blue2 = (int)((float)blue2 / 27.0f);
        red3 = (int)((float)red3 / 27.0f);
        green3 = (int)((float)green3 / 27.0f);
        blue3 = (int)((float)blue3 / 27.0f);
        return BlockColorInfo.retain((float)red0 / 255.0f, (float)green0 / 255.0f, (float)blue0 / 255.0f, (float)red1 / 255.0f, (float)green1 / 255.0f, (float)blue1 / 255.0f, (float)red2 / 255.0f, (float)green2 / 255.0f, (float)blue2 / 255.0f, (float)red3 / 255.0f, (float)green3 / 255.0f, (float)blue3 / 255.0f);
    }

    public static BlockColorInfo retain(float red0, float green0, float blue0, float red1, float green1, float blue1, float red2, float green2, float blue2, float red3, float green3, float blue3) {
        BlockColorInfo pooled = POOL.get();
        if (pooled.inUse) {
            throw new IllegalStateException("BlockColorInfo is already in use!");
        }
        pooled.inUse = true;
        pooled.red0 = red0;
        pooled.green0 = green0;
        pooled.blue0 = blue0;
        pooled.red1 = red1;
        pooled.green1 = green1;
        pooled.blue1 = blue1;
        pooled.red2 = red2;
        pooled.green2 = green2;
        pooled.blue2 = blue2;
        pooled.red3 = red3;
        pooled.green3 = green3;
        pooled.blue3 = blue3;
        return pooled;
    }

    public static void refresh() {
        rainbow = BlockColorInfo.isWearItPurpleDay();
        black = BlockColorInfo.isHalloween();
    }

    private static boolean isWearItPurpleDay() {
        Calendar lastFridayOfAugust = Calendar.getInstance();
        lastFridayOfAugust.set(2, 7);
        lastFridayOfAugust.add(2, 1);
        int lobosMagicNumber = 0;
        lastFridayOfAugust.add(5, -((lobosMagicNumber + lastFridayOfAugust.get(7)) % 7 + 1));
        return lastFridayOfAugust.get(6) == Calendar.getInstance().get(6);
    }

    private static boolean isHalloween() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 9 && calendar.get(5) == 31;
    }

    @Override
    public void close() {
        this.inUse = false;
    }

    static {
        BlockColorInfo.refresh();
    }
}

