/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.ConfigTracker;
import io.github.cadiboo.nocubes.network.S2CSyncConfig;
import io.github.cadiboo.nocubes.world.ModWorldEventListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="nocubes")
public final class ForgeEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world instanceof World) {
            world.func_72954_a((IWorldEventListener)new ModWorldEventListener());
        } else {
            LOGGER.error("Failed to attach event listener to world. world is not a World!");
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!(player instanceof EntityPlayerMP)) {
            NoCubes.LOGGER.error("WTF, player is not EntityPlayerMP", (Throwable)new IllegalStateException());
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        SimpleNetworkWrapper network = NoCubes.CHANNEL;
        for (Pair<String, S2CSyncConfig> pair : ConfigTracker.INSTANCE.syncConfigs(false)) {
            network.sendTo((IMessage)pair.getValue(), playerMP);
        }
    }
}

