/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util.capability;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.capability.GelEntity;
import com.legacy.structure_gel.util.capability.IGelEntity;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.registries.ForgeRegistries;

public class GelCapability {
    @CapabilityInject(value=IGelEntity.class)
    public static Capability<IGelEntity> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IGelEntity.class, (Capability.IStorage)new Storage(), GelEntity::new);
    }

    @Nullable
    public static <E extends Entity> IGelEntity get(E entity) {
        if (entity != null && entity.getCapability(INSTANCE).isPresent()) {
            return entity.getCapability(INSTANCE).resolve().orElseGet(() -> null);
        }
        return null;
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IGelEntity> action) {
        if (entity != null && entity.getCapability(INSTANCE).isPresent()) {
            action.accept((IGelEntity)entity.getCapability(INSTANCE).resolve().get());
        }
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IGelEntity> action, Consumer<E> elseAction) {
        if (entity != null) {
            if (entity.getCapability(INSTANCE).isPresent()) {
                action.accept((IGelEntity)entity.getCapability(INSTANCE).resolve().get());
            } else {
                elseAction.accept(entity);
            }
        }
    }

    @Nullable
    public static <E extends Entity, R> R getIfPresent(E entity, Function<IGelEntity, R> action) {
        if (entity != null && entity.getCapability(INSTANCE).isPresent()) {
            return action.apply((IGelEntity)entity.getCapability(INSTANCE).resolve().get());
        }
        return null;
    }

    @Nullable
    public static <E extends Entity, R> R getIfPresent(E entity, Function<IGelEntity, R> action, Function<E, R> elseAction) {
        if (entity != null) {
            if (entity.getCapability(INSTANCE).isPresent()) {
                return action.apply((IGelEntity)entity.getCapability(INSTANCE).resolve().get());
            }
            return elseAction.apply(entity);
        }
        return null;
    }

    public static class Storage
    implements Capability.IStorage<IGelEntity> {
        public static final ResourceLocation EMPTY = StructureGelMod.locate("empty");
        public static final String portal = "portal";

        @Nullable
        public INBT writeNBT(Capability<IGelEntity> capability, IGelEntity instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            this.putPortal(nbt, portal, instance.getPortal());
            return nbt;
        }

        private void putPortal(CompoundNBT nbt, String key, GelPortalBlock portal) {
            nbt.func_74778_a(key, portal != null ? portal.getRegistryName().toString() : EMPTY.toString());
        }

        public void readNBT(Capability<IGelEntity> capability, IGelEntity instance, Direction side, INBT inbt) {
            if (inbt instanceof CompoundNBT) {
                CompoundNBT nbt = (CompoundNBT)inbt;
                instance.setPortal(this.getPortal(nbt, portal));
            }
        }

        private GelPortalBlock getPortal(CompoundNBT nbt, String key) {
            ResourceLocation portal = new ResourceLocation(nbt.func_74779_i(key));
            return !portal.equals((Object)EMPTY) && ForgeRegistries.BLOCKS.containsKey(portal) && ForgeRegistries.BLOCKS.getValue(portal) instanceof GelPortalBlock ? (GelPortalBlock)ForgeRegistries.BLOCKS.getValue(portal) : null;
        }
    }
}

