/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GelCollectors {
    public static <T, V> Map<T, V> mapOf(Class<T> keyClass, Class<V> valueClass, Object ... objects) throws ClassCastException, ArrayIndexOutOfBoundsException {
        HashMap<T, V> map = new HashMap<T, V>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(keyClass.cast(objects[i]), valueClass.cast(objects[i + 1]));
        }
        return map;
    }

    public static <T> List<T> addToList(List<T> list, T obj) {
        return Streams.concat((Stream[])new Stream[]{list.stream(), ImmutableList.of(obj).stream()}).collect(Collectors.toList());
    }

    public static <T> List<T> addToList(List<T> list, List<T> list2) {
        return Streams.concat((Stream[])new Stream[]{list.stream(), list2.stream()}).collect(Collectors.toList());
    }

    public static <T> List<T> makeListMutable(List<T> list) {
        return list.stream().collect(Collectors.toList());
    }

    public static <T> List<T> makeListMutable(List<T> list, Function<T, T> listFunction) {
        return list.stream().map(listFunction).collect(Collectors.toList());
    }

    public static <T> Set<T> addToSet(Set<T> set, T obj) {
        return GelCollectors.addToSet(set, ImmutableSet.of(obj));
    }

    public static <T> Set<T> addToSet(Set<T> set, Set<T> set2) {
        return Streams.concat((Stream[])new Stream[]{set.stream(), set2.stream()}).collect(Collectors.toSet());
    }

    public static <T> Set<T> makeSetMutable(Set<T> set) {
        return set.stream().collect(Collectors.toSet());
    }

    public static <T> Set<T> makeSetMutable(Set<T> set, Function<T, T> setFunction) {
        return set.stream().map(setFunction).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> map, Map<K, V> map2, Function<Map.Entry<K, V>, K> keyFunction, Function<Map.Entry<K, V>, V> valueFunction) {
        return Streams.concat((Stream[])new Stream[]{map.entrySet().stream(), map2.entrySet().stream()}).collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> map, Map<K, V> map2) {
        return GelCollectors.addToMap(map, map2, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> map, K key, V value, Function<Map.Entry<K, V>, K> keyFunction, Function<Map.Entry<K, V>, V> valueFunction) {
        return Streams.concat((Stream[])new Stream[]{map.entrySet().stream(), ImmutableList.of(new AbstractMap.SimpleEntry<K, V>(key, value)).stream()}).collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> map, K key, V value) {
        return GelCollectors.addToMap(map, key, value, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Map<K, V> makeMapMutable(Map<K, V> map, Function<Map.Entry<K, V>, K> keyFunction, Function<Map.Entry<K, V>, V> valueFunction) {
        return map.entrySet().stream().collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <K, V> Map<K, V> makeMapMutable(Map<K, V> map) {
        return GelCollectors.makeMapMutable(map, Map.Entry::getKey, Map.Entry::getValue);
    }
}

