/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.scan;

import java.util.HashMap;
import java.util.Map;
import me.andre111.mambience.accessor.Accessor;

public final class BlockScanner {
    private Accessor accessor;
    private int xSize;
    private int ySize;
    private int zSize;
    private int currentYSize;
    private Map<String, Integer> blockCount = new HashMap<String, Integer>();
    private Map<String, Integer> biomeCount = new HashMap<String, Integer>();
    private double averageSkyLight;
    private double averageLight;
    private double averageTemperature;
    private double averageHumidity;
    private long lastScan;

    public BlockScanner(Accessor a, int xs, int ys, int zs) {
        this.accessor = a;
        this.xSize = xs;
        this.ySize = ys;
        this.zSize = zs;
        this.currentYSize = this.ySize;
        this.resetScanData();
        this.lastScan = 0L;
    }

    public void performScan() {
        if (!this.accessor.updatePlayerInstance()) {
            return;
        }
        int startX = (int)this.accessor.getX() - this.xSize / 2;
        int startY = (int)this.accessor.getY() - this.ySize / 2;
        int startZ = (int)this.accessor.getZ() - this.zSize / 2;
        this.currentYSize = this.ySize;
        if (startY < 0) {
            this.currentYSize -= startY;
            startY = 0;
        }
        if (startY + this.currentYSize > 256) {
            this.currentYSize = 256 - startY;
        }
        this.resetScanData();
        for (int xx = 0; xx < this.xSize; ++xx) {
            for (int zz = 0; zz < this.zSize; ++zz) {
                String id;
                for (int yy = 0; yy < this.currentYSize; ++yy) {
                    String id2;
                    this.blockCount.put(id2, this.blockCount.containsKey(id2 = this.accessor.getBlock(startX + xx, startY + yy, startZ + zz)) ? this.blockCount.get(id2) + 1 : 1);
                    this.averageSkyLight += (double)this.accessor.getSkyLight(startX + xx, startY + yy, startZ + zz);
                    this.averageLight += (double)this.accessor.getLight(startX + xx, startY + yy, startZ + zz);
                }
                this.biomeCount.put(id, this.biomeCount.containsKey(id = this.accessor.getBiome(startX + xx, 0, startZ + zz)) ? this.biomeCount.get(id) + 1 : 1);
                this.averageTemperature += this.accessor.getTemperature(startX + xx, 0, startZ + zz);
                this.averageHumidity += this.accessor.getHumidity(startX + xx, 0, startZ + zz);
            }
        }
        this.averageSkyLight /= (double)this.getScanBlockCount();
        this.averageLight /= (double)this.getScanBlockCount();
        this.averageTemperature /= (double)this.getScanBiomeCount();
        this.averageHumidity /= (double)this.getScanBiomeCount();
    }

    public void resetScanData() {
        this.blockCount.clear();
        this.biomeCount.clear();
        this.averageSkyLight = 0.0;
        this.averageLight = 0.0;
        this.averageTemperature = 0.0;
        this.averageHumidity = 0.0;
    }

    public int getxSize() {
        return this.xSize;
    }

    public void setxSize(int xSize) {
        this.xSize = xSize;
    }

    public int getySize() {
        return this.ySize;
    }

    public void setySize(int ySize) {
        this.ySize = ySize;
    }

    public int getzSize() {
        return this.zSize;
    }

    public void setzSize(int zSize) {
        this.zSize = zSize;
    }

    public int getScanBlockCount() {
        return this.xSize * this.currentYSize * this.zSize;
    }

    public Map<String, Integer> getScanBlockData() {
        return this.blockCount;
    }

    public int getScanBiomeCount() {
        return this.xSize * this.zSize;
    }

    public Map<String, Integer> getScanBiomeData() {
        return this.biomeCount;
    }

    public double getAverageSkyLight() {
        return this.averageSkyLight;
    }

    public double getAverageLight() {
        return this.averageLight;
    }

    public double getAverageTemperature() {
        return this.averageTemperature;
    }

    public double getAverageHumidity() {
        return this.averageHumidity;
    }

    public long getLastScan() {
        return this.lastScan;
    }

    public void setLastScan(long lastScan) {
        this.lastScan = lastScan;
    }
}

