/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.config.CommentSkippingReader;
import me.andre111.mambience.config.ConfigUtil;
import me.andre111.mambience.effect.Effect;
import me.andre111.mambience.effect.Effects;

public final class EffectLoader {
    public static void loadEffects(MALogger logger, File file) {
        try (CommentSkippingReader reader = new CommentSkippingReader(new BufferedReader(new FileReader(file)));){
            JsonParser parser = new JsonParser();
            JsonArray effectElement = parser.parse(reader.readAllLines("\n")).getAsJsonArray();
            Effects.reset();
            for (int i = 0; i < effectElement.size(); ++i) {
                Effect effect = EffectLoader.loadEffect(logger, i, effectElement.get(i).getAsJsonObject());
                Effects.addEffect(effect);
            }
        }
        catch (Exception e) {
            logger.error("Exception loading effects: " + file.getAbsolutePath() + ": " + e);
            e.printStackTrace();
        }
    }

    private static Effect loadEffect(MALogger logger, int index, JsonObject obj) {
        String type = ConfigUtil.getString(obj, "type", "");
        String[] parameters = ConfigUtil.getStringArray(obj, "parameters", new String[0]);
        String block = ConfigUtil.getString(obj, "block", "");
        String blockAbove = ConfigUtil.getString(obj, "blockAbove", "");
        String blockBelow = ConfigUtil.getString(obj, "blockBelow", "");
        double chance = ConfigUtil.getDouble(obj, "chance", 1.0f);
        List<Condition> conditions = ConfigUtil.loadConditions(logger, obj.get("conditions").getAsJsonArray());
        List<Condition> restrictions = ConfigUtil.loadConditions(logger, obj.get("restrictions").getAsJsonArray());
        return new Effect(type, parameters, block, blockAbove, blockBelow, chance, conditions, restrictions);
    }
}

