/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.condition.Parser;
import me.andre111.mambience.sound.Sound;

public class ConfigUtil {
    public static List<Condition> loadConditions(MALogger logger, JsonArray array) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (int i = 0; i < array.size(); ++i) {
            if (array.get(i).getAsJsonObject().get("condition").getAsString().equals("TOGGLE")) continue;
            Condition condition = ConfigUtil.loadCondition(logger, array.get(i).getAsJsonObject());
            if (condition != null) {
                conditions.add(condition);
                continue;
            }
            logger.log("Warning: Ignored unknown condition: " + array.get(i));
        }
        return conditions;
    }

    private static Condition loadCondition(MALogger logger, JsonObject obj) {
        String name = ConfigUtil.getString(obj, "condition", "");
        String stringValue = ConfigUtil.getString(obj, "stringValue", "");
        float floatValue = ConfigUtil.getFloat(obj, "floatValue", 0.0f);
        return Parser.parse(name, stringValue, floatValue);
    }

    public static Sound[] loadSounds(JsonElement element, float volumeMultiplier) {
        if (element == null) {
            return new Sound[0];
        }
        if (element.isJsonPrimitive()) {
            String name = element.getAsString();
            if (!name.contains(":")) {
                name = "mambience:" + name;
            }
            return new Sound[]{new Sound(name, volumeMultiplier, volumeMultiplier, 1.0f, 1.0f, 0, 1.0)};
        }
        if (element.isJsonObject()) {
            float pitchMin;
            float volumeMax;
            float volumeMin;
            JsonObject object = element.getAsJsonObject();
            String name = object.get("name").getAsString();
            if (!name.contains(":")) {
                name = "mambience:" + name;
            }
            float f = object.has("volumeMin") ? object.get("volumeMin").getAsFloat() / 100.0f : (volumeMin = object.has("volume") ? object.get("volume").getAsFloat() / 100.0f : 1.0f);
            float f2 = object.has("volumeMax") ? object.get("volumeMax").getAsFloat() / 100.0f : (volumeMax = object.has("volume") ? object.get("volume").getAsFloat() / 100.0f : 1.0f);
            float f3 = object.has("pitchMin") ? object.get("pitchMin").getAsFloat() / 100.0f : (pitchMin = object.has("pitch") ? object.get("pitch").getAsFloat() / 100.0f : 1.0f);
            float pitchMax = object.has("pitchMax") ? object.get("pitchMax").getAsFloat() / 100.0f : (object.has("pitch") ? object.get("pitch").getAsFloat() / 100.0f : 1.0f);
            int delay = object.has("delay") ? object.get("delay").getAsInt() : 0;
            double probability = object.has("probability") ? object.get("probability").getAsDouble() : 1.0;
            return new Sound[]{new Sound(name, volumeMin *= volumeMultiplier, volumeMax *= volumeMultiplier, pitchMin, pitchMax, delay, probability)};
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Sound> sounds = new ArrayList<Sound>();
            for (int i = 0; i < array.size(); ++i) {
                for (Sound sound : ConfigUtil.loadSounds(array.get(i), volumeMultiplier)) {
                    sounds.add(sound);
                }
            }
            return sounds.toArray(new Sound[0]);
        }
        throw new RuntimeException("Unsupported sound format: " + element);
    }

    public static String getString(JsonObject obj, String memberName, String defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsString() : defaultValue;
    }

    public static double getDouble(JsonObject obj, String memberName, float defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsDouble() : (double)defaultValue;
    }

    public static float getFloat(JsonObject obj, String memberName, float defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsFloat() : defaultValue;
    }

    public static int getInt(JsonObject obj, String memberName, int defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsInt() : defaultValue;
    }

    public static String[] getStringArray(JsonObject obj, String memberName, String[] defaultValue) {
        if (obj.has(memberName) && obj.get(memberName).isJsonArray()) {
            JsonArray jsonArray = obj.get(memberName).getAsJsonArray();
            String[] stringArray = new String[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                stringArray[i] = jsonArray.get(i).getAsString();
            }
            return stringArray;
        }
        return defaultValue;
    }
}

