/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import java.io.BufferedReader;
import java.io.IOException;

public final class CommentSkippingReader
implements AutoCloseable {
    private BufferedReader reader;

    public CommentSkippingReader(BufferedReader reader) {
        this.reader = reader;
    }

    public String readLine() throws IOException {
        String line = null;
        while (this.isComment(line = this.reader.readLine())) {
        }
        return line;
    }

    public String readAllLines(String lineBreak) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = this.readLine()) != null) {
            sb.append(line);
            sb.append(lineBreak);
        }
        return sb.toString();
    }

    private boolean isComment(String line) {
        if (line == null) {
            return false;
        }
        return line.trim().startsWith("//");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

