/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;

public final class ConditionBlocks
extends Condition {
    private final List<String> blocks;
    private final float minPercentage;

    public ConditionBlocks(List<String> blocks, float minPercentage) {
        this.blocks = new ArrayList<String>(blocks);
        this.minPercentage = minPercentage;
    }

    @Override
    public boolean matches(MAPlayer player) {
        Map<String, Integer> scanData = player.getScanner().getScanBlockData();
        int count = 0;
        for (String block : this.blocks) {
            count += scanData != null && block != null && scanData.containsKey(block) ? scanData.get(block) : 0;
        }
        float percentage = (float)count / (float)player.getScanner().getScanBlockCount();
        return percentage >= this.minPercentage;
    }
}

