/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.ambient;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.sound.Sound;

public final class AmbientEvent {
    private static final Random RANDOM = new Random();
    private final String id;
    private final Sound[] sounds;
    private final List<Condition> conditions;
    private final List<Condition> restrictions;
    private final int cooldownMin;
    private final int cooldownMax;

    public AmbientEvent(String id, Sound[] sounds, List<Condition> conditions, List<Condition> restrictions, int cooldownMin, int cooldownMax) {
        this.id = id;
        this.sounds = sounds;
        this.conditions = new ArrayList<Condition>(conditions);
        this.restrictions = new ArrayList<Condition>(restrictions);
        this.cooldownMin = cooldownMin;
        this.cooldownMax = cooldownMax;
        if (cooldownMin < 0) {
            throw new IllegalArgumentException("Cooldown Minimum cannot be negative");
        }
        if (cooldownMax < 0) {
            throw new IllegalArgumentException("Cooldown Maximum cannot be negative");
        }
        if (cooldownMax < cooldownMin) {
            throw new IllegalArgumentException("Cooldown Minimum cannot be larger than Cooldown Maximum");
        }
    }

    public void init(MAPlayer maplayer) {
        this.setCooldown(maplayer);
    }

    public void update(MAPlayer maplayer) {
        if (this.conditionsMet(maplayer)) {
            if (maplayer.updateCooldown(this.id) <= 0) {
                for (Sound sound : this.sounds) {
                    maplayer.getSoundPlayer().playSound(sound, maplayer.getAccessor().getX(), maplayer.getAccessor().getY(), maplayer.getAccessor().getZ(), false);
                }
                this.setCooldown(maplayer);
            }
        } else if (Config.ambientEvents().isStopSounds() && maplayer.getCooldown(this.id) > 0) {
            for (Sound sound : this.sounds) {
                maplayer.getLogger().log("Stop sound " + sound.getName());
                maplayer.getAccessor().stopSound(sound.getName());
            }
            maplayer.setCooldown(this.id, 0);
        }
    }

    private boolean conditionsMet(MAPlayer maplayer) {
        return this.isInConditions(maplayer) && !this.isRestricted(maplayer);
    }

    private boolean isInConditions(MAPlayer maplayer) {
        for (Condition condition : this.conditions) {
            if (condition.matches(maplayer)) continue;
            return false;
        }
        return true;
    }

    private boolean isRestricted(MAPlayer maplayer) {
        for (Condition restriction : this.restrictions) {
            if (!restriction.matches(maplayer)) continue;
            return true;
        }
        return false;
    }

    private void setCooldown(MAPlayer maplayer) {
        maplayer.setCooldown(this.id, this.cooldownMin + RANDOM.nextInt(this.cooldownMax - this.cooldownMin + 1));
    }
}

