/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import io.netty.buffer.Unpooled;
import java.io.File;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.accessor.AccessorFabricClient;
import me.andre111.mambience.accessor.AccessorFabricServer;
import me.andre111.mambience.fabric.FootstepBlockMapGenerator;
import me.andre111.mambience.fabric.event.PlayerJoinCallback;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MAmbienceFabric
implements ModInitializer,
ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static MinecraftServer server;
    public static MAmbienceFabric instance;
    private int ticker;
    private long lastTick;
    private boolean runClientSide;

    public void onInitialize() {
        this.initCommon();
        this.initServer();
    }

    public void onInitializeClient() {
        this.initCommon();
        this.initClient();
    }

    private void initCommon() {
        instance = this;
        MAmbience.init(new MALogger(arg_0 -> ((Logger)LOGGER).info(arg_0), arg_0 -> ((Logger)LOGGER).error(arg_0)), new File("./config/mambience"));
    }

    private void initServer() {
        FootstepBlockMapGenerator.scanForMissingBlockMapEntries();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            MAmbienceFabric.server = server;
            this.tick();
        });
        PlayerJoinCallback.EVENT.register((connection, player) -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeBytes("enabled".getBytes());
            player.field_13987.method_14364((class_2596)new class_2658(new class_2960("mambience", "server"), buf));
            MAmbience.addPlayer(player.method_5667(), new AccessorFabricServer(player.method_5667()));
        });
    }

    private void initClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if ((client.method_1496() || client.field_1687 == null || client.field_1724 == null) && this.runClientSide) {
                MAmbience.getLogger().log("automatically disabled client side ambient sounds");
                MAmbience.getScheduler().clearPlayers();
                this.runClientSide = false;
            }
            if (this.runClientSide) {
                this.tick();
            }
        });
    }

    private void tick() {
        if (System.currentTimeMillis() - this.lastTick < 25L) {
            return;
        }
        this.lastTick = System.currentTimeMillis();
        MAmbience.getScheduler().runSyncUpdate();
        ++this.ticker;
        if (this.ticker == 20) {
            this.ticker = 0;
            MAmbience.getScheduler().runAsyncUpdate();
        }
    }

    public void onStartGameSession(class_310 client) {
        if (!this.runClientSide && !client.method_1496()) {
            MAmbience.getLogger().log("enabling client side ambient sounds");
            MAmbience.addPlayer(client.field_1724.method_5667(), new AccessorFabricClient(client.field_1724.method_5667()));
            this.runClientSide = true;
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeBytes("mambience:server".getBytes());
            buf.writeByte(0);
            client.field_1724.field_3944.method_2883((class_2596)new class_2817(new class_2960("minecraft", "register"), buf));
        }
    }

    public void onServerMAmbiencePresent() {
        if (this.runClientSide) {
            MAmbience.getLogger().log("server reported MAmbience present: disabled client side ambient sounds");
            MAmbience.getScheduler().clearPlayers();
            this.runClientSide = false;
        }
    }
}

