/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.zawamod.init.ZAWABlocks;
import org.zawamod.world.GeneratedFlower;
import org.zawamod.world.struct.WorldGenArcticGrass;
import org.zawamod.world.struct.WorldGenCoral;
import org.zawamod.world.struct.WorldGenKelp;
import org.zawamod.world.struct.WorldGenMixedStones;
import org.zawamod.world.struct.WorldGenMossyRiverStones;
import org.zawamod.world.struct.WorldGenOceanCluster;
import org.zawamod.world.struct.WorldGenRiverStones;
import org.zawamod.world.struct.WorldGenSeaGrass;
import org.zawamod.world.struct.WorldGenZAWAFlower;

public class ZAWAWorldGenerator
implements IWorldGenerator {
    public static List<GeneratedFlower> generations = Lists.newArrayList();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (world.field_73011_w.getDimension() == 0) {
            this.generateOverworld(world, random, blockX, blockZ);
        }
    }

    public static void initList() {
        ZAWAWorldGenerator.add("Sea Grass", new WorldGenSeaGrass(), 8, Biomes.field_76771_b, Biomes.field_76777_m, Biomes.field_150575_M);
        ZAWAWorldGenerator.add("Kelp", new WorldGenKelp(), 1, Biomes.field_76771_b, Biomes.field_76781_i, Biomes.field_150575_M);
        ZAWAWorldGenerator.add("Dried Bamboo", new WorldGenZAWAFlower(ZAWABlocks.DRIED_BAMBOO), 4, Biomes.field_150588_X, Biomes.field_76767_f);
        ZAWAWorldGenerator.add("Bamboo", new WorldGenZAWAFlower(ZAWABlocks.BAMBOO), 4, Biomes.field_76782_w, Biomes.field_76780_h, Biomes.field_76770_e);
        ZAWAWorldGenerator.add("Artic Moss", new WorldGenZAWAFlower(ZAWABlocks.ARCTIC_MOSS), 4, Biomes.field_76768_g, Biomes.field_76770_e, Biomes.field_76775_o);
        ZAWAWorldGenerator.add("Golden Sparks", new WorldGenZAWAFlower(ZAWABlocks.GOLDEN_SPARKS), 4, Biomes.field_150585_R, Biomes.field_76767_f, Biomes.field_76772_c);
        ZAWAWorldGenerator.add("Temple Bells", new WorldGenZAWAFlower(ZAWABlocks.TEMPLE_BELLS), 4, Biomes.field_150588_X, Biomes.field_76769_d, Biomes.field_150589_Z);
        ZAWAWorldGenerator.add("Peach Bells", new WorldGenZAWAFlower(ZAWABlocks.PEACH_FLOWER), 4, Biomes.field_76767_f, Biomes.field_150585_R);
        ZAWAWorldGenerator.add("Wild Celery", new WorldGenZAWAFlower(ZAWABlocks.WILD_CELERY), 4, Biomes.field_76780_h, Biomes.field_76782_w, Biomes.field_76783_v);
        ZAWAWorldGenerator.add("Bellflowers", new WorldGenZAWAFlower(ZAWABlocks.BELLFLOWERS), 4, Biomes.field_150588_X, Biomes.field_76772_c);
        ZAWAWorldGenerator.add("Ostritch Fern", new WorldGenZAWAFlower(ZAWABlocks.OSTRITCH_FERN), 4, Biomes.field_76772_c, Biomes.field_76767_f, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Bromeliad", new WorldGenZAWAFlower(ZAWABlocks.BROMELIAD), 4, Biomes.field_76780_h, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Ocean Custer", new WorldGenOceanCluster(), 2, Biomes.field_76771_b, Biomes.field_76787_r, Biomes.field_150575_M);
        ZAWAWorldGenerator.add("Arctic Grass", new WorldGenArcticGrass(), 2, Biomes.field_76774_n);
        ZAWAWorldGenerator.add("Coral", new WorldGenCoral(), 1, Biomes.field_76771_b, Biomes.field_76787_r, Biomes.field_150575_M);
        ZAWAWorldGenerator.add("River Stones", new WorldGenRiverStones(), 1, Biomes.field_76781_i);
        ZAWAWorldGenerator.add("Mossy River Stones", new WorldGenMossyRiverStones(), 1, Biomes.field_76781_i);
        ZAWAWorldGenerator.add("Mixed Stones", new WorldGenMixedStones(), 1, Biomes.field_76770_e);
        ZAWAWorldGenerator.add("Fan Palm", new WorldGenZAWAFlower(ZAWABlocks.FAN_PALM_BOTTOM, ZAWABlocks.FAN_PALM_TOP), 1, Biomes.field_76769_d);
        ZAWAWorldGenerator.add("Karvy", new WorldGenZAWAFlower(ZAWABlocks.KARVY_BOTTOM, ZAWABlocks.KARVY_TOP), 2, Biomes.field_76770_e, Biomes.field_76782_w, Biomes.field_76767_f);
        ZAWAWorldGenerator.add("Mimosa Pudica", new WorldGenZAWAFlower(ZAWABlocks.MIMOSA_PUDICA), 1, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Chiltepin", new WorldGenZAWAFlower(ZAWABlocks.CHILTEPIN), 1, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Onion Grass", new WorldGenZAWAFlower(ZAWABlocks.ONION_GRASS), 1, Biomes.field_150588_X, Biomes.field_76769_d);
        ZAWAWorldGenerator.add("Maireana", new WorldGenZAWAFlower(ZAWABlocks.MAIREANA), 1, Biomes.field_150588_X, Biomes.field_76769_d);
        ZAWAWorldGenerator.add("Jinn's Tongue", new WorldGenZAWAFlower(ZAWABlocks.JINNS_TONGUE), 1, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Creeping Tick Trefoil", new WorldGenZAWAFlower(ZAWABlocks.CREEPING_TICK_TREFOIL), 1, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Bassia", new WorldGenZAWAFlower(ZAWABlocks.BASSIA), 1, Biomes.field_150588_X, Biomes.field_76769_d);
        ZAWAWorldGenerator.add("Spleenwort", new WorldGenZAWAFlower(ZAWABlocks.SPLEENWORT), 1, Biomes.field_76782_w, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76781_i, Biomes.field_76780_h);
        ZAWAWorldGenerator.add("Legume", new WorldGenZAWAFlower(ZAWABlocks.LEGUME), 1, Biomes.field_150588_X, Biomes.field_76767_f, Biomes.field_76772_c);
        ZAWAWorldGenerator.add("Eugenia", new WorldGenZAWAFlower(ZAWABlocks.EUGENIA_BOTTOM, ZAWABlocks.EUGENIA_TOP), 1, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Coralberry", new WorldGenZAWAFlower(ZAWABlocks.CORALBERRY), 1, Biomes.field_76782_w);
        ZAWAWorldGenerator.add("Eucalyptus", new WorldGenZAWAFlower(ZAWABlocks.EUCALYPTUS_BOTTOM, ZAWABlocks.EUCALYPTUS_TOP), 1, Biomes.field_150588_X);
    }

    public static void add(String desc, WorldGenerator generation, int amount, Biome ... biomes) {
        generations.add(new GeneratedFlower(desc, generation, amount, biomes));
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        for (GeneratedFlower generation : generations) {
            generation.runGeneration(world, rand, blockX, blockZ);
        }
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        for (int y = 255; y >= 0; --y) {
            if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151587_i || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151579_a || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151584_j || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151582_l) continue;
            return y;
        }
        return -1;
    }
}

