/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util.book.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.base.ZAWABaseFlying;
import org.zawamod.entity.base.ZAWABaseWater;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.entity.core.UsableHandler;
import org.zawamod.entity.core.UsableObject;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.gui.GuiDataBook;
import org.zawamod.gui.element.GuiScrollingListItems;
import org.zawamod.network.ZAWAPacketHandler;
import org.zawamod.network.packets.MessageDisableAging;
import org.zawamod.network.packets.MessageDisableFlying;
import org.zawamod.network.packets.MessageReleaseAnimal;
import org.zawamod.network.packets.MessageSyncZAWA;
import org.zawamod.util.BookLoader;
import org.zawamod.util.ZAWAUtils;
import org.zawamod.util.book.data.BookContent;

public class ZooBookContent<T extends IForgeRegistryEntry<T>>
extends BookContent<T> {
    private static AbstractZawaLand animal;
    private String pageD;
    private String sci;
    private String cv;
    private String region;
    private BookLoader.BookInfo bookInfo;
    private static final ResourceLocation ENRICHMENT_MAX;
    private static final ResourceLocation ENRICHMENT_MIN;
    private static final ResourceLocation FOOD_MIN;
    private static final ResourceLocation FOOD_MAX;
    private static final ResourceLocation WATER_MAX;
    private static final ResourceLocation WATER_MIN;
    private static final ResourceLocation BABY;
    private static final ResourceLocation FLYING;
    private static final ResourceLocation FOLLOW;
    private static final ResourceLocation RELEASE;
    private static final ResourceLocation SITTING;
    private static final ResourceLocation WANDER;
    private static final ResourceLocation NO;
    private List<ItemStack> foodItems = new ArrayList<ItemStack>();
    private List<ItemStack> enrichmentItems = new ArrayList<ItemStack>();
    private GuiScrollingListItems foodGuiScrollingListItems;
    private GuiScrollingListItems enrichmentScrollingList;
    private int xButton = 0;

    @Override
    public void renderObject(GuiDataBook book, int offLeft, int offTop, float mousePosX, float mousePosY, float width, float height, float imageWidth, float imageHeight) {
        super.renderObject(book, offLeft, offTop, mousePosX, mousePosY, width, height, imageWidth, imageHeight);
        int ie = (int)((width - imageWidth) / 2.0f);
        int je = (int)((height - imageHeight) / 2.0f + 30.0f);
        ZooBookContent.drawEntityOnScreen(offLeft + 80, offTop + 100, 40, (float)(ie + 51) - mousePosX, (float)(je + 75 - 10) - mousePosY, (EntityLivingBase)animal);
    }

    public void addIconButton(GuiDataBook book, int id, int x, int y, String text, ResourceLocation resource) {
        book.getButtonList().add(new GuiDataBook.IconButton(animal, id, x + (this.xButton -= 20), y, 16, 16, text, (GuiScreen)book, resource));
    }

    public void addIconButton(GuiDataBook book, int id, int x, int y, Function<AbstractZawaLand, String> text, ResourceLocation resource) {
        book.getButtonList().add(new GuiDataBook.IconButton(animal, id, x + (this.xButton -= 20), y, 16, 16, text, (GuiScreen)book, resource));
    }

    @Override
    public void onInitGUI(final GuiDataBook book, int offLeft, int offTop) {
        super.onInitGUI(book, offLeft, offTop);
        this.xButton = 0;
        if (!(GuiDataBook.viewedObject instanceof AbstractZawaLand)) {
            return;
        }
        animal = (AbstractZawaLand)GuiDataBook.viewedObject;
        offLeft -= 120;
        if (animal.func_70909_n() && animal.isOwner((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int buttonAmount = 4;
            if (animal.func_70631_g_()) {
                ++buttonAmount;
            }
            if (animal instanceof ZAWABaseFlying) {
                ++buttonAmount;
            }
            if (animal instanceof ZAWABaseWater) {
                --buttonAmount;
            }
            int x = (int)((float)(offLeft + 400) + (float)(buttonAmount * 20) / 2.0f);
            if (animal.func_70631_g_()) {
                this.addIconButton(book, 7, x, 210 + offTop, (AbstractZawaLand a) -> (a.getEntityData().func_74767_n("NoAge") ? "Enable" : "Disable") + " aging", BABY);
            }
            if (animal instanceof ZAWABaseFlying) {
                this.addIconButton(book, 6, x, 210 + offTop, (AbstractZawaLand a) -> (a.getEntityData().func_74767_n("NoFly") ? "Enable" : "Disable") + " flying", FLYING);
            }
            this.addIconButton(book, 5, x, 210 + offTop, "Release", RELEASE);
            if (!(animal instanceof ZAWABaseWater)) {
                this.addIconButton(book, 4, x, 210 + offTop, "Follow", FOLLOW);
            }
            this.addIconButton(book, 3, x, 210 + offTop, "Wander", WANDER);
            this.addIconButton(book, 2, x, 210 + offTop, "Stay", SITTING);
        }
        BookLoader.BookInfo data = null;
        if (ZAWAMain.BOOK_INFO.containsKey(animal.getClass().getSimpleName() + ".class")) {
            data = ZAWAMain.BOOK_INFO.get(animal.getClass().getSimpleName() + ".class");
        }
        this.bookInfo = data;
        if (data != null) {
            this.pageD = data.page;
            this.sci = data.sci;
            this.cv = data.cv;
            this.region = data.region;
            if (data.variant != -1 && animal instanceof IMultiSpeciesEntity && ModuleManager.VARIANT.getVariant(animal) != 0 && data.variations.containsKey(ModuleManager.VARIANT.getVariant(animal))) {
                this.pageD = data.variations.get((Object)Integer.valueOf((int)ModuleManager.VARIANT.getVariant((AbstractZawaLand)ZooBookContent.animal))).page;
                this.sci = data.variations.get((Object)Integer.valueOf((int)ModuleManager.VARIANT.getVariant((AbstractZawaLand)ZooBookContent.animal))).sci;
                this.cv = data.variations.get((Object)Integer.valueOf((int)ModuleManager.VARIANT.getVariant((AbstractZawaLand)ZooBookContent.animal))).cv;
                this.region = data.variations.get((Object)Integer.valueOf((int)ModuleManager.VARIANT.getVariant((AbstractZawaLand)ZooBookContent.animal))).region;
            }
        }
        this.enrichmentItems.clear();
        UsableHandler.USABLES.forEach((k, v) -> {
            if (v.STYLE.equals((Object)UsableObject.Style.BLOCK) || v.STYLE.equals((Object)UsableObject.Style.ITEM)) {
                ItemStack stack = null;
                if (k instanceof Item) {
                    stack = new ItemStack((Item)k);
                } else if (k instanceof Block) {
                    stack = new ItemStack((Block)k);
                }
                if (stack != null && v.isEntityValid.apply(animal.getClass()).booleanValue()) {
                    if (v.TYPE.equals((Object)UsableObject.Type.ENRICHMENT) && v.displayInBook) {
                        this.enrichmentItems.add(stack);
                    } else if (UsableHandler.ENTITY_SPAWNABLE_ITEM_MAP.containsKey(stack.func_77973_b())) {
                        this.enrichmentItems.add(stack);
                    }
                }
            }
        });
        this.enrichmentScrollingList = new GuiScrollingListItems(mc, 130, book.field_146295_m, 40, 170, book.field_146294_l / 2 + 15, 16, book.field_146294_l, book.field_146295_m){

            @Override
            protected boolean isSelected(int index) {
                return false;
            }

            @Override
            protected int getSize() {
                return ZooBookContent.this.enrichmentItems.size();
            }

            @Override
            protected void elementClicked(int index, boolean doubleClick) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (slotIdx % 6 == 0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179142_g();
                    for (int i = 0; i < 6 && slotIdx + i < ZooBookContent.this.enrichmentItems.size(); ++i) {
                        ItemStack stack = (ItemStack)ZooBookContent.this.enrichmentItems.get(slotIdx + i);
                        if (stack == null) continue;
                        book.getItemRenderer().func_180450_b(stack, this.screenWidth / 2 + i * 17 + 25, slotTop / 6 - 6 + this.top);
                    }
                    GlStateManager.func_179101_C();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179121_F();
                }
            }

            @Override
            protected void drawBackground() {
            }
        };
        this.foodItems.clear();
        ForgeRegistries.ITEMS.getValuesCollection().forEach(item -> {
            ItemStack stack = new ItemStack(item);
            if (stack.func_77981_g()) {
                NonNullList a = NonNullList.func_191196_a();
                if (stack.func_77973_b().func_77640_w() != null) {
                    stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), a);
                    for (ItemStack ab : a) {
                        if (!animal.isFoodItem(ab)) continue;
                        this.foodItems.add(ab);
                    }
                }
            } else if (animal.isFoodItem(stack)) {
                this.foodItems.add(stack);
            }
        });
        this.foodGuiScrollingListItems = new GuiScrollingListItems(mc, 130, book.field_146295_m, 40, 170, book.field_146294_l / 2 - 140, 16, book.field_146294_l, book.field_146295_m){

            @Override
            protected boolean isSelected(int index) {
                return false;
            }

            @Override
            protected int getSize() {
                return ZooBookContent.this.foodItems.size();
            }

            @Override
            protected void elementClicked(int index, boolean doubleClick) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (slotIdx % 6 == 0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179142_g();
                    for (int i = 0; i < 6 && slotIdx + i < ZooBookContent.this.foodItems.size(); ++i) {
                        ItemStack stack = (ItemStack)ZooBookContent.this.foodItems.get(slotIdx + i);
                        if (stack == null) continue;
                        book.getItemRenderer().func_180450_b(stack, this.screenWidth / 2 + i * 17 - 130, slotTop / 6 - 6 + this.top);
                    }
                    GlStateManager.func_179101_C();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179121_F();
                }
            }

            @Override
            protected void drawBackground() {
            }
        };
    }

    @Override
    public int getTotalPages() {
        return this.bookInfo == null ? 1 : 2;
    }

    @Override
    public void drawScreen(GuiDataBook book, FontRenderer fontRenderer, int offLeft, int offTop, int parWidth, int parHeight, float partial) {
        block26: {
            block27: {
                ItemStack stack;
                int i;
                int slotTop;
                int slotIdx;
                block25: {
                    super.drawScreen(book, fontRenderer, offLeft, offTop, parWidth, parHeight, partial);
                    if (book.getPage() != 0) break block25;
                    String name = animal.func_70005_c_();
                    fontRenderer.func_78276_b(name, offLeft + 80 - fontRenderer.func_78256_a(name) / 2, offTop + 130, 0x787777);
                    if (animal.func_70909_n()) {
                        String data = GuiDataBook.zooKeeper + ": " + animal.getOwnerEntityName();
                        fontRenderer.func_78276_b(GuiDataBook.zooKeeper + ": ", offLeft + 80 - fontRenderer.func_78256_a(data) / 2, offTop + 140, 0);
                        fontRenderer.func_78276_b(animal.getOwnerEntityName(), offLeft + 80 - fontRenderer.func_78256_a(data) / 2 + fontRenderer.func_78256_a(GuiDataBook.zooKeeper + ": "), offTop + 140, 0x787777);
                        if (animal.getModules().contains(ModuleManager.DATE)) {
                            fontRenderer.func_78276_b(GuiDataBook.tamedOn + " " + ModuleManager.DATE.getTameDate(animal), offLeft + 75 - fontRenderer.func_78256_a(data) / 2, offTop + 20, 0);
                        }
                    }
                    if (ModuleManager.GENDER.entityHasModule(animal)) {
                        fontRenderer.func_78276_b(GuiDataBook.sex + ": ", offLeft + 170, offTop + 20, 0);
                        fontRenderer.func_78276_b(ModuleManager.GENDER.getGender(animal).ordinal() == 0 ? GuiDataBook.male : GuiDataBook.female, offLeft + 195, offTop + 20, ModuleManager.GENDER.getGender(animal).ordinal() == 0 ? 3897784 : 11418580);
                    }
                    if (animal instanceof IMultiSpeciesEntity) {
                        boolean flag = false;
                        IMultiSpeciesEntity data = (IMultiSpeciesEntity)((Object)animal);
                        for (Map.Entry<Integer, String> o : data.speciesData().entrySet()) {
                            if (o.getKey() != AbstractZawaLand.getVariant(animal) || o.getValue() == null) continue;
                            fontRenderer.func_78276_b(GuiDataBook.variant + ": " + AbstractZawaLand.getVariant(animal) + " (" + o.getValue() + ")", offLeft + 170, offTop + 30, 0);
                            flag = true;
                        }
                        if (!flag) {
                            fontRenderer.func_78276_b(GuiDataBook.variant + ": " + AbstractZawaLand.getVariant(animal), offLeft + 170, offTop + 30, 0);
                        }
                    } else {
                        fontRenderer.func_78276_b(GuiDataBook.variant + ": " + AbstractZawaLand.getVariant(animal), offLeft + 170, offTop + 30, 0);
                    }
                    fontRenderer.func_78276_b(GuiDataBook.trait + ": ", offLeft + 170, offTop + 40, 0);
                    fontRenderer.func_78276_b(ZAWAUtils.getTraitName(animal.getTrait().ordinal()), offLeft + 200, offTop + 40, 0x787777);
                    if (animal.getTameItem() != null) {
                        fontRenderer.func_78276_b(GuiDataBook.tamedWith + ":", offLeft + 170, offTop + 50, 0);
                        fontRenderer.func_78276_b(animal.getTameItem().func_77973_b().func_77653_i(animal.getTameItem()), offLeft + 230, offTop + 50, 0x787777);
                    }
                    if (animal.getBreedItem() != null) {
                        fontRenderer.func_78276_b(GuiDataBook.bredWith + ":", offLeft + 170, offTop + 60, 0);
                        fontRenderer.func_78276_b(animal.getBreedItem().func_77973_b().func_77653_i(animal.getBreedItem()), offLeft + 230, offTop + 60, 0x787777);
                    }
                    GlStateManager.func_179094_E();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179142_g();
                    if (animal.func_70909_n()) {
                        this.renderSection(book, fontRenderer, FOOD_MIN, FOOD_MAX, 11154474, offLeft + 185, offTop + 80, (int)ModuleManager.HUNGER.getMaxFood(), (int)Math.ceil(ModuleManager.HUNGER.getHunger(animal)));
                        this.renderSection(book, fontRenderer, WATER_MIN, WATER_MAX, 4942228, offLeft + 185, offTop + 95, (int)ModuleManager.THIRST.getMaxThirst(), (int)Math.ceil(ModuleManager.THIRST.getThirst(animal)));
                        this.renderSection(book, fontRenderer, ENRICHMENT_MIN, ENRICHMENT_MAX, 4422214, offLeft + 185, offTop + 110, (int)ModuleManager.ENRICHMENT.getMaxEnrichment(), (int)Math.ceil(ModuleManager.ENRICHMENT.getEnrichment(animal)));
                    }
                    if (animal.getIconList() != null && !animal.getIconList().getData().isEmpty()) {
                        for (int i2 = animal.getIconList().getData().size() - 1; i2 >= 0; --i2) {
                            int tempY = -25;
                            if (animal.getIconList().getData().get(i2).getStack() != null) continue;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            mc.func_110434_K().func_110577_a(animal.getIconList().getData().get(i2).getImage());
                            Gui.func_146110_a((int)(offLeft + 40 + i2 * 20), (int)(offTop + 198 + tempY), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                            GlStateManager.func_179121_F();
                            for (int z = 0; z < 16; ++z) {
                                for (int e = 0; e < 16; ++e) {
                                    if (book.mousePosX != (float)(offLeft + 40 + i2 * 20 + e) || book.mousePosY != (float)(offTop + 198 + z + tempY)) continue;
                                    book.func_146279_a(animal.getIconList().getData().get(i2).getInfo(), (int)book.mousePosX - 5, (int)book.mousePosY - 1);
                                }
                            }
                        }
                    }
                    if (animal.getIconList() != null && !animal.getIconList().getData().isEmpty()) {
                        for (int i3 = animal.getIconList().getData().size() - 1; i3 >= 0; --i3) {
                            int tempY = -25;
                            if (animal.getIconList().getData().get(i3).getStack() == null) continue;
                            book.getItemRenderer().func_180450_b(animal.getIconList().getData().get(i3).getStack(), offLeft + 40 + i3 * 20, offTop + 198 + tempY);
                            for (int z = 0; z < 16; ++z) {
                                for (int e = 0; e < 16; ++e) {
                                    if (book.mousePosX != (float)(offLeft + 40 + i3 * 20 + e) || book.mousePosY != (float)(offTop + 198 + z + tempY)) continue;
                                    book.func_146279_a(animal.getIconList().getData().get(i3).getInfo(), (int)book.mousePosX - 5, (int)book.mousePosY - 1);
                                }
                            }
                        }
                    }
                    GlStateManager.func_179121_F();
                    break block26;
                }
                if (book.getPage() != 1) break block27;
                fontRenderer.func_78276_b(GuiDataBook.diet, offLeft + 70, offTop + 20, 0);
                fontRenderer.func_78276_b(GuiDataBook.enrichment, offLeft + 210, offTop + 20, 0);
                this.enrichmentScrollingList.drawScreen(parWidth, parHeight, partial);
                int baseY = 74 - (int)this.enrichmentScrollingList.scrollDistance;
                for (slotIdx = 0; slotIdx < this.enrichmentItems.size(); ++slotIdx) {
                    slotTop = baseY + slotIdx * 16;
                    if (slotIdx % 6 != 0) continue;
                    for (i = 0; i < 6 && slotIdx + i < this.enrichmentItems.size(); ++i) {
                        stack = this.enrichmentItems.get(slotIdx + i);
                        if (stack == null || !(book.mousePosX > (float)(book.field_146294_l / 2 + i * 17 + 25)) || !(book.mousePosX < (float)(book.field_146294_l / 2 + i * 17 + 25 + 16)) || !(book.mousePosY > (float)(slotTop / 6 - 6 + 40)) || !(book.mousePosY < (float)(16 + (slotTop / 6 - 6 + 40)))) continue;
                        book.func_146279_a(stack.func_82833_r(), (int)book.mousePosX, (int)book.mousePosY);
                    }
                }
                this.foodGuiScrollingListItems.drawScreen(parWidth, parHeight, partial);
                baseY = 74 - (int)this.foodGuiScrollingListItems.scrollDistance;
                for (slotIdx = 0; slotIdx < this.foodItems.size(); ++slotIdx) {
                    slotTop = baseY + slotIdx * 16;
                    if (slotIdx % 6 != 0) continue;
                    for (i = 0; i < 6 && slotIdx + i < this.foodItems.size(); ++i) {
                        stack = this.foodItems.get(slotIdx + i);
                        if (stack == null || !(book.mousePosX > (float)(book.field_146294_l / 2 + i * 17 - 130)) || !(book.mousePosX < (float)(book.field_146294_l / 2 + i * 17 - 130 + 16)) || !(book.mousePosY > (float)(slotTop / 6 - 6 + 40)) || !(book.mousePosY < (float)(16 + (slotTop / 6 - 6 + 40)))) continue;
                        book.func_146279_a(stack.func_82833_r(), (int)book.mousePosX, (int)book.mousePosY);
                    }
                }
                break block26;
            }
            if (book.getPage() != 2 || this.bookInfo == null) break block26;
            if (this.bookInfo.variant != -1 && animal instanceof IMultiSpeciesEntity) {
                IMultiSpeciesEntity a = (IMultiSpeciesEntity)((Object)animal);
                fontRenderer.func_78276_b(GuiDataBook.variant + ":", offLeft + 10, offTop + 80, 0);
                fontRenderer.func_78276_b(a.speciesData().get(ModuleManager.VARIANT.getVariant(animal)), offLeft + 20, offTop + 90, 0x787777);
            }
            fontRenderer.func_78276_b(GuiDataBook.scientific + ":", offLeft + 10, offTop + 20, 0);
            fontRenderer.func_78276_b(this.sci, offLeft + 20, offTop + 30, 0x787777);
            fontRenderer.func_78276_b(GuiDataBook.conservation + ":", offLeft + 10, offTop + 40, 0);
            fontRenderer.func_78276_b(this.cv, offLeft + 20, offTop + 50, 0x787777);
            fontRenderer.func_78276_b(GuiDataBook.regionStr + ":", offLeft + 10, offTop + 60, 0);
            fontRenderer.func_78276_b(this.region, offLeft + 20, offTop + 70, 0x787777);
            int y = 0;
            for (String a : fontRenderer.func_78271_c(this.pageD.trim(), 150)) {
                String before = "";
                for (String b : a.split(" ")) {
                    fontRenderer.func_78276_b(b, offLeft + 165 + fontRenderer.func_78256_a(before), offTop + 20 + y, 0x2B2B2B);
                    before = before + b + " ";
                }
                y += 10;
            }
        }
    }

    @Override
    public void debugRender(GuiDataBook book, FontRenderer fontRenderer, int parWidth, int parHeight, float partial) {
        super.debugRender(book, fontRenderer, parWidth, parHeight, partial);
        int y = 35;
        fontRenderer.func_175063_a("Parent A: " + animal.getParentA(), 1.0f, (float)(y + 162), 0xE0E0E0);
        fontRenderer.func_175063_a("Parent B: " + animal.getParentB(), 1.0f, (float)(y + 172), 0xE0E0E0);
        fontRenderer.func_175063_a("Hunger: ", 1.0f, (float)(y + 152), 0xE0E0E0);
        fontRenderer.func_175063_a("" + ModuleManager.HUNGER.getHunger(animal), 41.0f, (float)(y + 152), ModuleManager.HUNGER.isHungry(animal) ? 15353629 : 0xE0E0E0);
        fontRenderer.func_175063_a("Thirst: ", 1.0f, (float)(y + 142), 0xE0E0E0);
        fontRenderer.func_175063_a("" + AbstractZawaLand.getThirst(animal), 35.0f, (float)(y + 142), ModuleManager.THIRST.isThirsty(animal) ? 15353629 : 0xE0E0E0);
        fontRenderer.func_175063_a("Saturation: " + ModuleManager.HUNGER.getSaturation(animal), 1.0f, (float)(y + 132), 0xE0E0E0);
        fontRenderer.func_175063_a("TSaturation: " + ModuleManager.THIRST.getThirstSaturation(animal), 1.0f, (float)(y + 182), 0xE0E0E0);
        fontRenderer.func_175063_a("MHealth: " + animal.func_110138_aP(), 1.0f, (float)(y + 192), 0xE0E0E0);
        if (animal.getModules().contains(ModuleManager.SCALE)) {
            fontRenderer.func_175063_a("SizeM: " + ModuleManager.SCALE.getSizeMultiplier(animal), 1.0f, (float)(y + 202), 0xE0E0E0);
        }
        fontRenderer.func_175063_a("NxtSleep: " + animal.getNextSleep(), 1.0f, (float)(y + 212), 0xE0E0E0);
        fontRenderer.func_175063_a("SleepTime: " + animal.getSleepTime() + "/" + animal.getNeededSleep(), 1.0f, (float)(y + 222), 0xE0E0E0);
        fontRenderer.func_175063_a("Blinking: " + animal.areEyesClosed(), 1.0f, (float)(y + 232), 0xE0E0E0);
        fontRenderer.func_175063_a("TicksExisted: " + ZooBookContent.animal.field_70173_aa, 1.0f, (float)(y + 242), 0xE0E0E0);
        fontRenderer.func_175063_a("Asleep: " + animal.isAsleep(), 1.0f, (float)(y + 252), 0xE0E0E0);
        fontRenderer.func_175063_a("Enrichment: ", 1.0f, (float)(y + 262), 0xE0E0E0);
        fontRenderer.func_175063_a("" + ModuleManager.ENRICHMENT.getEnrichment(animal), 60.0f, (float)(y + 262), ModuleManager.ENRICHMENT.lowEnrichment(animal) ? 15353629 : 0xE0E0E0);
        fontRenderer.func_175063_a("Health: " + animal.func_110143_aJ() + "/" + animal.func_110138_aP(), 1.0f, (float)(y + 272), 0xE0E0E0);
    }

    @Override
    public void handleMouseInput(GuiDataBook book) throws IOException {
        super.handleMouseInput(book);
        this.foodGuiScrollingListItems.handleMouseInput((int)book.mousePosX, (int)book.mousePosY);
        this.enrichmentScrollingList.handleMouseInput((int)book.mousePosX, (int)book.mousePosY);
    }

    @Override
    public void onGUIClose(GuiDataBook book) {
        super.onGUIClose(book);
        animal = null;
    }

    @Override
    public void onPageChange(GuiDataBook book) {
        super.onPageChange(book);
        if (!animal.func_70909_n()) {
            return;
        }
        if (book.getPage() == 0) {
            book.getButtonList().forEach(i -> {
                if (i.field_146127_k >= 2 && i.field_146127_k <= 7) {
                    i.field_146125_m = true;
                }
            });
        } else {
            book.getButtonList().forEach(i -> {
                if (i.field_146127_k >= 2 && i.field_146127_k <= 7) {
                    i.field_146125_m = false;
                }
            });
        }
    }

    @Override
    public void actionPerformed(GuiDataBook book, GuiButton button) {
        super.actionPerformed(book, button);
        if (button.field_146127_k == 2) {
            animal.setControl(2);
            MessageSyncZAWA msg = new MessageSyncZAWA((Entity)animal, 2);
            ZAWAPacketHandler.net.sendToServer((IMessage)msg);
        } else if (button.field_146127_k == 3) {
            animal.setControl(3);
            MessageSyncZAWA msg = new MessageSyncZAWA((Entity)animal, 3);
            ZAWAPacketHandler.net.sendToServer((IMessage)msg);
        } else if (button.field_146127_k == 4) {
            animal.setControl(1);
            MessageSyncZAWA msg = new MessageSyncZAWA((Entity)animal, 1);
            ZAWAPacketHandler.net.sendToServer((IMessage)msg);
        } else if (button.field_146127_k == 5) {
            final BookContent<?> content = GuiDataBook.viewedContent;
            final AbstractZawaLand anim = animal;
            GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)book, "Are you sure you want to release " + animal.func_70005_c_() + "?", "This animal will be tame-able by anyone.", "Release", "Cancel", 0){

                protected void func_146284_a(GuiButton button) throws IOException {
                    super.func_146284_a(button);
                    if (button.field_146127_k == 0) {
                        anim.func_184212_Q().func_187227_b(anim.getTamedParam(), (Object)((byte)((Byte)anim.func_184212_Q().func_187225_a(anim.getTamedParam()) & 0xFFFFFFFB)));
                        anim.onRelease((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                        ZAWAPacketHandler.net.sendToServer((IMessage)new MessageReleaseAnimal(anim));
                        Minecraft.func_71410_x().field_71439_g.func_71053_j();
                    } else {
                        GuiDataBook.viewedContent = content;
                        GuiDataBook.viewedObject = anim;
                        Minecraft.func_71410_x().field_71439_g.openGui((Object)ZAWAMain.instance, ZAWAMain.GUI.DATA.id, Minecraft.func_71410_x().field_71439_g.field_70170_p, (int)Math.floor(anim.field_70165_t), (int)anim.field_70163_u, (int)Math.floor(anim.field_70161_v));
                    }
                }
            };
            Minecraft.func_71410_x().func_147108_a((GuiScreen)guiyesno);
            guiyesno.func_146350_a(10);
        } else if (button.field_146127_k == 6) {
            boolean a = !animal.getEntityData().func_74767_n("NoFly");
            animal.getEntityData().func_74757_a("NoFly", a);
            ZAWAPacketHandler.net.sendToServer((IMessage)new MessageDisableFlying(animal, a));
        } else if (button.field_146127_k == 7) {
            boolean a = !animal.getEntityData().func_74767_n("NoAge");
            animal.getEntityData().func_74757_a("NoAge", a);
            ZAWAPacketHandler.net.sendToServer((IMessage)new MessageDisableAging(animal, a));
        }
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    static {
        ENRICHMENT_MAX = new ResourceLocation("zawa:textures/gui/enrichment_max.png");
        ENRICHMENT_MIN = new ResourceLocation("zawa:textures/gui/enrichment_min.png");
        FOOD_MIN = new ResourceLocation("zawa:textures/gui/food_min.png");
        FOOD_MAX = new ResourceLocation("zawa:textures/gui/apple.png");
        WATER_MAX = new ResourceLocation("zawa:textures/gui/water_max.png");
        WATER_MIN = new ResourceLocation("zawa:textures/gui/water_min.png");
        BABY = new ResourceLocation("zawa:textures/gui/icon/baby.png");
        FLYING = new ResourceLocation("zawa:textures/gui/icon/flying.png");
        FOLLOW = new ResourceLocation("zawa:textures/gui/icon/follow.png");
        RELEASE = new ResourceLocation("zawa:textures/gui/icon/release.png");
        SITTING = new ResourceLocation("zawa:textures/gui/icon/sitting.png");
        WANDER = new ResourceLocation("zawa:textures/gui/icon/wander.png");
        NO = new ResourceLocation("zawa:textures/gui/icon/x.png");
    }
}

